/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.codeception.CodeceptionCestTestCreateInfo;
import com.jetbrains.php.codeception.CodeceptionSettingsManager;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import icons.CodeceptionIcons;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeceptionUnitTestCreateInfo
implements PhpTestCreateInfo {
    public static final CodeceptionUnitTestCreateInfo INSTANCE = new CodeceptionUnitTestCreateInfo();
    public static final String TEST_SUFFIX = "Test";
    public static final String DEFAULT_TEST_DIRECTORY_SUFFIX = "unit";
    public static final String CODECEPTION_UNIT_METHOD_TEMPLATE_NAME = "Codeception Unit Test Method";

    @NotNull
    @NlsSafe
    public String getName() {
        return "Codeception Unit";
    }

    @NotNull
    public String getTemplateName() {
        return "Codeception Unit Test";
    }

    @Nullable
    public Icon getIcon() {
        return CodeceptionIcons.Codeception;
    }

    @NotNull
    @NlsSafe
    public String getDefaultTestName(@NotNull String targetClassName) {
        if (targetClassName == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(0);
        }
        String string = targetClassName + TEST_SUFFIX;
        if (string == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getTestNamespace(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String namespace, @NotNull String fromNamespace, @NotNull String path) {
        if (project == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(4);
        }
        if (fromNamespace == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(5);
        }
        if (path == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(6);
        }
        String string = CodeceptionCestTestCreateInfo.suggestTestNamespace(project, directory, DEFAULT_TEST_DIRECTORY_SUFFIX);
        if (string == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public String getTestDirectory(@NotNull Project project, @NotNull SourceFolder sourceFolder, @NotNull String toNamespace, @NotNull String fromNamespace) {
        if (project == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(8);
        }
        if (sourceFolder == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(9);
        }
        if (toNamespace == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(10);
        }
        if (fromNamespace == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(11);
        }
        return CodeceptionCestTestCreateInfo.getTestDirectory(project, sourceFolder.getFile(), DEFAULT_TEST_DIRECTORY_SUFFIX);
    }

    public boolean isConfiguredFolder(@NotNull Project project, @Nullable VirtualFile directory) {
        if (project == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(12);
        }
        return directory != null && CodeceptionSettingsManager.getInstance(project).hasMatchedConfigurations(directory.getPath());
    }

    @NotNull
    public String getTestMethodText(@NotNull Project project, @NotNull String classFqn, @NotNull String methodName) {
        if (project == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(13);
        }
        if (classFqn == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(14);
        }
        if (methodName == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(15);
        }
        String string = PhpCodeUtil.getCodeTemplate((String)CODECEPTION_UNIT_METHOD_TEMPLATE_NAME, (Properties)this.getDefaultProperties(methodName, classFqn), (Project)project);
        if (string == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean canCreateTestFor(@NotNull PhpClass clazz) {
        if (clazz == null) {
            CodeceptionUnitTestCreateInfo.$$$reportNull$$$0(17);
        }
        return !StringUtil.endsWith((CharSequence)clazz.getName(), (CharSequence)TEST_SUFFIX) && !PhpUnitUtil.extendsRootTestClass((PhpClass)clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassName";
                break;
            }
            case 1: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionUnitTestCreateInfo";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNamespace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNamespace";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionUnitTestCreateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTestName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTestName";
                break;
            }
            case 1: 
            case 7: 
            case 16: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamespace";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTestDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguredFolder";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canCreateTestFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 16 -> new IllegalStateException(string);
        };
    }
}

