/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import com.jetbrains.php.phpspec.PhpSpecTestCreateInfo;
import com.jetbrains.php.testFramework.PhpSuffixBasedTestDescriptor;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpSpecTestDescriptor
extends PhpSuffixBasedTestDescriptor {
    public static final PhpSpecTestDescriptor INSTANCE = new PhpSpecTestDescriptor();
    public static final List<String> SUFFIXES = new SmartList((Object)"Spec");
    private static final List<PhpTestCreateInfo> TEST_CREATE_INFOS = new SmartList((Object)PhpSpecTestCreateInfo.INSTANCE);

    @NotNull
    public Collection<PhpClass> findTests(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.filter((Collection)super.findTests(clazz), test -> PhpSpecTestDescriptor.isTestClass(test, clazz));
        if (list == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Collection<PhpClass> findClasses(@NotNull PhpClass test, @NotNull String testName) {
        if (test == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(2);
        }
        if (testName == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.filter((Collection)super.findClasses(test, testName), clazz -> PhpSpecTestDescriptor.isTestClass(test, clazz));
        if (list == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Collection<Method> findTests(@NotNull Method method) {
        if (method == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(5);
        }
        List<Method> list = Collections.emptyList();
        if (list == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Collection<Method> findMethods(@NotNull Method testMethod) {
        if (testMethod == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(7);
        }
        List<Method> list = Collections.emptyList();
        if (list == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    protected Collection<String> getNameSuffixes() {
        List<String> list = SUFFIXES;
        if (list == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isTestClass(@NotNull PhpClass test, @NotNull PhpClass clazz) {
        if (test == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(10);
        }
        if (clazz == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(11);
        }
        return PhpSpecSettingsManager.getInstance(clazz.getProject()).getPrefixes().stream().anyMatch(prefix -> PhpSpecTestDescriptor.isTestNamespaceSuitableForClass(clazz, test, prefix));
    }

    private static boolean isTestNamespaceSuitableForClass(@NotNull PhpClass clazz, @NotNull PhpClass test, @NotNull String namespacePrefix) {
        if (clazz == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(12);
        }
        if (test == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(13);
        }
        if (namespacePrefix == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(14);
        }
        return PhpLangUtil.equalsNamespaceNames((CharSequence)test.getNamespaceName(), (CharSequence)PhpLangUtil.toFQN((String)PhpLangUtil.concat((String)namespacePrefix, (String)clazz.getNamespaceName())));
    }

    @NotNull
    public Collection<PhpTestCreateInfo> getTestCreateInfos() {
        List<PhpTestCreateInfo> list = TEST_CREATE_INFOS;
        if (list == null) {
            PhpSpecTestDescriptor.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 8, 9, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecTestDescriptor";
                break;
            }
            case 2: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecTestDescriptor";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTests";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSuffixes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCreateInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTests";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMethods";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTestClass";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isTestNamespaceSuitableForClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 8, 9, 15 -> new IllegalStateException(string);
        };
    }
}

