/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.library;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorageKt;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.library.PhpAdditionalLibraryManager;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import com.jetbrains.php.phpspec.library.PhpSpecEntitySource;
import com.jetbrains.php.phpspec.library.PhpSpecLibraryEntity;
import com.jetbrains.php.phpspec.library.PhpSpecLibraryEntityBuilder;
import com.jetbrains.php.phpspec.library.PhpSpecLibraryEntityModifications;
import java.net.URL;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSpecLibraryService {
    private static final String PATH = "/phpspec_stub/";
    private static final EntitySource PHP_SPEC_ENTITY_SOURCE = new PhpSpecEntitySource();
    private final Project project;

    @NotNull
    public static PhpSpecLibraryService getInstance(@NotNull Project project) {
        if (project == null) {
            PhpSpecLibraryService.$$$reportNull$$$0(0);
        }
        PhpSpecLibraryService phpSpecLibraryService = (PhpSpecLibraryService)project.getService(PhpSpecLibraryService.class);
        if (phpSpecLibraryService == null) {
            PhpSpecLibraryService.$$$reportNull$$$0(1);
        }
        return phpSpecLibraryService;
    }

    public PhpSpecLibraryService(@NotNull Project project) {
        if (project == null) {
            PhpSpecLibraryService.$$$reportNull$$$0(2);
        }
        this.project = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (presentableLibraryName, oldRoots, newRoots, libraryNameForDebug) -> this.ensureLibraryRootIsUpToDate());
        connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpSpecLibraryService.this.ensureLibraryRootIsUpToDate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpspec/library/PhpSpecLibraryService$1", "changed"));
            }
        });
    }

    void projectOpened() {
        this.ensureLibraryRootIsUpToDate();
    }

    @Nullable
    public VirtualFile getIncludedRoot() {
        Sequence entities = WorkspaceModel.getInstance((Project)this.project).getCurrentSnapshot().entities(PhpSpecLibraryEntity.class);
        PhpSpecLibraryEntity entity = (PhpSpecLibraryEntity)SequencesKt.firstOrNull((Sequence)entities);
        return PhpSpecLibraryService.getIncludedRoot(entity);
    }

    @Nullable
    public static VirtualFile getIncludedRoot(@Nullable PhpSpecLibraryEntity entity) {
        return entity == null ? null : VirtualFileUrls.getVirtualFile((VirtualFileUrl)entity.getRoot());
    }

    public void ensureLibraryRootIsUpToDate() {
        StartupManager.getInstance((Project)this.project).runAfterOpened(() -> {
            DumbService service = (DumbService)ReadAction.compute(() -> {
                if (this.project.isDisposed()) {
                    return null;
                }
                return DumbService.getInstance((Project)this.project);
            });
            if (service == null) {
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> service.runReadActionInSmartMode(() -> {
                if (this.project.isDisposed()) {
                    return;
                }
                ImmutableEntityStorage entityStorage = WorkspaceModel.getInstance((Project)this.project).getCurrentSnapshot();
                VirtualFile root = this.getLibraryRoot();
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.saveUpdatedDataToWorkspaceModel(root, entityStorage));
            }));
        });
    }

    private void saveUpdatedDataToWorkspaceModel(@Nullable VirtualFile file, @NotNull ImmutableEntityStorage entityStorage) {
        if (entityStorage == null) {
            PhpSpecLibraryService.$$$reportNull$$$0(3);
        }
        List entities = SequencesKt.toList((Sequence)entityStorage.entities(PhpSpecLibraryEntity.class));
        PhpSpecLibraryEntity firstEntity = (PhpSpecLibraryEntity)CollectionsKt.firstOrNull((List)entities);
        if (file == null && firstEntity == null) {
            return;
        }
        if (file != null && firstEntity != null && entities.size() == 1 && file.equals(VirtualFileUrls.getVirtualFile((VirtualFileUrl)firstEntity.getRoot()))) {
            return;
        }
        MutableEntityStorage preliminaryBuilder = EntityStorageKt.toBuilder((ImmutableEntityStorage)entityStorage);
        for (int i = 1; i < entities.size(); ++i) {
            preliminaryBuilder.removeEntity((WorkspaceEntity)entities.get(i));
        }
        if (file == null) {
            preliminaryBuilder.removeEntity((WorkspaceEntity)firstEntity);
        } else {
            VirtualFileUrlManager fileUrlManager = WorkspaceModel.getInstance((Project)this.project).getVirtualFileUrlManager();
            VirtualFileUrl url = fileUrlManager.getOrCreateFromUrl(file.getUrl());
            if (firstEntity == null) {
                preliminaryBuilder.addEntity((WorkspaceEntity.Builder)PhpSpecLibraryEntityModifications.createPhpSpecLibraryEntity(url, PHP_SPEC_ENTITY_SOURCE));
            } else {
                preliminaryBuilder.modifyEntity(PhpSpecLibraryEntityBuilder.class, (WorkspaceEntity)firstEntity, specLibraryEntity -> {
                    specLibraryEntity.setRoot(url);
                    return Unit.INSTANCE;
                });
            }
        }
        PhpAdditionalLibraryManager.modifyWorkspaceModel((Project)this.project, (String)"Updating PhpSpec entity", storage -> {
            storage.applyChangesFrom(preliminaryBuilder);
            return Unit.INSTANCE;
        });
    }

    @Nullable
    private VirtualFile getLibraryRoot() {
        VirtualFile root;
        URL url;
        if (PhpSpecSettingsManager.getInstance(this.project).isEnabled() && (url = PhpSpecLibraryService.class.getResource(PATH)) != null && (root = VfsUtil.findFileByURL((URL)url)) != null && root.isDirectory()) {
            assert (this.project.isInitialized()) : "getLibraryRoot() should be invoked after project initialization";
            assert (!DumbService.getInstance((Project)this.project).isDumb()) : "getLibraryRoot() should not be run in dumb mode";
            boolean present = PhpIndex.getInstance((Project)this.project).getAnyByFQN("\\PhpSpec\\Wrapper\\Subject").stream().filter(c -> c.findOwnMethodByName((CharSequence)"shouldReturn") != null && c.getContainingFile() != null).map(c -> c.getContainingFile().getVirtualFile()).anyMatch(file -> file != null && !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false));
            if (!present) {
                return root;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/library/PhpSpecLibraryService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/library/PhpSpecLibraryService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveUpdatedDataToWorkspaceModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static class PhpSpecLibraryStartupActivity
    implements StartupActivity.DumbAware {
        PhpSpecLibraryStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                PhpSpecLibraryStartupActivity.$$$reportNull$$$0(0);
            }
            PhpSpecLibraryService.getInstance(project).projectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/phpspec/library/PhpSpecLibraryService$PhpSpecLibraryStartupActivity", "runActivity"));
        }
    }
}

