/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.eval.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.GotItTooltip;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.eval.Php3v4lInterpretersService;
import com.jetbrains.php.eval.scratch.PhpEvalCopyLinkAction;
import com.jetbrains.php.eval.scratch.PhpEvalOpenLinkInBrowserAction;
import com.jetbrains.php.eval.scratch.PhpEvalVersionsToRunComboBoxAction;
import com.jetbrains.php.eval.scratch.PhpRunEvalScratchFileAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public final class PhpEvalScratchFileEditorWithPreview
extends TextEditorWithPreview
implements TextEditor {
    private volatile boolean myIsWaitingForResponse;
    private Php3v4lInterpretersService.Php3v4lInterpreterVersion myVersion;
    private String myCurrentUrl;
    private final Collection<Inlay<EditorCustomElementRenderer>> myInlays;
    private final Php3v4lInterpretersService interpretersService;
    BackgroundableProcessIndicator myIndicator;

    public PhpEvalScratchFileEditorWithPreview(@NotNull TextEditor editor, @NotNull TextEditor preview) {
        if (editor == null) {
            PhpEvalScratchFileEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            PhpEvalScratchFileEditorWithPreview.$$$reportNull$$$0(1);
        }
        super(editor, (FileEditor)preview, "TextEditorWithPreview", TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW, false, TextEditorWithPreview.Layout.SHOW_EDITOR);
        this.myInlays = new ArrayList<Inlay<EditorCustomElementRenderer>>();
        this.myVersion = PhpEvalVersionsToRunComboBoxAction.ALL_VERSIONS;
        Project project = Objects.requireNonNull(editor.getEditor().getProject());
        this.interpretersService = (Php3v4lInterpretersService)project.getService(Php3v4lInterpretersService.class);
    }

    private void installPromotionTooltip(@NotNull ActionToolbar actionToolbar) {
        if (actionToolbar == null) {
            PhpEvalScratchFileEditorWithPreview.$$$reportNull$$$0(2);
        }
        GotItTooltip tooltip = new GotItTooltip(PhpBundle.message((String)"action.run.on.3v4l.org.text", (Object[])new Object[0]), PhpBundle.message((String)"action.run.on.3v4l.org.promotion.tooltip", (Object[])new Object[0]), (Disposable)this);
        tooltip.withShowCount(1);
        tooltip.withHeader(PhpBundle.message((String)"action.run.on.3v4l.org.text", (Object[])new Object[0]));
        tooltip.withIcon(AllIcons.General.BalloonInformation);
        tooltip.show(actionToolbar.getComponent(), GotItTooltip.BOTTOM_MIDDLE);
    }

    public void setLayout(@NotNull TextEditorWithPreview.Layout layout) {
        if (layout == null) {
            PhpEvalScratchFileEditorWithPreview.$$$reportNull$$$0(3);
        }
        super.setLayout(layout);
    }

    @NotNull
    protected ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        PhpRunEvalScratchFileAction evalAction = new PhpRunEvalScratchFileAction(this);
        group.add((AnAction)evalAction);
        PhpEvalVersionsToRunComboBoxAction versionsAction = new PhpEvalVersionsToRunComboBoxAction(this);
        group.add((AnAction)versionsAction);
        group.addSeparator();
        group.add((AnAction)new PhpEvalOpenLinkInBrowserAction(this));
        group.add((AnAction)new PhpEvalCopyLinkAction(this));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)group, true);
        this.installPromotionTooltip(actionToolbar);
        this.interpretersService.withVersions((Function1<? super List<Php3v4lInterpretersService.Php3v4lInterpretersGroup>, Unit>)((Function1)versions2 -> {
            evalAction.setEnabled(true);
            versionsAction.populateActionsGroup((List<Php3v4lInterpretersService.Php3v4lInterpretersGroup>)versions2);
            versionsAction.enable();
            actionToolbar.updateActionsAsync();
            return Unit.INSTANCE;
        }));
        ActionToolbar actionToolbar2 = actionToolbar;
        if (actionToolbar2 == null) {
            PhpEvalScratchFileEditorWithPreview.$$$reportNull$$$0(4);
        }
        return actionToolbar2;
    }

    public void setVersion(@NotNull Php3v4lInterpretersService.Php3v4lInterpreterVersion version) {
        if (version == null) {
            PhpEvalScratchFileEditorWithPreview.$$$reportNull$$$0(5);
        }
        this.myVersion = version;
    }

    @NotNull
    public Php3v4lInterpretersService.Php3v4lInterpreterVersion getVersion() {
        Php3v4lInterpretersService.Php3v4lInterpreterVersion php3v4lInterpreterVersion = this.myVersion;
        if (php3v4lInterpreterVersion == null) {
            PhpEvalScratchFileEditorWithPreview.$$$reportNull$$$0(6);
        }
        return php3v4lInterpreterVersion;
    }

    public void setCurrentUrl(String url) {
        this.myCurrentUrl = url;
    }

    @NlsSafe
    public String getCurrentUrl() {
        return this.myCurrentUrl;
    }

    public boolean isWaitingForResponse() {
        return this.myIsWaitingForResponse;
    }

    public void setWaitingForResponse(boolean waitingForResponse) {
        this.myIsWaitingForResponse = waitingForResponse;
    }

    public void addInlay(Inlay<EditorCustomElementRenderer> inlay) {
        this.myInlays.add(inlay);
    }

    public void disposeAllInlays() {
        for (Inlay<EditorCustomElementRenderer> inlay : this.myInlays) {
            Disposer.dispose(inlay);
        }
    }

    public void dispose() {
        this.disposeAllInlays();
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
        }
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToolbar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/eval/scratch/PhpEvalScratchFileEditorWithPreview";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/eval/scratch/PhpEvalScratchFileEditorWithPreview";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installPromotionTooltip";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLayout";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

