/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.twig.TwigBackspaceHandler;
import com.jetbrains.twig.TwigConfiguration;
import com.jetbrains.twig.TwigFileViewProvider;
import com.jetbrains.twig.TwigSmartKeysConfiguration;
import com.jetbrains.twig.formatter.TwigFormatterOptions;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigTypedHandler
extends TypedHandlerDelegate {
    public String getEndDelimiter(Project project, Document document, int offset, char typedChar) {
        String delimiter = this.getEndDelimiter(document, offset, TwigConfiguration.getInstance(project).getState().getBlockStartDelimiter(), TwigConfiguration.getInstance(project).getState().getBlockEndDelimiter(), typedChar);
        if (delimiter == null) {
            delimiter = this.getEndDelimiter(document, offset, TwigConfiguration.getInstance(project).getState().getVariableStartDelimiter(), TwigConfiguration.getInstance(project).getState().getVariableEndDelimiter(), typedChar);
        }
        if (delimiter == null) {
            delimiter = this.getEndDelimiter(document, offset, TwigConfiguration.getInstance(project).getState().getDocStartDelimiter(), TwigConfiguration.getInstance(project).getState().getDocEndDelimiter(), typedChar);
        }
        return delimiter;
    }

    @Nullable
    public String getEndDelimiter(Document document, int offset, String startDelimiter, String endDelimiter, char typedChar) {
        int length = startDelimiter.length();
        if (typedChar != startDelimiter.charAt(length - 1)) {
            return null;
        }
        for (int i = 1; i < length; ++i) {
            if (startDelimiter.charAt(length - i - 1) == TwigTypedHandler.getCharAt(document, offset - i)) continue;
            return null;
        }
        return endDelimiter;
    }

    public String getStringToInsert(Document document, int offset, String endDelimiter) {
        StringBuilder scanAheadForEndDelimiterStringBuilder = new StringBuilder();
        while (TwigTypedHandler.getCharAt(document, offset) == ' ') {
            ++offset;
        }
        for (int i = offset; i < endDelimiter.length() + offset; ++i) {
            scanAheadForEndDelimiterStringBuilder.append(TwigTypedHandler.getCharAt(document, i));
        }
        if (endDelimiter.contentEquals(scanAheadForEndDelimiterStringBuilder)) {
            return "";
        }
        if (endDelimiter.length() >= 2 && endDelimiter.substring(1).equals(scanAheadForEndDelimiterStringBuilder.substring(0, scanAheadForEndDelimiterStringBuilder.length() - 1))) {
            return endDelimiter.substring(0, 1);
        }
        return endDelimiter;
    }

    private static int getSingleClosedBrace(@NotNull Editor editor, int offset, char c) {
        int closedBrace;
        if (editor == null) {
            TwigTypedHandler.$$$reportNull$$$0(0);
        }
        if (c == '}') {
            return -1;
        }
        String text = editor.getDocument().getText();
        if (offset > 0 && text.charAt(offset - 1) == '{' && (closedBrace = TwigTypedHandler.getIndexOfMirrorBrace(text, '{', offset - 1, text.length())) > 0 && (text.length() <= closedBrace + 1 || text.length() > closedBrace + 1 && text.charAt(closedBrace + 1) != '}') && !TwigBackspaceHandler.MIRROR_CHARS.containsKey(Character.valueOf(text.charAt(closedBrace - 1)))) {
            return closedBrace;
        }
        return -1;
    }

    private static int getSingleOpenedBrace(@NotNull Editor editor, int offset, char c) {
        int openedBrace;
        if (editor == null) {
            TwigTypedHandler.$$$reportNull$$$0(1);
        }
        if (c == '{') {
            return -1;
        }
        String text = editor.getDocument().getText();
        if (text.length() > offset && text.charAt(offset) == '}' && ((openedBrace = TwigTypedHandler.getIndexOfMirrorBrace(text, '}', offset, -1)) == 0 || openedBrace > 0 && text.charAt(openedBrace - 1) != '{') && (text.length() <= openedBrace + 1 || text.length() > openedBrace + 1 && !TwigBackspaceHandler.MIRROR_CHARS.containsKey(Character.valueOf(text.charAt(openedBrace + 1))))) {
            return openedBrace;
        }
        return -1;
    }

    private static int getIndexOfMirrorBrace(String text, char brace, int start, int end) {
        text = text.replaceAll("\\\\[\"']", "  ");
        boolean reverseTraversal = start > end;
        boolean betweenSingleQuotes = false;
        boolean betweenDoubleQuotes = false;
        int counter = 0;
        while (start != end) {
            char c = text.charAt(start);
            if (!betweenSingleQuotes && !betweenDoubleQuotes) {
                if (c == brace) {
                    ++counter;
                }
                if (c == TwigBackspaceHandler.MIRROR_CHARS.get(Character.valueOf(brace)).charValue() && --counter == 0) {
                    return start;
                }
            }
            if (c == '\"') {
                boolean bl = betweenDoubleQuotes = !betweenDoubleQuotes;
            }
            if (c == '\'') {
                boolean bl = betweenSingleQuotes = !betweenSingleQuotes;
            }
            if (reverseTraversal) {
                --start;
                continue;
            }
            ++start;
        }
        return -1;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Function<TwigFormatterOptions, String> spacingStrategy;
        if (project == null) {
            TwigTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            TwigTypedHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            TwigTypedHandler.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            TwigTypedHandler.$$$reportNull$$$0(5);
        }
        if (!(file.getViewProvider() instanceof TwigFileViewProvider)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        if (TwigBackspaceHandler.MIRROR_CHARS.containsKey(Character.valueOf(c)) && TwigBackspaceHandler.getEndDelimiterOffset(editor, c, offset + 1) <= 0 && TwigSmartKeysConfiguration.getInstance().isSyncDelimiterEditing()) {
            int singleClosedBrace = TwigTypedHandler.getSingleClosedBrace(editor, offset, c);
            if (singleClosedBrace > 0) {
                document.insertString(singleClosedBrace, (CharSequence)String.valueOf(TwigBackspaceHandler.MIRROR_CHARS.get(Character.valueOf(c))));
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    TwigTypedHandler.$$$reportNull$$$0(7);
                }
                return result;
            }
            int singleOpenedBrace = TwigTypedHandler.getSingleOpenedBrace(editor, offset, c);
            if (singleOpenedBrace >= 0) {
                document.insertString(singleOpenedBrace + 1, (CharSequence)String.valueOf(TwigBackspaceHandler.MIRROR_CHARS.get(Character.valueOf(c))));
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    TwigTypedHandler.$$$reportNull$$$0(8);
                }
                return result;
            }
        }
        if ((spacingStrategy = TwigTypedHandler.getSpacingStrategy(c, project)) == null) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(9);
            }
            return result;
        }
        String endDelimiter = this.getEndDelimiter(project, editor.getDocument(), offset, c);
        if (endDelimiter != null && TwigSmartKeysConfiguration.getInstance().isClosingDelimiterAutoInsertion()) {
            TwigFormatterOptions settings = (TwigFormatterOptions)CodeStyle.getCustomSettings((PsiFile)file, TwigFormatterOptions.class);
            StringBuilder stringToInsert = new StringBuilder();
            stringToInsert.append(c);
            String spaceChar = spacingStrategy.apply(settings);
            if (TwigSmartKeysConfiguration.getInstance().isSyncDelimiterEditing()) {
                stringToInsert.append(spaceChar);
                if (TwigTypedHandler.getCharAt(editor.getDocument(), offset) != ' ') {
                    stringToInsert.append(spaceChar);
                }
                stringToInsert.append(this.getStringToInsert(editor.getDocument(), offset, endDelimiter));
            }
            TwigTypedHandler.typeInStringAndMoveCaret(editor, stringToInsert.toString(), 1 + spaceChar.length());
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(editor.getDocument());
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(10);
            }
            return result;
        }
        if (endDelimiter != null) {
            TwigTypedHandler.typeInStringAndMoveCaret(editor, String.valueOf(c), 1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                TwigTypedHandler.$$$reportNull$$$0(11);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            TwigTypedHandler.$$$reportNull$$$0(12);
        }
        return result;
    }

    private static char getCharAt(Document document, int offset) {
        if (offset >= document.getTextLength() || offset < 0) {
            return '\u0000';
        }
        return document.getCharsSequence().charAt(offset);
    }

    private static void typeInStringAndMoveCaret(Editor editor, String str, int caretShift) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)str, (boolean)true, (int)caretShift);
    }

    @Nullable
    private static Function<TwigFormatterOptions, String> getSpacingStrategy(char c, @NotNull Project project) {
        if (project == null) {
            TwigTypedHandler.$$$reportNull$$$0(13);
        }
        String typedChar = String.valueOf(c);
        TwigConfiguration.TwigLexerProperties twigConfig = TwigConfiguration.getInstance(project).getState();
        if (twigConfig.getBlockStartDelimiter().endsWith(typedChar)) {
            return codeStyle -> codeStyle.SPACES_INSIDE_DELIMITERS ? " " : "";
        }
        if (twigConfig.getVariableStartDelimiter().endsWith(typedChar)) {
            return codeStyle -> codeStyle.SPACES_INSIDE_VARIABLE_DELIMITERS ? " " : "";
        }
        if (twigConfig.getDocStartDelimiter().endsWith(typedChar)) {
            return codeStyle -> codeStyle.SPACES_INSIDE_COMMENTS_DELIMITERS ? " " : "";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/twig/TwigTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/twig/TwigTypedHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSingleClosedBrace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSingleOpenedBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingStrategy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

