/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.patterns.RuleFilter;

public class RuleFilterCreator {
    private static final RuleFilterCreator INSTANCE = new RuleFilterCreator();
    private final Map<Class<?>, RuleFilter> myFilterCache = new ConcurrentHashMap();

    private RuleFilterCreator() {
    }

    public RuleFilter getFilter(String className) {
        try {
            Class<?> aClass = JLanguageTool.getClassBroker().forName(className);
            return this.myFilterCache.computeIfAbsent(aClass, clazz -> {
                Constructor<?>[] constructors = clazz.getConstructors();
                if (constructors.length != 1) {
                    throw new RuntimeException("Constructor of filter class '" + className + "' must have exactly one constructor, but it has " + constructors.length);
                }
                Constructor<?> constructor = constructors[0];
                try {
                    if (constructor.getParameterTypes().length != 0) {
                        throw new RuntimeException("Constructor of filter class '" + className + "' must not have arguments: " + String.valueOf(constructor));
                    }
                    Object filter = constructor.newInstance(new Object[0]);
                    if (filter instanceof RuleFilter) {
                        return (RuleFilter)filter;
                    }
                    throw new RuntimeException("Filter class '" + className + "' must implement interface " + RuleFilter.class.getSimpleName());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create filter class using constructor " + String.valueOf(constructor), e);
                }
            });
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find filter class: '" + className + "' - make sure to use a fully qualified class name like 'org.languagetool.rules.MyFilter'");
        }
    }

    @NotNull
    public static RuleFilterCreator getInstance() {
        return INSTANCE;
    }
}

