/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.codeStyle;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpPredefinedCodeStyleBase;
import com.jetbrains.php.refactoring.PhpNameStyle;

public class WordPressPredefinedCodeStyle
extends PhpPredefinedCodeStyleBase {
    public WordPressPredefinedCodeStyle() {
        super("WordPress");
    }

    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
        commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = false;
        commonSettings.CLASS_BRACE_STYLE = 1;
        commonSettings.METHOD_BRACE_STYLE = 1;
        commonSettings.BRACE_STYLE = 1;
        commonSettings.ALIGN_MULTILINE_CHAINED_METHODS = true;
        commonSettings.ALIGN_MULTILINE_PARAMETERS = false;
        commonSettings.ALIGN_MULTILINE_FOR = false;
        commonSettings.ALIGN_MULTILINE_BINARY_OPERATION = true;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = true;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_BEFORE_IF_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
        commonSettings.SPACE_BEFORE_QUEST = true;
        commonSettings.SPACE_AFTER_QUEST = true;
        commonSettings.SPACE_BEFORE_COLON = true;
        commonSettings.SPACE_AFTER_COLON = true;
        commonSettings.BLANK_LINES_AROUND_FIELD = 0;
        commonSettings.BLANK_LINES_AROUND_METHOD = 1;
        commonSettings.SPACE_WITHIN_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = true;
        commonSettings.SPACE_AFTER_TYPE_CAST = true;
        commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
        commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
        commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
        commonSettings.PARENTHESES_EXPRESSION_LPAREN_WRAP = true;
        commonSettings.PARENTHESES_EXPRESSION_RPAREN_WRAP = true;
        commonSettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE = true;
        commonSettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE = true;
        commonSettings.ARRAY_INITIALIZER_WRAP = 5;
        commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
        commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
        commonSettings.ELSE_ON_NEW_LINE = false;
        commonSettings.SPECIAL_ELSE_IF_TREATMENT = true;
        commonSettings.IF_BRACE_FORCE = 3;
        commonSettings.DOWHILE_BRACE_FORCE = 3;
        commonSettings.WHILE_BRACE_FORCE = 3;
        commonSettings.FOR_BRACE_FORCE = 3;
        commonSettings.WHILE_ON_NEW_LINE = false;
        commonSettings.INDENT_CASE_FROM_SWITCH = true;
        phpSettings.ALIGN_KEY_VALUE_PAIRS = true;
        phpSettings.ALIGN_ASSIGNMENTS = true;
        phpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = true;
        phpSettings.LOWER_CASE_BOOLEAN_CONST = true;
        phpSettings.LOWER_CASE_NULL_CONST = true;
        phpSettings.BLANK_LINES_BEFORE_RETURN_STATEMENT = 1;
        phpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = true;
        phpSettings.CONCAT_SPACES = true;
        phpSettings.VARIABLE_NAMING_STYLE = PhpNameStyle.Style.SNAKE_CASE;
        indentOptions.TAB_SIZE = 4;
        indentOptions.INDENT_SIZE = 4;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.USE_TAB_CHARACTER = true;
        indentOptions.SMART_TABS = true;
        phpSettings.SPACES_AROUND_VAR_WITHIN_BRACKETS = true;
        phpSettings.SPACE_BEFORE_UNARY_NOT = true;
        phpSettings.SPACE_AFTER_UNARY_NOT = true;
        phpSettings.GETTERS_SETTERS_NAMING_STYLE = PhpNameStyle.Style.SNAKE_CASE;
    }
}

