/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.injection.PhpInjectionExternalFragmentSubstProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import com.jetbrains.php.wordpress.injection.WordPressTablePrefixInstanceIndex;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class WordPressInjectionExternalFragmentSubstProvider
implements PhpInjectionExternalFragmentSubstProvider {
    @Nullable
    public String getExtFragmentSubst(ASTNode fragment, PsiElement context, Language language) {
        WPDataService service = WPDataService.getInstance(context.getProject());
        if (!service.isEnabled()) {
            return null;
        }
        String text = fragment.getText();
        String prefix = WordPressInjectionExternalFragmentSubstProvider.tryGetFromPrefix(fragment, context);
        if (prefix != null) {
            return prefix;
        }
        if (text.startsWith("$wpdb->")) {
            return text.replaceAll("\\$wpdb->", "wp_");
        }
        if (text.startsWith("__(")) {
            return text.replaceAll("__", "");
        }
        return null;
    }

    @Nullable
    private static String tryGetFromPrefix(ASTNode fragment, PsiElement context) {
        PsiElement psi = fragment.getPsi();
        if (psi instanceof Variable) {
            psi = ((Variable)psi).getFirstPsiChild();
        }
        if (psi instanceof FieldReference && PhpLangUtil.equalsFieldNames((CharSequence)"prefix", (CharSequence)((FieldReference)psi).getName()) && ContainerUtil.exists((Iterable)((FieldReference)psi).multiResolveStrict(Field.class), f -> f.getFQN().equals("\\wpdb.$prefix"))) {
            Ref res = new Ref();
            PhpFlatCollectionIndexBase.processValues(WordPressTablePrefixInstanceIndex.KEY, (file, v) -> {
                String item = (String)ContainerUtil.getFirstItem((Collection)v);
                if (item != null) {
                    res.set((Object)item);
                    return false;
                }
                return true;
            }, (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject()));
            if (!res.isNull()) {
                return (String)res.get();
            }
        }
        return null;
    }
}

