/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor.enterHandlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import org.jetbrains.annotations.NotNull;

public abstract class PhpEnterHandlerBase
implements PhpTokenTypes {
    public abstract boolean beforeEnter(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull DataContext var3, @NotNull Project var4, @NotNull Document var5, int var6, int var7, @NotNull PsiElement var8);

    public abstract EnterHandlerDelegate.Result getNextAction();

    protected static int indentLine(@NotNull Project project, @NotNull Document document, int lineNumber) {
        if (project == null) {
            PhpEnterHandlerBase.$$$reportNull$$$0(0);
        }
        if (document == null) {
            PhpEnterHandlerBase.$$$reportNull$$$0(1);
        }
        if (0 > lineNumber || lineNumber >= document.getLineCount()) {
            return -1;
        }
        int[] offset = new int[1];
        ApplicationManager.getApplication().runWriteAction(() -> {
            offset[0] = CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, document.getLineStartOffset(lineNumber));
        });
        return offset[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/lang/editor/enterHandlers/PhpEnterHandlerBase";
        objectArray[2] = "indentLine";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class CommentInserter {
        private final Project project;
        private final Document document;
        private final Editor editor;
        private int currLine;
        private boolean changesMade;

        CommentInserter(Project project, Document document, Editor editor, int startLine) {
            this.project = project;
            this.document = document;
            this.editor = editor;
            this.currLine = startLine;
            this.changesMade = false;
        }

        public Project getProject() {
            return this.project;
        }

        public Editor getEditor() {
            return this.editor;
        }

        public Document getDocument() {
            return this.document;
        }

        public int getCurrentLine() {
            return this.currLine;
        }

        public void insertLine(String whitespaceBefore, String newCommentLine, boolean extraWs, boolean doIndent, String prefix) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)this.editor, (String)("\n" + whitespaceBefore + (extraWs ? " " : "") + prefix + newCommentLine));
            ++this.currLine;
            int finalLine = this.currLine;
            this.changesMade = true;
            if (doIndent) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.document);
                PsiDocumentManager.getInstance((Project)this.project).performForCommittedDocument(this.document, () -> PhpEnterHandlerBase.indentLine(this.project, this.document, finalLine));
            }
        }

        public void insertLine(String newCommentLine, String prefix) {
            this.insertLine("", newCommentLine, true, true, prefix);
        }

        public void commitChanges() {
            if (this.changesMade) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.document);
                this.changesMade = false;
            }
        }
    }
}

