/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor.enterHandlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.formatting.LineWrappingUtil;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.editor.enterHandlers.PhpEnterHandlerBase;
import com.jetbrains.php.lang.lexer.PhpStringLiteralLexer;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInStringEnterHandler
extends PhpEnterHandlerBase {
    @Override
    public boolean beforeEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext, @NotNull Project project, @NotNull Document document, int lineNumber, int caret, @NotNull PsiElement elementAt) {
        Boolean isFormatting;
        char newQuote;
        Boolean isSmartEnterData;
        if (file == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(3);
        }
        if (document == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(4);
        }
        if (elementAt == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(5);
        }
        boolean isSmartEnter = (isSmartEnterData = (Boolean)DataManager.getInstance().loadFromDataContext(dataContext, SplitLineAction.SPLIT_LINE_KEY)) != null && isSmartEnterData != false;
        ASTNode node = elementAt.getNode();
        if (node == null) {
            return false;
        }
        ASTNode outerStringNode = PhpInStringEnterHandler.getOuterStringElement(node);
        IElementType nodeType = node.getElementType();
        String binary = "";
        StringLiteralExpression outerString = BasicPhpPsiUtil.getParentOfClass(elementAt, StringLiteralExpression.class);
        if (outerString != null) {
            if (outerString.getText().startsWith("b")) {
                binary = "b";
            }
            if (outerString.getText().startsWith("B")) {
                binary = "B";
            }
        }
        char c = newQuote = !BasicPhpPsiUtil.isOfType(node, STRING_LITERAL_SINGLE_QUOTE) && !BasicPhpPsiUtil.isOfType(node, chLSINGLE_QUOTE) ? (char)'\"' : '\'';
        if (outerStringNode == null || !PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS.isSupported(project) && PhpInStringEnterHandler.isClassField(outerStringNode) || PhpInStringEnterHandler.isStatic(outerStringNode) || PhpInStringEnterHandler.isParamDefaultValue(outerStringNode)) {
            return isSmartEnter;
        }
        if (nodeType != STRING_LITERAL_SINGLE_QUOTE) {
            if (PhpInStringEnterHandler.isEscape(elementAt, caret, false)) {
                return isSmartEnter;
            }
            if (!PhpInStringEnterHandler.canBeSplitRightBraceCase(outerStringNode) || !PhpInStringEnterHandler.canBeSplitInsideNonLiteral(outerStringNode, caret) || node.getElementType() == chLBRACE || node.getElementType() == DOLLAR_LBRACE) {
                return isSmartEnter;
            }
            if (caret == outerStringNode.getTreeParent().getTextRange().getEndOffset()) {
                return isSmartEnter;
            }
        }
        if ((isFormatting = (Boolean)DataManager.getInstance().loadFromDataContext(dataContext, LineWrappingUtil.WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY)) != null && isFormatting.equals(Boolean.TRUE) || isSmartEnter) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)(newQuote + " .\n" + binary + newQuote));
            PhpInStringEnterHandler.indentLine(project, document, lineNumber + 1);
            return true;
        }
        return false;
    }

    @Override
    public EnterHandlerDelegate.Result getNextAction() {
        return EnterHandlerDelegate.Result.Stop;
    }

    @Nullable
    private static ASTNode getOuterStringElement(@NotNull ASTNode elementNode) {
        if (elementNode == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(6);
        }
        ASTNode outerStringNode = elementNode;
        ASTNode parentNode = outerStringNode.getTreeParent();
        if (elementNode.getElementType() != STRING_LITERAL_SINGLE_QUOTE) {
            while (parentNode != null && parentNode.getElementType() != PhpElementTypes.STRING) {
                outerStringNode = parentNode;
                parentNode = outerStringNode.getTreeParent();
            }
        }
        if (parentNode == null) {
            return null;
        }
        return outerStringNode;
    }

    private static boolean isParamDefaultValue(@NotNull ASTNode node) {
        if (node == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(7);
        }
        return BasicPhpPsiUtil.getParentByCondition(node.getPsi(), (Condition<? super PsiElement>)((Condition)element -> BasicPhpPsiUtil.isOfType(element, PhpElementTypes.PARAMETER_DEFAULT_VALUE)), Function.INSTANCEOF) != null;
    }

    private static boolean isStatic(@NotNull ASTNode node) {
        if (node == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(8);
        }
        return BasicPhpPsiUtil.getParentByCondition(node.getPsi(), (Condition<? super PsiElement>)((Condition)element -> element instanceof PhpStaticStatement)) != null;
    }

    private static boolean isClassField(@NotNull ASTNode node) {
        if (node == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(9);
        }
        return BasicPhpPsiUtil.getParentByCondition(node.getPsi(), (Condition<? super PsiElement>)((Condition)element -> BasicPhpPsiUtil.isOfType(element, (IElementType)PhpStubElementTypes.CLASS_FIELD) || BasicPhpPsiUtil.isOfType(element, (IElementType)PhpStubElementTypes.CLASS_CONST)), PhpClass.INSTANCEOF) != null;
    }

    private static boolean canBeSplitRightBraceCase(@NotNull ASTNode node) {
        ASTNode next;
        if (node == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(10);
        }
        if ((next = node.getTreeNext()) != null) {
            return !PhpInStringEnterHandler.siblingIsRightBrace(next);
        }
        return true;
    }

    private static boolean canBeSplitInsideNonLiteral(@NotNull ASTNode node, int caret) {
        if (node == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(11);
        }
        if (PhpInStringEnterHandler.isStringLiteral(node)) {
            return true;
        }
        return node.getTextRange().getEndOffset() <= caret;
    }

    private static boolean isStringLiteral(@NotNull ASTNode node) {
        IElementType type;
        if (node == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(12);
        }
        return (type = node.getElementType()) == STRING_LITERAL || type == STRING_LITERAL_SINGLE_QUOTE;
    }

    private static boolean siblingIsRightBrace(@NotNull ASTNode sibling) {
        if (sibling == null) {
            PhpInStringEnterHandler.$$$reportNull$$$0(13);
        }
        if (sibling.getElementType() == chRBRACE) {
            return true;
        }
        ASTNode nextSibling = sibling.getTreeNext();
        if (nextSibling != null && sibling.getPsi() instanceof PsiWhiteSpace) {
            return nextSibling.getElementType() == chRBRACE;
        }
        return false;
    }

    private static boolean isEscape(PsiElement elementAt, int caret, boolean isSingleLiteral) {
        PhpStringLiteralLexer lexer = isSingleLiteral ? new PhpStringLiteralLexer(STRING_LITERAL_SINGLE_QUOTE, 1) : new PhpStringLiteralLexer(STRING_LITERAL, 2);
        TextRange range = elementAt.getTextRange();
        String text = elementAt.getText();
        lexer.start(text);
        LexerPosition prevPos = lexer.getCurrentPosition();
        LexerPosition currentPos = lexer.getCurrentPosition();
        while (currentPos.getOffset() + range.getStartOffset() < caret) {
            lexer.advance();
            prevPos = currentPos;
            currentPos = lexer.getCurrentPosition();
        }
        lexer.restore(prevPos);
        if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) {
            return lexer.getTokenEnd() != caret - range.getStartOffset();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementNode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/editor/enterHandlers/PhpInStringEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeEnter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOuterStringElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isParamDefaultValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isStatic";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassField";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeSplitRightBraceCase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeSplitInsideNonLiteral";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringLiteral";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "siblingIsRightBrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

