/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.BasicPhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAlignmentProcessor
extends PhpFormatterUtil {
    public static final TokenSet PARAMETER = TokenSet.create((IElementType[])new IElementType[]{NOT_PROMOTED_PARAMETER, PROMOTED_FIELD_PARAMETER});
    private final ASTNode myNode;
    private final Alignment myBaseAlignment;
    private Map<Role, Alignment> myChildAlignments;
    private final CommonCodeStyleSettings mySettings;
    private final PhpCodeStyleSettings myPhpSettings;
    private final ProcessorContainer myContainingBlock;

    PhpAlignmentProcessor(@NotNull ProcessorContainer containingBlock, ASTNode node, CommonCodeStyleSettings settings, PhpCodeStyleSettings phpSettings) {
        if (containingBlock == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(0);
        }
        this.myNode = node;
        this.myBaseAlignment = Alignment.createAlignment();
        this.mySettings = settings;
        this.myPhpSettings = phpSettings;
        this.myContainingBlock = containingBlock;
        this.initChildAlignments();
    }

    @Nullable
    public Alignment getAlignment(Role role) {
        if (this.myChildAlignments == null) {
            return null;
        }
        return this.myChildAlignments.get((Object)role);
    }

    public void initChildAlignments() {
        IElementType nodeType = this.myNode.getElementType();
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(nodeType) && (this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION || this.myPhpSettings.ALIGN_KEY_VALUE_PAIRS)) {
            this.getAlignmentMap().put(Role.ARRAY_ELEMENT, Alignment.createChildAlignment((Alignment)this.myBaseAlignment));
            this.getAlignmentMap().put(Role.ARRAY_HASH_SIGN, Alignment.createAlignment((boolean)true));
        } else if (nodeType == PhpDocStubElementTypes.DOC_COMMENT) {
            if (this.myPhpSettings.ALIGN_PHPDOC_PARAM_NAMES) {
                this.getAlignmentMap().put(Role.PHP_DOC_PARAM_NAME, Alignment.createAlignment((boolean)true));
            }
            this.getAlignmentMap().put(Role.PHP_DOC_PARAM_COMMENT, Alignment.createAlignment((boolean)true));
            this.getAlignmentMap().put(Role.PHP_DOC_COMMENT, Alignment.createAlignment((boolean)true));
        } else if (nodeType == PhpElementTypes.METHOD_REFERENCE && this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS && PhpFormatterUtil.isTopMethodReference(this.myNode)) {
            this.getAlignmentMap().put(Role.CHAINED_CALL, Alignment.createAlignment());
        } else if (nodeType == PhpStubElementTypes.CLASS) {
            if (this.mySettings.ALIGN_GROUP_FIELD_DECLARATIONS) {
                this.getAlignmentMap().put(Role.FIELD_NAME, Alignment.createAlignment((boolean)true));
                this.getAlignmentMap().put(Role.FIELD_VALUE, Alignment.createAlignment((boolean)true));
            }
            if (this.myPhpSettings.ALIGN_CLASS_CONSTANTS) {
                this.getAlignmentMap().put(Role.CONST_NAME, Alignment.createAlignment((boolean)true));
                this.getAlignmentMap().put(Role.CONST_VALUE, Alignment.createAlignment((boolean)true));
            }
            if (this.myPhpSettings.ALIGN_ENUM_CASES) {
                this.getAlignmentMap().put(Role.ENUM_CASE_NAME, Alignment.createAlignment((boolean)true));
                this.getAlignmentMap().put(Role.ENUM_CASE_VALUE, Alignment.createAlignment((boolean)true));
            }
        }
        if (this.myPhpSettings.ALIGN_INLINE_COMMENTS) {
            this.getAlignmentMap().put(Role.COMMENT, Alignment.createAlignment((boolean)true));
        }
        if (this.myPhpSettings.ALIGN_NAMED_ARGUMENTS) {
            this.getAlignmentMap().put(Role.NAMED_ARGUMENT_COLON, Alignment.createAlignment((boolean)true));
            this.getAlignmentMap().put(Role.NAMED_ARGUMENT_IDENTIFIER, Alignment.createAlignment((boolean)true));
        }
        if (this.mySettings.ALIGN_MULTILINE_PARAMETERS) {
            this.getAlignmentMap().put(Role.PARAMETER_PART, Alignment.createAlignment((boolean)true));
        }
        if (this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS) {
            this.getAlignmentMap().put(Role.ARGUMENT_PART, Alignment.createAlignment((boolean)true));
        }
        if (this.myPhpSettings.ALIGN_MATCH_ARM_BODIES) {
            this.getAlignmentMap().put(Role.MATCH_ARM_HASH, Alignment.createAlignment((boolean)true));
        }
    }

    public void restartAlignment(Role role) {
        this.getAlignmentMap().put(role, Alignment.createAlignment((boolean)true));
    }

    @NotNull
    private Map<Role, Alignment> getAlignmentMap() {
        if (this.myChildAlignments == null) {
            this.myChildAlignments = new HashMap<Role, Alignment>();
        }
        Map<Role, Alignment> map2 = this.myChildAlignments;
        if (map2 == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @Nullable
    Alignment createChildAlignment(ASTNode child) {
        ASTNode prevNode;
        Alignment assignmentAlignment;
        Alignment groupAlignment;
        ASTNode prevChild;
        IElementType parentType = this.myNode.getElementType();
        IElementType childType = child.getElementType();
        if (childType == PhpTokenTypes.PHP_ECHO_OPENING_TAG) {
            return null;
        }
        if (childType == PhpElementTypes.ECHO && (prevChild = child.getTreePrev()) != null && prevChild.getPsi() instanceof PsiWhiteSpace && (prevChild = prevChild.getTreePrev()) != null && prevChild.getElementType() == PhpTokenTypes.PHP_ECHO_OPENING_TAG) {
            return null;
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(parentType)) {
            if (this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION) {
                return PhpFormatterUtil.ARRAY_SURROUNDING_ELEMENTS.contains(childType) ? null : this.getAlignment(Role.ARRAY_ELEMENT);
            }
            if (this.myPhpSettings.ALIGN_KEY_VALUE_PAIRS && childType == PhpElementTypes.HASH_ARRAY_ELEMENT) {
                return this.getAlignment(Role.ARRAY_ELEMENT);
            }
        }
        if (parentType == PhpElementTypes.HASH_ARRAY_ELEMENT && childType == PhpTokenTypes.opHASH_ARRAY) {
            if (this.myPhpSettings.ALIGN_KEY_VALUE_PAIRS) {
                return this.getKeyValueAlignment(child);
            }
            return null;
        }
        if (PhpElementTypes.BINARY_EXPRESSIONS.contains(parentType) && this.mySettings.ALIGN_MULTILINE_BINARY_OPERATION) {
            return this.myBaseAlignment;
        }
        if (parentType == PhpElementTypes.METHOD_REFERENCE && this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS && (PhpAlignmentProcessor.isArrowOrNullsafeQuestOp(child) || childType == PhpTokenTypes.SCOPE_RESOLUTION)) {
            if (PhpAlignmentProcessor.isTopMethodReference(this.myNode)) {
                return this.getAlignmentMap().get((Object)Role.CHAINED_CALL);
            }
            return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.CHAINED_CALL);
        }
        ASTNode superParent = this.myNode.getTreeParent();
        if (parentType == PhpStubElementTypes.CLASS_FIELD || parentType == PhpStubElementTypes.CLASS_CONST) {
            if (superParent != null) {
                IElementType superType = superParent.getElementType();
                Alignment groupAlignment2 = null;
                if (superType == PhpElementTypes.CLASS_FIELDS && this.mySettings.ALIGN_GROUP_FIELD_DECLARATIONS) {
                    groupAlignment2 = this.createFieldGroupAlignment(superParent, childType, PhpElementTypes.CLASS_FIELDS, Role.FIELD_NAME, Role.FIELD_VALUE, this.mySettings.BLANK_LINES_AROUND_FIELD);
                } else if (superType == PhpElementTypes.CLASS_CONSTANTS && this.myPhpSettings.ALIGN_CLASS_CONSTANTS) {
                    groupAlignment2 = this.createFieldGroupAlignment(superParent, childType, PhpElementTypes.CLASS_CONSTANTS, Role.CONST_NAME, Role.CONST_VALUE, this.myPhpSettings.BLANK_LINES_AROUND_CONSTANTS);
                }
                if (groupAlignment2 != null) {
                    return groupAlignment2;
                }
            }
        } else if (parentType == PhpStubElementTypes.ENUM_CASE && this.myPhpSettings.ALIGN_ENUM_CASES && (groupAlignment = this.createFieldGroupAlignment(this.myNode, childType, PhpStubElementTypes.ENUM_CASE, Role.ENUM_CASE_NAME, Role.ENUM_CASE_VALUE, this.myPhpSettings.BLANK_LINES_AROUND_ENUM_CASES)) != null) {
            return groupAlignment;
        }
        if ((assignmentAlignment = this.processAssignmentAlignment(childType)) != null) {
            return assignmentAlignment;
        }
        if (BasicPhpDocUtil.isSimpleTag(this.myNode.getPsi()) && (prevNode = this.myNode.getTreePrev()).getElementType() != PhpDocTokenTypes.DOC_LBRACE) {
            return this.getPhpDocAlignment(child);
        }
        if (PhpAlignmentProcessor.mayHavePhpDocAlignment(child)) {
            return this.getPhpDocAlignment(child);
        }
        if (childType == PhpTokenTypes.LINE_COMMENT && this.myPhpSettings.ALIGN_INLINE_COMMENTS) {
            if (PhpAlignmentProcessor.isAtChainedCall(child)) {
                return PhpAlignmentProcessor.isTopMethodReference(this.myNode) ? this.getAlignmentMap().get((Object)Role.COMMENT) : PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.COMMENT);
            }
            prevNode = child.getTreePrev();
            if (prevNode instanceof PsiWhiteSpace && StringUtil.containsChar((String)prevNode.getText(), (char)'\n')) {
                return null;
            }
            this.restartCommentAlignmentIfNeeded(child, 1);
            return this.myContainingBlock.getAlignmentProcessor().getAlignment(Role.COMMENT);
        }
        if ((parentType == PhpElementTypes.MATCH_ARM || parentType == PhpElementTypes.DEFAULT_MATCH_ARM) && childType == PhpTokenTypes.opHASH_ARRAY) {
            if (this.myPhpSettings.ALIGN_MATCH_ARM_BODIES) {
                return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.MATCH_ARM_HASH);
            }
            return null;
        }
        if (parentType == PhpElementTypes.PARAMETER_LIST) {
            if (PhpFormatterUtil.isAlignable(childType)) {
                ASTNode boundParent = this.myNode.getTreeParent();
                IElementType boundElType = boundParent.getElementType();
                if (boundElType == PhpStubElementTypes.FUNCTION || boundElType == PhpStubElementTypes.CLASS_METHOD) {
                    if (this.mySettings.ALIGN_MULTILINE_PARAMETERS) {
                        return this.myBaseAlignment;
                    }
                } else if (boundElType == PhpElementTypes.FUNCTION_CALL || boundElType == PhpElementTypes.METHOD_REFERENCE || boundElType == PhpElementTypes.NEW_EXPRESSION) {
                    return this.myContainingBlock.getAlignmentProcessor().getAlignment(Role.ARGUMENT_PART);
                }
            } else {
                if (childType == PhpTokenTypes.opCOLON) {
                    return this.myContainingBlock.getAlignmentProcessor().getAlignment(Role.NAMED_ARGUMENT_COLON);
                }
                if (childType == PhpTokenTypes.IDENTIFIER && BasicPhpPsiUtil.isOfType(PhpAlignmentProcessor.getNextSkippingWhitespace(child), PhpTokenTypes.opCOLON)) {
                    return this.myContainingBlock.getAlignmentProcessor().getAlignment(Role.NAMED_ARGUMENT_IDENTIFIER);
                }
            }
        }
        if (this.mySettings.ALIGN_MULTILINE_PARAMETERS && PARAMETER.contains(parentType) && PhpAlignmentProcessor.getFirstParameterNodeSkippingAttributesVisibilityAndType(this.myNode) == child) {
            return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.PARAMETER_PART);
        }
        if (!PhpFormatterUtil.isAlignable(childType)) {
            return null;
        }
        if ((parentType == PhpElementTypes.IMPLEMENTS_LIST || parentType == PhpElementTypes.EXTENDS_LIST) && this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST) {
            return this.myBaseAlignment;
        }
        if ((parentType == PhpElementTypes.FOR || parentType == PhpElementTypes.FOREACH) && this.mySettings.ALIGN_MULTILINE_FOR) {
            return this.myBaseAlignment;
        }
        return null;
    }

    public static boolean isArrowOrNullsafeQuestOp(@NotNull ASTNode child) {
        IElementType type;
        if (child == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(2);
        }
        if ((type = child.getElementType()) == PhpTokenTypes.ARROW) {
            ASTNode prev = child.getTreePrev();
            return prev == null || prev.getElementType() != PhpTokenTypes.opQUEST;
        }
        ASTNode next = child.getTreeNext();
        return type == PhpTokenTypes.opQUEST && next != null && next.getElementType() == PhpTokenTypes.ARROW;
    }

    @Nullable
    private static ASTNode getNextSkippingWhitespace(ASTNode child) {
        ASTNode next;
        for (next = child.getTreeNext(); next != null && next.getElementType() == TokenType.WHITE_SPACE; next = next.getTreeNext()) {
        }
        return next;
    }

    @Nullable
    private static ASTNode getFirstParameterNodeSkippingAttributesVisibilityAndType(ASTNode node) {
        ASTNode child;
        for (child = node.getFirstChildNode(); child != null && (PhpTokenTypes.tsVISIBILITY_MODIFIERS.contains(child.getElementType()) || PhpAlignmentProcessor.isAsymmetricSetToken(child) || TypeDeclaration.isTypeDeclaration(child.getElementType()) || BasicPhpPsiUtil.isReadonlyKeyword(child) || child.getElementType() == PhpElementTypes.ATTRIBUTES_LIST || child.getElementType() == TokenType.WHITE_SPACE); child = child.getTreeNext()) {
        }
        return child;
    }

    private static boolean isAsymmetricSetToken(@NotNull ASTNode node) {
        IElementType type;
        if (node == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(3);
        }
        if ((type = node.getElementType()) != PhpTokenTypes.chLPAREN && type != PhpTokenTypes.kwSET && type != PhpTokenTypes.chRPAREN) {
            return false;
        }
        ASTNode prev = node.getTreePrev();
        if (prev == null) {
            return false;
        }
        while (prev.getElementType() == WHITE_SPACE || prev.getElementType() == PhpTokenTypes.chLPAREN || prev.getElementType() == PhpTokenTypes.kwSET) {
            prev = prev.getTreePrev();
        }
        return BasicPhpPsiUtil.isSetOperationModifier(prev);
    }

    private void restartCommentAlignmentIfNeeded(ASTNode child, int allowedBlankLines) {
        PsiElement prevComment = BasicPhpPsiUtil.findPrevSiblingOfAnyType(child.getPsi(), PhpTokenTypes.LINE_COMMENT);
        if (prevComment == null) {
            return;
        }
        int blankLines = PsiTreeUtil.getElementsOfRange((PsiElement)prevComment, (PsiElement)child.getPsi()).stream().mapToInt(e -> StringUtil.countChars((CharSequence)e.getText(), (char)'\n')).sum();
        if (blankLines > allowedBlankLines) {
            this.restartAlignment(Role.COMMENT);
        }
    }

    @Nullable
    private Alignment getKeyValueAlignment(@NotNull ASTNode hashSign) {
        ASTNode arrayElement;
        PhpAlignmentProcessor parentProcessor;
        if (hashSign == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(4);
        }
        if ((parentProcessor = PhpAlignmentProcessor.findParentAlignmentProcessor(this.myContainingBlock, Role.ARRAY_HASH_SIGN)) != null && (arrayElement = hashSign.getTreeParent()) != null) {
            ASTNode prev = arrayElement.getTreePrev();
            if (prev instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)prev.getChars(), (char)'\n') > 1) {
                parentProcessor.restartAlignment(Role.ARRAY_HASH_SIGN);
            }
            return parentProcessor.getAlignment(Role.ARRAY_HASH_SIGN);
        }
        return null;
    }

    @Nullable
    private static Alignment getParentAlignment(BlockWithParent block, @Nullable Role role) {
        if (block == null) {
            return null;
        }
        PhpAlignmentProcessor parentProcessor = PhpAlignmentProcessor.findParentAlignmentProcessor(block, role);
        return parentProcessor != null ? parentProcessor.getAlignment(role) : null;
    }

    @Nullable
    private Alignment getPhpDocAlignment(ASTNode child) {
        ASTNode prevNode;
        IElementType childType = child.getElementType();
        if ((childType == PhpDocElementTypes.phpDocVariable || childType == PhpDocStubElementTypes.phpDocProperty) && this.myPhpSettings.ALIGN_PHPDOC_PARAM_NAMES) {
            return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.PHP_DOC_PARAM_NAME);
        }
        if ((childType == PhpDocElementTypes.phpDocTagValue || childType == PhpDocElementTypes.phpDocType) && this.myPhpSettings.ALIGN_PHPDOC_COMMENTS) {
            prevNode = child.getTreePrev();
            if (prevNode != null && prevNode.getPsi() instanceof PsiWhiteSpace) {
                prevNode = prevNode.getTreePrev();
            }
            if (prevNode == null || prevNode.getElementType() == PhpDocElementTypes.phpDocType) {
                return null;
            }
            if (prevNode.getElementType() == PhpDocElementTypes.phpDocVariable || prevNode.getElementType() == PhpDocStubElementTypes.phpDocProperty) {
                return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.PHP_DOC_PARAM_COMMENT);
            }
            if (prevNode.getElementType() == PhpDocElementTypes.phpDocRef) {
                return null;
            }
            if (childType != PhpDocElementTypes.phpDocType) {
                return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.PHP_DOC_COMMENT);
            }
        } else if (childType == PhpDocElementTypes.phpDocRef) {
            prevNode = child.getTreePrev();
            if (prevNode != null && prevNode.getPsi() instanceof PsiWhiteSpace) {
                prevNode = prevNode.getTreePrev();
            }
            if (prevNode == null) {
                return null;
            }
            if (prevNode.getElementType() == PhpDocTokenTypes.DOC_TAG_NAME) {
                return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, Role.PHP_DOC_COMMENT);
            }
        }
        if (PhpAlignmentProcessor.mayHavePhpDocAlignment(child) && this.myPhpSettings.ALIGN_PHPDOC_COMMENTS) {
            boolean atCurrElement = true;
            for (prevNode = child.getTreePrev(); prevNode != null; prevNode = prevNode.getTreePrev()) {
                if (prevNode instanceof PsiWhiteSpace) {
                    prevNode = prevNode.getTreePrev();
                }
                if (prevNode == null) break;
                if (prevNode.getElementType() == PhpDocTokenTypes.DOC_LEADING_ASTERISK) {
                    IElementType prevType;
                    if ((prevNode = prevNode.getTreePrev()) instanceof PsiWhiteSpace) {
                        prevNode = prevNode.getTreePrev();
                    }
                    if ((prevType = prevNode.getElementType()) == PhpDocTokenTypes.DOC_LEADING_ASTERISK) {
                        return null;
                    }
                    if (prevType == PhpDocStubElementTypes.phpDocParam) {
                        return this.myContainingBlock.getAlignmentProcessor().getAlignment(Role.PHP_DOC_PARAM_COMMENT);
                    }
                    if (prevType == PhpDocStubElementTypes.phpDocTag && !PhpAlignmentProcessor.mayHavePhpDocAlignment(prevNode = prevNode.getTreePrev())) {
                        return this.myContainingBlock.getAlignmentProcessor().getAlignment(Role.PHP_DOC_COMMENT);
                    }
                } else if (atCurrElement) break;
                atCurrElement = false;
            }
        }
        return null;
    }

    @Nullable
    private Alignment processAssignmentAlignment(IElementType childType) {
        ASTNode parentNode;
        if (!this.myPhpSettings.ALIGN_ASSIGNMENTS) {
            return null;
        }
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == PhpElementTypes.STATEMENT && PhpAlignmentProcessor.isAssignmentStatement(this.myNode)) {
            PhpAlignmentProcessor parentProcessor;
            ASTNode prevGroupNodeCandidate = PhpAlignmentProcessor.findPrevAlignmentGroupNodeCandidate(this.myNode, 0);
            if (!(prevGroupNodeCandidate != null && PhpAlignmentProcessor.isAssignmentStatement(prevGroupNodeCandidate) || (parentProcessor = PhpAlignmentProcessor.findParentAlignmentProcessor(this.myContainingBlock, null)) == null)) {
                parentProcessor.restartAlignment(Role.ASSIGNMENT);
            }
        } else if (nodeType == PhpElementTypes.CONSTANTS) {
            PhpAlignmentProcessor parentProcessor;
            ASTNode prevNode = PhpAlignmentProcessor.findPrevAlignmentGroupNodeCandidate(this.myNode, 0);
            if ((prevNode == null || prevNode.getElementType() != PhpElementTypes.CLASS_CONSTANTS && prevNode.getElementType() != PhpElementTypes.CONSTANTS) && (parentProcessor = PhpAlignmentProcessor.findParentAlignmentProcessor(this.myContainingBlock, null)) != null) {
                parentProcessor.restartAlignment(Role.ASSIGNMENT);
            }
        } else if ((nodeType == ASSIGNMENT_EXPRESSION || nodeType == SELF_ASSIGNMENT_EXPRESSION) && PhpTokenTypes.tsASGN_OPS.contains(childType) ? (parentNode = this.myNode.getTreeParent()) != null && parentNode.getElementType() == PhpElementTypes.STATEMENT : nodeType == PhpStubElementTypes.CONST && childType == PhpTokenTypes.opASGN && (parentNode = this.myNode.getTreeParent()) != null && parentNode.getElementType() == PhpElementTypes.CONSTANTS) {
            return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock.getParent(), Role.ASSIGNMENT);
        }
        return null;
    }

    @Nullable
    private Alignment createFieldGroupAlignment(@NotNull ASTNode superParent, @NotNull IElementType childType, @NotNull IElementType groupType, @NotNull Role nameRole, @NotNull Role valueRole, int maxIgnoredBlankLines) {
        if (superParent == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(5);
        }
        if (childType == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(6);
        }
        if (groupType == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(7);
        }
        if (nameRole == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(8);
        }
        if (valueRole == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(9);
        }
        if (childType == PhpTokenTypes.VARIABLE || childType == PhpTokenTypes.IDENTIFIER) {
            PhpAlignmentProcessor parentProcessor;
            ASTNode prevGroupCandidate = PhpAlignmentProcessor.findPrevAlignmentGroupNodeCandidate(superParent, maxIgnoredBlankLines);
            if ((prevGroupCandidate == null || prevGroupCandidate.getElementType() != groupType) && (parentProcessor = PhpAlignmentProcessor.findParentAlignmentProcessor(this.myContainingBlock, nameRole)) != null) {
                parentProcessor.restartAlignment(nameRole);
                parentProcessor.restartAlignment(valueRole);
            }
            return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, nameRole);
        }
        if (childType == PhpTokenTypes.opASGN) {
            return PhpAlignmentProcessor.getParentAlignment(this.myContainingBlock, valueRole);
        }
        return null;
    }

    @Nullable
    private static ASTNode findPrevAlignmentGroupNodeCandidate(@NotNull ASTNode currNode, int maxIgnoredBlankLines) {
        ASTNode prevNode;
        if (currNode == null) {
            PhpAlignmentProcessor.$$$reportNull$$$0(10);
        }
        if ((prevNode = currNode.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace) {
            if (StringUtil.countChars((CharSequence)prevNode.getText(), (char)'\n') >= maxIgnoredBlankLines + 2) {
                return null;
            }
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode != null && (prevNode.getElementType() == PhpTokenTypes.C_STYLE_COMMENT || prevNode.getElementType() == PhpTokenTypes.LINE_COMMENT)) {
            if (prevNode.textContains('\n')) {
                return null;
            }
            if ((prevNode = prevNode.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace) {
                if (prevNode.textContains('\n')) {
                    return null;
                }
                prevNode = prevNode.getTreePrev();
            }
        }
        return prevNode;
    }

    @Nullable
    private static PhpAlignmentProcessor findParentAlignmentProcessor(BlockWithParent currBlock, @Nullable Role role) {
        for (BlockWithParent parent = currBlock.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ProcessorContainer)) continue;
            PhpAlignmentProcessor parentProcessor = ((ProcessorContainer)parent).getAlignmentProcessor();
            if (role != null && parentProcessor.getAlignment(role) == null) continue;
            return parentProcessor;
        }
        return null;
    }

    private static boolean mayHavePhpDocAlignment(@Nullable ASTNode node) {
        if (node != null) {
            IElementType nodeType = node.getElementType();
            ASTNode parent = node.getTreeParent();
            if (parent != null) {
                return (parent.getPsi() instanceof PhpDocComment || parent.getElementType() == PhpDocElementTypes.phpDocTagValue) && !(node.getPsi() instanceof PhpDocTag) && node.getElementType() != PhpDocStubElementTypes.phpDocSpecialTag && nodeType != PhpDocTokenTypes.DOC_LEADING_ASTERISK && nodeType != PhpDocTokenTypes.DOC_COMMENT_END;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpAlignmentProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashSign";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameRole";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueRole";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpAlignmentProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignmentMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isArrowOrNullsafeQuestOp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAsymmetricSetToken";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueAlignment";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFieldGroupAlignment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPrevAlignmentGroupNodeCandidate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static interface ProcessorContainer
    extends BlockWithParent {
        public PhpAlignmentProcessor getAlignmentProcessor();
    }

    public static enum Role {
        ARRAY_ELEMENT,
        ARRAY_HASH_SIGN,
        ASSIGNMENT,
        PHP_DOC_PARAM_NAME,
        PHP_DOC_PARAM_COMMENT,
        PHP_DOC_COMMENT,
        CHAINED_CALL,
        FIELD_NAME,
        FIELD_VALUE,
        CONST_NAME,
        CONST_VALUE,
        ENUM_CASE_NAME,
        ENUM_CASE_VALUE,
        NAMED_ARGUMENT_COLON,
        NAMED_ARGUMENT_IDENTIFIER,
        ARGUMENT_PART,
        MATCH_ARM_HASH,
        PARAMETER_PART,
        COMMENT;

    }
}

