/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpAlignmentProcessor;
import com.jetbrains.php.lang.formatter.PhpChainBlock;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.formatter.PhpIndentProcessor;
import com.jetbrains.php.lang.formatter.PhpSpacingProcessor;
import com.jetbrains.php.lang.formatter.PhpWrappingProcessor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpBlock
extends TemplateLanguageBlock
implements PhpAlignmentProcessor.ProcessorContainer {
    private final PhpSpacingProcessor mySpacingProcessor;
    private final CommonCodeStyleSettings myCommonPhpSettings;
    protected final PhpCodeStyleSettings myCustomPhpSettings;
    private final PhpIndentProcessor myIndentProcessor;
    private final PhpWrappingProcessor myWrappingProcessor;
    private Wrap myPreferredWrap;
    private final PhpAlignmentProcessor myAlignmentProcessor;

    public PhpBlock(AbstractXmlTemplateFormattingModelBuilder builder, @NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent) {
        if (node == null) {
            PhpBlock.$$$reportNull$$$0(0);
        }
        super(builder, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
        this.myCommonPhpSettings = this.getSettings().getCommonSettings((Language)PhpLanguage.INSTANCE);
        this.myCustomPhpSettings = (PhpCodeStyleSettings)this.getSettings().getCustomSettings(PhpCodeStyleSettings.class);
        this.mySpacingProcessor = new PhpSpacingProcessor(node, this.myCommonPhpSettings, this.myCustomPhpSettings, xmlFormattingPolicy);
        this.myIndentProcessor = new PhpIndentProcessor(node, this.myCommonPhpSettings, this.myCustomPhpSettings, settings.getIndentSize((FileType)PhpFileType.INSTANCE));
        this.myWrappingProcessor = new PhpWrappingProcessor(this, node, this.myCommonPhpSettings, this.myCustomPhpSettings);
        this.myAlignmentProcessor = new PhpAlignmentProcessor(this, node, this.myCommonPhpSettings, this.myCustomPhpSettings);
    }

    @NotNull
    protected Indent getChildIndent(@NotNull ASTNode node) {
        if (node == null) {
            PhpBlock.$$$reportNull$$$0(1);
        }
        Indent indent = this.myIndentProcessor.getChildIndent(node);
        if (indent == null) {
            PhpBlock.$$$reportNull$$$0(2);
        }
        return indent;
    }

    protected Spacing getSpacing(TemplateLanguageBlock adjacentBlock) {
        return this.getSpacing((Block)this, (Block)adjacentBlock);
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            PhpBlock.$$$reportNull$$$0(3);
        }
        return this.mySpacingProcessor.getSpacing(child1, child2);
    }

    @Nullable
    protected Wrap getChildWrap(ASTNode child) {
        IElementType childType = child.getElementType();
        BlockWithParent parent = this.getParent();
        Wrap preferredWrap = parent instanceof PhpBlock ? ((PhpBlock)parent).getPreferredWrap() : null;
        Wrap wrap = this.myWrappingProcessor.createChildWrap(child, preferredWrap, this.getChildWrap());
        if (PhpAlignmentProcessor.isArrowOrNullsafeQuestOp(child) && PhpFormatterUtil.isAtChainedCall(child)) {
            this.myPreferredWrap = wrap;
        }
        return wrap;
    }

    Wrap getChildWrap() {
        return this.myWrappingProcessor.getSharedWrap();
    }

    Wrap getPreferredWrap() {
        return this.myPreferredWrap;
    }

    @Nullable
    protected Alignment getChildAlignment(ASTNode child) {
        return this.myAlignmentProcessor.createChildAlignment(child);
    }

    @Override
    public PhpAlignmentProcessor getAlignmentProcessor() {
        return this.myAlignmentProcessor;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        IElementType type = this.myNode.getElementType();
        List childBlockList = this.getSubBlocks();
        if (newChildIndex > 0 && newChildIndex - 1 < childBlockList.size()) {
            ASTBlock prevBlock;
            Block prevGenericBlock = (Block)childBlockList.get(newChildIndex - 1);
            ASTBlock aSTBlock = prevBlock = prevGenericBlock instanceof ASTBlock ? (ASTBlock)prevGenericBlock : null;
            if (prevBlock != null) {
                if (prevBlock instanceof DataLanguageBlockWrapper) {
                    ASTNode dataNode = prevBlock.getNode();
                    if (PhpFormatterUtil.isUnixScriptDefinition(dataNode)) {
                        return new ChildAttributes(Indent.getNoneIndent(), null);
                    }
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                    if (childAttributes == null) {
                        PhpBlock.$$$reportNull$$$0(4);
                    }
                    return childAttributes;
                }
                Indent indent = prevBlock.getIndent();
                Alignment alignment = this.myAlignmentProcessor.createChildAlignment(this.myNode);
                ASTNode prevNode = prevBlock.getNode();
                IElementType prevBlockType = prevNode.getElementType();
                if (type == PhpElementTypes.PARAMETER_LIST) {
                    indent = Indent.getNoneIndent();
                } else if (prevBlockType == PhpTokenTypes.opCOMMA || prevBlockType == PhpTokenTypes.chLPAREN || prevBlockType == PhpTokenTypes.chRPAREN || prevBlockType == PhpTokenTypes.chLBRACKET || prevBlockType == PhpTokenTypes.kwELSE || prevBlockType == PhpElementTypes.ELSE || prevBlockType == PhpElementTypes.ELSE_IF) {
                    indent = Indent.getNormalIndent();
                } else if (prevBlockType == PhpTokenTypes.chLBRACE) {
                    indent = this.getBlockIndent(this.myNode);
                } else if (type == PhpElementTypes.CASE || type == PhpElementTypes.CASE_DEFAULT) {
                    indent = Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)true, (boolean)false);
                } else if (prevBlockType == PhpElementTypes.CASE || prevBlockType == PhpElementTypes.CASE_DEFAULT) {
                    Block lastBlock;
                    Indent switchIndent = Indent.getNoneIndent();
                    Indent caseIndent = Indent.getNormalIndent();
                    if (this.myCommonPhpSettings.INDENT_CASE_FROM_SWITCH) {
                        switchIndent = Indent.getNormalIndent();
                        caseIndent = Indent.getSpaceIndent((int)(this.getSettings().getIndentSize((FileType)PhpFileType.INSTANCE) * 2));
                    }
                    indent = PhpBlock.isEndOfCaseAt(lastBlock = PhpFormatterUtil.getLastInternalBlock((Block)prevBlock)) ? switchIndent : caseIndent;
                } else if (prevBlockType == PhpTokenTypes.IDENTIFIER && type == PhpStubElementTypes.CLASS) {
                    indent = Indent.getNoneIndent();
                } else if (type == PhpElementTypes.NON_LAZY_GROUP_STATEMENT) {
                    indent = this.myCustomPhpSettings.INDENT_CODE_IN_PHP_TAGS ? Indent.getNormalIndent() : Indent.getNoneIndent();
                } else if (prevBlockType == PhpTokenTypes.PHP_CLOSING_TAG) {
                    indent = PhpFormatterUtil.isPrecededBy(prevNode, PhpTokenTypes.PHP_OPENING_TAG) ? Indent.getNoneIndent() : null;
                } else if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(type)) {
                    IElementType parentType;
                    ASTNode parentNode = this.myNode.getTreeParent();
                    IElementType iElementType = parentType = parentNode != null ? parentNode.getElementType() : null;
                    if (parentType == PhpElementTypes.CASE || parentType == PhpElementTypes.CASE_DEFAULT) {
                        boolean isIndented = PhpFormatterUtil.isBracedGroup(this.myNode) && this.myCommonPhpSettings.BRACE_STYLE != 3;
                        indent = Indent.getIndent((Indent.Type)(isIndented ? Indent.Type.NORMAL : Indent.Type.NONE), (!isIndented ? 1 : 0) != 0, (boolean)false);
                    } else if (parentType == PhpStubElementTypes.NAMESPACE) {
                        indent = !PhpFormatterUtil.isBracedGroup(this.myNode) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                    } else if (PhpFormatterUtil.isBracedGroup(this.myNode)) {
                        indent = this.getBlockIndent(this.myNode);
                    }
                } else if (type == PhpStubElementTypes.VARIABLE) {
                    indent = Indent.getContinuationIndent();
                } else if (PhpBlock.endsWithChainBlock((Block)prevBlock) || type == PhpElementTypes.METHOD_REFERENCE) {
                    indent = Indent.getContinuationIndent();
                } else if (PhpFormatterUtil.isBlockGroupStatement(prevNode)) {
                    indent = Indent.getNoneIndent();
                }
                return new ChildAttributes(indent, alignment);
            }
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            PhpBlock.$$$reportNull$$$0(5);
        }
        return childAttributes;
    }

    private Indent getBlockIndent(@NotNull ASTNode node) {
        ASTNode parent;
        IElementType parentType;
        if (node == null) {
            PhpBlock.$$$reportNull$$$0(6);
        }
        IElementType iElementType = parentType = (parent = node.getTreeParent()) != null ? parent.getElementType() : null;
        if (node.getElementType() == PhpStubElementTypes.CLASS) {
            return Indent.getNormalIndent();
        }
        if (parentType == PhpStubElementTypes.FUNCTION || parentType == PhpStubElementTypes.CLASS_METHOD) {
            int braceStyle = this.myCommonPhpSettings.METHOD_BRACE_STYLE;
            ASTNode grandParent = parent.getTreeParent();
            if (grandParent != null && grandParent.getElementType() == PhpElementTypes.CLOSURE) {
                braceStyle = this.myCommonPhpSettings.LAMBDA_BRACE_STYLE;
            }
            return braceStyle != 3 ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        return this.myCommonPhpSettings.BRACE_STYLE != 3 ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    private static boolean endsWithChainBlock(@Nullable Block block) {
        if (block == null) {
            return false;
        }
        if (block instanceof PhpChainBlock) {
            return true;
        }
        List subBlocks = block.getSubBlocks();
        Block lastBlock = !subBlocks.isEmpty() ? (Block)subBlocks.get(subBlocks.size() - 1) : null;
        return PhpBlock.endsWithChainBlock(lastBlock);
    }

    private static boolean isEndOfCaseAt(Block block) {
        if (!(block instanceof PhpBlock)) {
            return false;
        }
        BlockWithParent parent = ((PhpBlock)block).getParent();
        if (!(parent instanceof PhpBlock)) {
            return false;
        }
        ASTNode parentNode = ((PhpBlock)parent).getNode();
        IElementType elementType = parentNode.getElementType();
        return elementType == PhpElementTypes.BREAK || elementType == PhpElementTypes.RETURN || PhpFormatterUtil.isBracedGroup(parentNode);
    }

    protected List<Block> buildChildrenWithMerge() throws FragmentedTemplateException {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == PhpElementTypes.STRING) {
            return EMPTY;
        }
        if (this.myNode.getFirstChildNode() == null && nodeType != PhpTokenTypes.HTML) {
            return EMPTY;
        }
        List children = super.buildChildrenWithMerge();
        if (nodeType == PhpElementTypes.METHOD_REFERENCE || nodeType == PhpElementTypes.FIELD_REFERENCE) {
            this.buildChainBlock(children);
        }
        return children;
    }

    private void buildChainBlock(List<Block> children) {
        ArrayList<Block> chainSubBlocks = new ArrayList<Block>();
        int insertIndex = -1;
        for (Block block : children.toArray(new Block[0])) {
            ASTNode childNode;
            if (!(block instanceof ASTBlock) || (childNode = ((ASTBlock)block).getNode()) == this.myNode.getFirstChildNode()) continue;
            if (insertIndex < 0) {
                insertIndex = children.indexOf(block);
            }
            chainSubBlocks.add(block);
            children.remove(block);
        }
        if (!chainSubBlocks.isEmpty()) {
            PhpChainBlock chainBlock = new PhpChainBlock(this.myNode, chainSubBlocks, this.mySpacingProcessor);
            children.add(insertIndex, chainBlock);
        }
    }

    public boolean containsFatalError(@NotNull PsiElement element) {
        PsiElement firstElement;
        if (element == null) {
            PhpBlock.$$$reportNull$$$0(7);
        }
        if (element instanceof Statement && BasicPhpPsiUtil.isOfType(firstElement = element.getFirstChild(), PhpElementTypes.RELATIONAL_EXPRESSION)) {
            PsiElement lastElement = PsiTreeUtil.getDeepestLast((PsiElement)element);
            return lastElement instanceof PsiErrorElement;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBlockIndent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsFatalError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

