/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.calls.Function;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.expressions.MatchExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.Array;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.NewExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.primary.Scalar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrimaryExpression {
    private static final TokenSet kwREQUIRE___kwREQUIRE_ONCE___kwINCLUDE___kwINCLUDE_ONCE = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwREQUIRE, PhpTokenTypes.kwREQUIRE_ONCE, PhpTokenTypes.kwINCLUDE, PhpTokenTypes.kwINCLUDE_ONCE});
    public static final IssetUnsetParserPart ISSET_UNSET_VARIABLE_PARSER_PART = new IssetUnsetParserPart();

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = MatchExpression.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        if (builder.compare(PhpTokenTypes.tsEXIT)) {
            return PrimaryExpression.parseExitExpression(builder);
        }
        PsiBuilder.Marker possibleAssignment = builder.mark();
        PsiBuilder.Marker variable = builder.mark();
        result = Variable.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            variable.done(result);
            IElementType multiAssignmentExpression = PrimaryExpression.tryParseAssignment(builder, result, possibleAssignment);
            if (multiAssignmentExpression != PhpElementTypes.EMPTY_INPUT) {
                return multiAssignmentExpression;
            }
            return result;
        }
        variable.drop();
        possibleAssignment.drop();
        result = Scalar.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT) {
            return result;
        }
        if (builder.compare(PhpTokenTypes.chLBACKTRICK)) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            Scalar.parseEncapsList(builder);
            builder.match(PhpTokenTypes.chRBACKTRICK);
            marker.done(PhpElementTypes.SHELL_COMMAND);
            return PhpElementTypes.SHELL_COMMAND;
        }
        boolean bracket = builder.compare(PhpTokenTypes.chLBRACKET);
        if (builder.compare(PhpTokenTypes.kwARRAY) || bracket) {
            PsiBuilder.Marker mark = builder.mark();
            IElementType array = Array.parse(builder);
            if (bracket && array != PhpElementTypes.EMPTY_INPUT) {
                IElementType multiAssignmentExpression = PrimaryExpression.tryParseAssignment(builder, array, mark);
                if (multiAssignmentExpression != PhpElementTypes.EMPTY_INPUT) {
                    return multiAssignmentExpression;
                }
            } else {
                mark.drop();
            }
            return array;
        }
        if (builder.compare(PhpTokenTypes.chLPAREN)) {
            PsiBuilder.Marker parenthesizedExpression = builder.mark();
            result = PrimaryExpression.parseParens(builder);
            if (result == PhpElementTypes.PARENTHESIZED_EXPRESSION) {
                parenthesizedExpression.done(PhpElementTypes.PARENTHESIZED_EXPRESSION);
            } else {
                parenthesizedExpression.drop();
            }
            return result;
        }
        if (builder.compare(PhpTokenTypes.kwNEW)) {
            PsiBuilder.Marker newExpr = builder.mark();
            result = NewExpression.parse(builder);
            newExpr.done(result);
            return result;
        }
        if (builder.compare(PhpTokenTypes.tsEXIT)) {
            return PrimaryExpression.parseExitExpression(builder);
        }
        result = PrimaryExpression.parseInternalFunctions(builder);
        return result;
    }

    @NotNull
    private static IElementType tryParseAssignment(PhpPsiBuilder builder, IElementType leftPartResult, PsiBuilder.Marker mark) {
        IElementType asgnExpression;
        if (!builder.compare(PhpTokenTypes.tsASGN_OPS)) {
            mark.drop();
            IElementType iElementType = PhpElementTypes.EMPTY_INPUT;
            if (iElementType == null) {
                PrimaryExpression.$$$reportNull$$$0(0);
            }
            return iElementType;
        }
        IElementType asgnOpType = builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder.Marker expression = builder.mark();
        IElementType rightPart = AssignmentExpression.parse(builder);
        IElementType iElementType = asgnOpType != PhpTokenTypes.opASGN ? PhpElementTypes.SELF_ASSIGNMENT_EXPRESSION : (asgnExpression = leftPartResult == PhpElementTypes.ARRAY_CREATION_EXPRESSION ? PhpElementTypes.MULTIASSIGNMENT_EXPRESSION : PhpElementTypes.ASSIGNMENT_EXPRESSION);
        if (rightPart == PhpElementTypes.EMPTY_EXPRESSION) {
            expression.drop();
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        } else if (asgnExpression == PhpElementTypes.MULTIASSIGNMENT_EXPRESSION) {
            expression.done(PhpElementTypes.EXPRESSION);
        } else {
            expression.drop();
        }
        mark.done(asgnExpression);
        IElementType iElementType2 = asgnExpression;
        if (iElementType2 == null) {
            PrimaryExpression.$$$reportNull$$$0(1);
        }
        return iElementType2;
    }

    public static IElementType parseParens(PhpPsiBuilder builder) {
        builder.advanceLexer();
        IElementType result = Expression.parse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.getExpressionExpectedMessage());
        }
        if (!builder.compareAndEat(PhpTokenTypes.chRPAREN)) {
            builder.error(PhpParserErrors.expected(")"));
        }
        return PhpElementTypes.PARENTHESIZED_EXPRESSION;
    }

    private static void tryParseExitExpression(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.compareAndEat(PhpTokenTypes.chLPAREN) && !builder.compareAndEat(PhpTokenTypes.chRPAREN)) {
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            builder.match(PhpTokenTypes.chRPAREN);
        }
        marker.done(PhpElementTypes.EXIT_EXPRESSION);
    }

    private static boolean tryParseCallable(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (!Function.tryParseFirstClassCallable(builder)) {
            marker.rollbackTo();
            return false;
        }
        marker.done(PhpElementTypes.CALLABLE_FUNCTION);
        return true;
    }

    private static IElementType parseExitExpression(PhpPsiBuilder builder) {
        if (PrimaryExpression.tryParseCallable(builder)) {
            return PhpElementTypes.CALLABLE_FUNCTION;
        }
        PrimaryExpression.tryParseExitExpression(builder);
        return PhpElementTypes.EXIT_EXPRESSION;
    }

    private static IElementType parseInternalFunctions(PhpPsiBuilder builder) {
        PsiBuilder.Marker function = builder.mark();
        if (builder.compareAndEat(kwREQUIRE___kwREQUIRE_ONCE___kwINCLUDE___kwINCLUDE_ONCE)) {
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            function.done((IElementType)PhpStubElementTypes.INCLUDE_EXPRESSION);
            return PhpStubElementTypes.INCLUDE_EXPRESSION;
        }
        if (builder.compareAndEat(PhpTokenTypes.kwYIELD)) {
            if ("from".equalsIgnoreCase(builder.getTokenText())) {
                builder.advanceLexer();
            }
            if (!builder.compare(PhpTokenTypes.opSEMICOLON)) {
                Expression.parse(builder);
                if (builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY)) {
                    Expression.parse(builder);
                }
            }
            function.done(PhpElementTypes.YIELD);
            return PhpElementTypes.CONSTANT_REF;
        }
        IElementType throwExpression = PrimaryExpression.parseExpressionWithPrefix(builder, function, PhpTokenTypes.kwTHROW, PhpElementTypes.THROW_EXPRESSION);
        if (throwExpression != null) {
            return throwExpression;
        }
        IElementType printExpression = PrimaryExpression.parseExpressionWithPrefix(builder, function, PhpTokenTypes.kwPRINT, PhpElementTypes.PRINT_EXPRESSION);
        if (printExpression != null) {
            return printExpression;
        }
        if (builder.compareAndEat(PhpTokenTypes.kwEMPTY)) {
            builder.match(PhpTokenTypes.chLPAREN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            builder.match(PhpTokenTypes.chRPAREN);
            function.done(PhpElementTypes.EMPTY_EXPRESSION);
            return PhpElementTypes.EMPTY_EXPRESSION;
        }
        if (builder.compareAndEat(PhpTokenTypes.kwEVAL)) {
            builder.match(PhpTokenTypes.chLPAREN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            builder.match(PhpTokenTypes.chRPAREN);
            function.done(PhpElementTypes.EVAL_EXPRESSION);
            return PhpElementTypes.EVAL_EXPRESSION;
        }
        if (builder.compareAndEat(PhpTokenTypes.kwISSET)) {
            builder.match(PhpTokenTypes.chLPAREN);
            if (PrimaryExpression.parseIssetUnsetVariables(builder) == 0) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("variable1", new Object[0])));
            }
            builder.match(PhpTokenTypes.chRPAREN);
            function.done(PhpElementTypes.ISSET_EXPRESSION);
            return PhpElementTypes.ISSET_EXPRESSION;
        }
        function.drop();
        return PhpElementTypes.EMPTY_INPUT;
    }

    @Nullable
    private static IElementType parseExpressionWithPrefix(PhpPsiBuilder builder, PsiBuilder.Marker marker, IElementType prefix, IElementType expression) {
        if (builder.compareAndEat(prefix)) {
            IElementType result = AssignmentExpression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
            }
            marker.done(expression);
            return expression;
        }
        return null;
    }

    public static int parseIssetUnsetVariables(PhpPsiBuilder builder) {
        return ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, ISSET_UNSET_VARIABLE_PARSER_PART.parse(builder), ISSET_UNSET_VARIABLE_PARSER_PART, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/parser/parsing/expressions/PrimaryExpression", "tryParseAssignment"));
    }

    public static class IssetUnsetParserPart
    implements ParserPart {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker var = builder.mark();
            IElementType currentToken = builder.getTokenType();
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                if (currentToken == PhpTokenTypes.chRPAREN) {
                    var.drop();
                    return result;
                }
                var.rollbackTo();
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("variable1", new Object[0])));
            } else {
                var.drop();
            }
            if (result != PhpElementTypes.EMPTY_INPUT) {
                return result;
            }
            PsiBuilder.Marker identifier = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
                identifier.done(PhpElementTypes.CONSTANT_REF);
                return PhpElementTypes.CONSTANT_REF;
            }
            identifier.drop();
            return PhpElementTypes.EMPTY_INPUT;
        }
    }
}

