/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageJsonCommonUtil {
    @NlsSafe
    private static final String FILE_NAME = "package.json";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEV_DEPENDENCIES = "devDependencies";
    static final List<String> ALL_DEPENDENCIES = List.of("dependencies", "devDependencies", "optionalDependencies", "peerDependencies", "bundledDependencies", "bundleDependencies");

    public static boolean isInsidePackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(0);
        }
        return PackageJsonCommonUtil.getContainingPackageJsonFile(element) != null;
    }

    @Nullable
    public static JsonFile getContainingPackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(1);
        }
        PsiFile file = element.getContainingFile();
        return PackageJsonCommonUtil.asPackageJsonFile(file);
    }

    @Contract(value="null -> null")
    @Nullable
    public static JsonFile asPackageJsonFile(@Nullable PsiFile file) {
        return PackageJsonCommonUtil.isPackageJsonFile(file) ? (JsonFile)file : null;
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable PsiFile file) {
        return file instanceof JsonFile && FILE_NAME.equals(file.getName());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)file.getNameSequence());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFileName(@Nullable CharSequence fileName) {
        return StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)fileName);
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        PsiElement parent;
        if (property == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(2);
        }
        return (parent = property.getParent()) != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static JsonProperty findContainingProperty(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(3);
        }
        if (PackageJsonCommonUtil.isInsidePackageJsonFile(element)) {
            return (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    public static JsonProperty findContainingTopLevelProperty(@Nullable PsiElement element) {
        if (element == null || !PackageJsonCommonUtil.isInsidePackageJsonFile(element)) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        while (property != null && !PackageJsonCommonUtil.isTopLevelProperty(property)) {
            property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class, (boolean)true);
        }
        return property;
    }

    public static boolean isPackageDependencyProperty(@NotNull JsonProperty property) {
        JsonObject obj;
        if (property == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(4);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            JsonProperty dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class);
            return dependenciesProperty != null && ALL_DEPENDENCIES.contains(dependenciesProperty.getName()) && PackageJsonCommonUtil.isTopLevelProperty(dependenciesProperty);
        }
        return false;
    }

    public static boolean isPackageDependenciesProperty(@Nullable JsonProperty property) {
        return property != null && ALL_DEPENDENCIES.contains(property.getName());
    }

    @NotNull
    public static List<JsonProperty> getAllDependencies(@NotNull JsonFile packageJson) {
        if (packageJson == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(5);
        }
        return PackageJsonCommonUtil.getDependencies(packageJson, ALL_DEPENDENCIES);
    }

    @NotNull
    public static List<JsonProperty> getDependencies(@NotNull JsonFile packageJson, @NotNull Collection<String> enclosingParentAttributes) {
        if (packageJson == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(6);
        }
        if (enclosingParentAttributes == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(7);
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)packageJson.getTopLevelValue(), JsonObject.class);
        ArrayList<JsonProperty> result = new ArrayList<JsonProperty>();
        if (obj != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonObject depObj;
                if (!enclosingParentAttributes.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                result.addAll(depObj.getPropertyList());
            }
        }
        ArrayList<JsonProperty> arrayList = result;
        if (arrayList == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public static JsonProperty findDependencyByName(@NotNull JsonFile packageJson, @NotNull String dependencyName) {
        JsonObject obj;
        if (packageJson == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(9);
        }
        if (dependencyName == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(10);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)packageJson.getTopLevelValue(), JsonObject.class)) != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonProperty dependencyProperty;
                JsonObject depObj;
                if (!ALL_DEPENDENCIES.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null || (dependencyProperty = depObj.findProperty(dependencyName)) == null) continue;
                return dependencyProperty;
            }
        }
        return null;
    }

    @Nullable
    public static JsonProperty findProdDependencyByName(@NotNull JsonFile packageJson, @NotNull String dependencyName) {
        JsonObject rootObj;
        if (packageJson == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(11);
        }
        if (dependencyName == null) {
            PackageJsonCommonUtil.$$$reportNull$$$0(12);
        }
        if ((rootObj = (JsonObject)ObjectUtils.tryCast((Object)packageJson.getTopLevelValue(), JsonObject.class)) == null) {
            return null;
        }
        JsonProperty depProperty = rootObj.findProperty(DEPENDENCIES);
        if (depProperty == null) {
            return null;
        }
        JsonObject depObj = (JsonObject)ObjectUtils.tryCast((Object)depProperty.getValue(), JsonObject.class);
        if (depObj == null) {
            return null;
        }
        return depObj.findProperty(dependencyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingParentAttributes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonCommonUtil";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonCommonUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePackageJsonFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPackageJsonFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDependencyProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyByName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findProdDependencyByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

