/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.settingsSummary.util.PhpCredentialsContribution;
import com.jetbrains.php.settingsSummary.util.PhpSettingsCollector;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsLanguageContributor;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class VagrantCredentialsPhpContributor
extends CredentialsLanguageContribution<PhpCredentialsContribution>
implements PhpCredentialsContribution<VagrantBasedCredentialsHolder>,
VagrantCredentialsLanguageContributor {
    private static final String VAGRANT_FOLDER = "Vagrant folder";

    public CredentialsType<VagrantBasedCredentialsHolder> getType() {
        return VagrantCredentialsType.getInstance();
    }

    public Class<PhpCredentialsContribution> getLanguageContributionClass() {
        return PhpCredentialsContribution.class;
    }

    public PhpCredentialsContribution<VagrantBasedCredentialsHolder> getLanguageContribution() {
        return this;
    }

    public String suggestName(VagrantBasedCredentialsHolder credentials, @Nullable PhpInfo info) {
        return null;
    }

    public void collectSettings(VagrantBasedCredentialsHolder credentials, StringBuilder output) {
        PhpSettingsCollector.appendEntry((String)"Machine name", (String)credentials.getMachineName(), (StringBuilder)output);
        PhpSettingsCollector.appendEscapedEntry((String)"Vagrant Folder", (String)credentials.getVagrantFolder(), (StringBuilder)output);
    }

    @Nls
    public String validate(@Nullable Project project, VagrantBasedCredentialsHolder credentials) {
        if (StringUtil.isEmpty((String)credentials.getVagrantFolder())) {
            return PhpBundle.message((String)"validation.value.is.not.specified.or.invalid", (Object[])new Object[]{VAGRANT_FOLDER});
        }
        return null;
    }

    public String getConnectionPresentableName(VagrantBasedCredentialsHolder credentials) {
        return credentials.getVagrantFolder();
    }
}

