/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ignore.psi.util.IgnoreFileUtilKt;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"writeIgnoreFileEntries", "", "project", "Lcom/intellij/openapi/project/Project;", "ignoreFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "ignored", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileBean;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "ignoreEntryRoot", "getIgnoredFileBeans", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "ignoreFileRoot", "getSelectedFiles", "intellij.platform.vcs.impl"})
public final class IgnoreFileActionKt {
    public static final void writeIgnoreFileEntries(@NotNull Project project, @NotNull VirtualFile ignoreFile, @NotNull List<IgnoredFileBean> ignored, @Nullable AbstractVcs vcs, @Nullable VirtualFile ignoreEntryRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ignoreFile, (String)"ignoreFile");
        Intrinsics.checkNotNullParameter(ignored, (String)"ignored");
        AbstractVcs abstractVcs = vcs;
        IgnoreFileUtilKt.addNewElements(project, ignoreFile, ignored, (VcsKey)(abstractVcs != null ? abstractVcs.getKeyInstanceMethod() : null), ignoreEntryRoot);
        VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
        new OpenFileDescriptor(project, ignoreFile).navigate(true);
    }

    public static /* synthetic */ void writeIgnoreFileEntries$default(Project project, VirtualFile virtualFile, List list, AbstractVcs abstractVcs, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 8) != 0) {
            abstractVcs = null;
        }
        if ((n & 0x10) != 0) {
            virtualFile2 = null;
        }
        IgnoreFileActionKt.writeIgnoreFileEntries(project, virtualFile, list, abstractVcs, virtualFile2);
    }

    @NotNull
    public static final List<IgnoredFileBean> getIgnoredFileBeans(@NotNull AnActionEvent e, @NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)ignoreFileRoot, (String)"ignoreFileRoot");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        Project project = (Project)object;
        List<VirtualFile> selectedFiles = IgnoreFileActionKt.getSelectedFiles(e);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)selectedFiles), arg_0 -> IgnoreFileActionKt.getIgnoredFileBeans$lambda$0(ignoreFileRoot, arg_0)), arg_0 -> IgnoreFileActionKt.getIgnoredFileBeans$lambda$1(project, vcs, arg_0)), arg_0 -> IgnoreFileActionKt.getIgnoredFileBeans$lambda$2(project, arg_0)));
    }

    @NotNull
    public static final List<VirtualFile> getSelectedFiles(@NotNull AnActionEvent e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object[] objectArray = UtilKt.asJBIterable((Iterable)((Iterable)e.getData(ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY))).toList();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toList(...)");
        Object[] exactlySelectedFiles = objectArray;
        if (!((Collection)exactlySelectedFiles).isEmpty()) {
            object = exactlySelectedFiles;
        } else {
            object = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
        }
        return object;
    }

    private static final boolean getIgnoredFileBeans$lambda$0(VirtualFile $ignoreFileRoot, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VfsUtil.isAncestor((VirtualFile)$ignoreFileRoot, (VirtualFile)it, (boolean)false);
    }

    private static final boolean getIgnoredFileBeans$lambda$1(Project $project, AbstractVcs $vcs, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)VcsUtil.getVcsFor((Project)$project, (VirtualFile)it), (Object)$vcs);
    }

    private static final IgnoredFileBean getIgnoredFileBeans$lambda$2(Project $project, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IgnoredBeanFactory.ignoreFile((VirtualFile)it, (Project)$project);
    }
}

