/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.makefile.MakefileLexerAdapter;
import com.jetbrains.lang.makefile.psi.MakefileTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/lang/makefile/MakefileSyntaxHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "<init>", "()V", "getTokenHighlights", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getHighlightingLexer", "Lcom/jetbrains/lang/makefile/MakefileLexerAdapter;", "Companion", "intellij.makefile"})
public final class MakefileSyntaxHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TextAttributesKey COMMENT;
    @NotNull
    private static final TextAttributesKey DOCCOMMENT;
    @NotNull
    private static final TextAttributesKey KEYWORD;
    @NotNull
    private static final TextAttributesKey TARGET;
    @NotNull
    private static final TextAttributesKey SPECIAL_TARGET;
    @NotNull
    private static final TextAttributesKey SEPARATOR;
    @NotNull
    private static final TextAttributesKey PREREQUISITE;
    @NotNull
    private static final TextAttributesKey VARIABLE;
    @NotNull
    private static final TextAttributesKey VARIABLE_VALUE;
    @NotNull
    private static final TextAttributesKey STRING;
    @NotNull
    private static final TextAttributesKey LINE_SPLIT;
    @NotNull
    private static final TextAttributesKey TAB;
    @NotNull
    private static final TextAttributesKey FUNCTION;
    @NotNull
    private static final TextAttributesKey FUNCTION_PARAM;
    @NotNull
    private static final TextAttributesKey BRACES;
    @NotNull
    private static final TextAttributesKey PARENS;
    @NotNull
    private static final TextAttributesKey BAD_CHARACTER;
    @NotNull
    private static final TextAttributesKey[] BAD_CHAR_KEYS;
    @NotNull
    private static final TextAttributesKey[] SEPARATOR_KEYS;
    @NotNull
    private static final TextAttributesKey[] KEYWORD_KEYS;
    @NotNull
    private static final TextAttributesKey[] TARGET_KEYS;
    @NotNull
    private static final TextAttributesKey[] PREREQUISITE_KEYS;
    @NotNull
    private static final TextAttributesKey[] VARIABLE_KEYS;
    @NotNull
    private static final TextAttributesKey[] VARIABLE_VALUE_KEYS;
    @NotNull
    private static final TextAttributesKey[] STRING_KEYS;
    @NotNull
    private static final TextAttributesKey[] LINE_SPLIT_KEYS;
    @NotNull
    private static final TextAttributesKey[] TAB_KEYS;
    @NotNull
    private static final TextAttributesKey[] COMMENT_KEYS;
    @NotNull
    private static final TextAttributesKey[] DOCCOMMENT_KEYS;
    @NotNull
    private static final TextAttributesKey[] BRACES_KEYS;
    @NotNull
    private static final TextAttributesKey[] EMPTY_KEYS;

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        IElementType iElementType = tokenType;
        return Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.DOC_COMMENT) ? DOCCOMMENT_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.COMMENT) ? COMMENT_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.TARGET) ? TARGET_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.ASSIGN) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.SEMICOLON) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.PIPE) ? SEPARATOR_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_INCLUDE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFEQ) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFNEQ) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFDEF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_IFNDEF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_ELSE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_ENDIF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_DEFINE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_ENDEF) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_UNDEFINE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_OVERRIDE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_EXPORT) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_PRIVATE) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.KEYWORD_VPATH) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.DOLLAR) ? KEYWORD_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.PREREQUISITE) ? PREREQUISITE_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.VARIABLE) ? VARIABLE_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.VARIABLE_VALUE) ? VARIABLE_VALUE_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.SPLIT) ? LINE_SPLIT_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.TAB) ? TAB_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.STRING) ? STRING_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.OPEN_PAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.CLOSE_PAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.OPEN_CURLY) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.CLOSE_CURLY) || Intrinsics.areEqual((Object)iElementType, (Object)MakefileTypes.BACKTICK) ? BRACES_KEYS : (Intrinsics.areEqual((Object)iElementType, (Object)TokenType.BAD_CHARACTER) ? BAD_CHAR_KEYS : EMPTY_KEYS))))))))))));
    }

    @NotNull
    public MakefileLexerAdapter getHighlightingLexer() {
        return new MakefileLexerAdapter();
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        COMMENT = textAttributesKey;
        TextAttributesKey textAttributesKey2 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_DOCCOMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"createTextAttributesKey(...)");
        DOCCOMMENT = textAttributesKey2;
        TextAttributesKey textAttributesKey3 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"createTextAttributesKey(...)");
        KEYWORD = textAttributesKey3;
        TextAttributesKey textAttributesKey4 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_TARGET", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"createTextAttributesKey(...)");
        TARGET = textAttributesKey4;
        TextAttributesKey textAttributesKey5 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_SPECIAL_TARGET", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"createTextAttributesKey(...)");
        SPECIAL_TARGET = textAttributesKey5;
        TextAttributesKey textAttributesKey6 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_SEPARATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey6, (String)"createTextAttributesKey(...)");
        SEPARATOR = textAttributesKey6;
        TextAttributesKey textAttributesKey7 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_PREREQUISITE", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey7, (String)"createTextAttributesKey(...)");
        PREREQUISITE = textAttributesKey7;
        TextAttributesKey textAttributesKey8 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.GLOBAL_VARIABLE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey8, (String)"createTextAttributesKey(...)");
        VARIABLE = textAttributesKey8;
        TextAttributesKey textAttributesKey9 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_VARIABLE_VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey9, (String)"createTextAttributesKey(...)");
        VARIABLE_VALUE = textAttributesKey9;
        TextAttributesKey textAttributesKey10 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey10, (String)"createTextAttributesKey(...)");
        STRING = textAttributesKey10;
        TextAttributesKey textAttributesKey11 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_LINE_SPLIT", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey11, (String)"createTextAttributesKey(...)");
        LINE_SPLIT = textAttributesKey11;
        TextAttributesKey textAttributesKey12 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_TAB", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey12, (String)"createTextAttributesKey(...)");
        TAB = textAttributesKey12;
        TextAttributesKey textAttributesKey13 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey13, (String)"createTextAttributesKey(...)");
        FUNCTION = textAttributesKey13;
        TextAttributesKey textAttributesKey14 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_FUNCTION_PARAM", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey14, (String)"createTextAttributesKey(...)");
        FUNCTION_PARAM = textAttributesKey14;
        TextAttributesKey textAttributesKey15 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey15, (String)"createTextAttributesKey(...)");
        BRACES = textAttributesKey15;
        TextAttributesKey textAttributesKey16 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey16, (String)"createTextAttributesKey(...)");
        PARENS = textAttributesKey16;
        TextAttributesKey textAttributesKey17 = TextAttributesKey.createTextAttributesKey((String)"MAKEFILE_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey17, (String)"createTextAttributesKey(...)");
        BAD_CHARACTER = textAttributesKey17;
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{BAD_CHARACTER};
        BAD_CHAR_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{SEPARATOR};
        SEPARATOR_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{KEYWORD};
        KEYWORD_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{TARGET};
        TARGET_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{PREREQUISITE};
        PREREQUISITE_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{VARIABLE};
        VARIABLE_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{VARIABLE_VALUE};
        VARIABLE_VALUE_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{STRING};
        STRING_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{LINE_SPLIT};
        LINE_SPLIT_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{TAB};
        TAB_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{COMMENT};
        COMMENT_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{DOCCOMMENT};
        DOCCOMMENT_KEYS = textAttributesKeyArray;
        textAttributesKeyArray = new TextAttributesKey[]{BRACES, PARENS};
        BRACES_KEYS = textAttributesKeyArray;
        EMPTY_KEYS = new TextAttributesKey[0];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u0011\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0016\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0016\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0016\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0016\u0010\u0013\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0016\u0010\u0015\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0016\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0016\u0010\u0019\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u0016\u0010\u001b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u0016\u0010\u001d\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u0016\u0010\u001f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u0016\u0010!\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\bR\u0016\u0010#\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\bR\u0013\u0010%\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010&\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010'\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u0010*\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u0010+\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u0010,\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u0010-\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u0010.\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u0010/\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u00100\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u00101\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u00102\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u00103\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u00104\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u001b\u00105\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)\u00a8\u00067"}, d2={"Lcom/jetbrains/lang/makefile/MakefileSyntaxHighlighter$Companion;", "", "<init>", "()V", "COMMENT", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "getCOMMENT", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "DOCCOMMENT", "getDOCCOMMENT", "KEYWORD", "getKEYWORD", "TARGET", "getTARGET", "SPECIAL_TARGET", "getSPECIAL_TARGET", "SEPARATOR", "getSEPARATOR", "PREREQUISITE", "getPREREQUISITE", "VARIABLE", "getVARIABLE", "VARIABLE_VALUE", "getVARIABLE_VALUE", "STRING", "getSTRING", "LINE_SPLIT", "getLINE_SPLIT", "TAB", "getTAB", "FUNCTION", "getFUNCTION", "FUNCTION_PARAM", "getFUNCTION_PARAM", "BRACES", "getBRACES", "PARENS", "BAD_CHARACTER", "BAD_CHAR_KEYS", "", "[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "SEPARATOR_KEYS", "KEYWORD_KEYS", "TARGET_KEYS", "PREREQUISITE_KEYS", "VARIABLE_KEYS", "VARIABLE_VALUE_KEYS", "STRING_KEYS", "LINE_SPLIT_KEYS", "TAB_KEYS", "COMMENT_KEYS", "DOCCOMMENT_KEYS", "BRACES_KEYS", "EMPTY_KEYS", "intellij.makefile"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextAttributesKey getCOMMENT() {
            return COMMENT;
        }

        @NotNull
        public final TextAttributesKey getDOCCOMMENT() {
            return DOCCOMMENT;
        }

        @NotNull
        public final TextAttributesKey getKEYWORD() {
            return KEYWORD;
        }

        @NotNull
        public final TextAttributesKey getTARGET() {
            return TARGET;
        }

        @NotNull
        public final TextAttributesKey getSPECIAL_TARGET() {
            return SPECIAL_TARGET;
        }

        @NotNull
        public final TextAttributesKey getSEPARATOR() {
            return SEPARATOR;
        }

        @NotNull
        public final TextAttributesKey getPREREQUISITE() {
            return PREREQUISITE;
        }

        @NotNull
        public final TextAttributesKey getVARIABLE() {
            return VARIABLE;
        }

        @NotNull
        public final TextAttributesKey getVARIABLE_VALUE() {
            return VARIABLE_VALUE;
        }

        @NotNull
        public final TextAttributesKey getSTRING() {
            return STRING;
        }

        @NotNull
        public final TextAttributesKey getLINE_SPLIT() {
            return LINE_SPLIT;
        }

        @NotNull
        public final TextAttributesKey getTAB() {
            return TAB;
        }

        @NotNull
        public final TextAttributesKey getFUNCTION() {
            return FUNCTION;
        }

        @NotNull
        public final TextAttributesKey getFUNCTION_PARAM() {
            return FUNCTION_PARAM;
        }

        @NotNull
        public final TextAttributesKey getBRACES() {
            return BRACES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

