/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 3722530947723L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1205712930 - -15626, 1205712930 - 19150, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1205712930 - -15627, -1205712930 - -20828, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 71277639203119L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.x();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1637981790 + -((char)-7596), 1638112860 - (char)-1935, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1637981790 + -((char)-7597), -1637981790 + -((char)-6875), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1637981790 + -((char)-7590), 1638112860 - (char)-21479, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 88068805334074L;
                Object object = this.lock;
                n2 = SshAgentIpcService.x();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(500949540 - 20424, 500949540 + 1466, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(500949540 - 20421, 500949540 + 1801, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(500949540 - 20422, 500949540 + 921, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(500949540 - 20435, -500949540 - -10440, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(500949540 - 20436, 500949540 + 4021, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(500949540 - 20433, 500949540 - 17133, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(500949540 - 20435, -500949540 - -10440, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(500949540 - 20434, 500949540 + 5676, (int)l2));
            if (ActionTimestamp.Y() != null) {
                SshAgentIpcService.Y(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 98315023369472L;
                    n3 = SshAgentIpcService.x();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 9616990142448L;
                int n3 = SshAgentIpcService.x();
                this.assertConnectionThread();
                n2 = n3;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(558358200 + 6887, 558358200 - 18339, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(558358200 + 6883, -558358200 - -3110, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(558358200 + 6886, 558358200 + 5041, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(558358200 + 6883, -558358200 - -3110, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(558358200 + 6885, -558358200 - -7838, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(558358200 + 6887, 558358200 - 18339, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(558358200 + 6883, -558358200 - -3110, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(558358200 + 6884, 558358200 - 22187, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(558358200 + 6887, 558358200 - 18339, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(558358200 + 6883, -558358200 - -3110, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(558358200 + 6859, 558358200 - 538, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(558358200 + 6883, -558358200 - -3110, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(558358200 + 6858, 558358200 + 6165, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(558358200 + 6883, -558358200 - -3110, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(558358200 + 6885, -558358200 - -7838, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(558358200 + 6887, 558358200 - 18339, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(558358200 + 6883, -558358200 - -3110, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(558358200 + 6857, 558358200 - 17223, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 934486336044L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1816499130 + -((char)-13208), 1816499130 + 30685, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 127758510889840L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(413656920 + (char)-213, -413656920 + -((char)-5846), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00ff\u00f0\u00c8\bj\"\u0088m,\u00c0X\u0003e\u00d7\u00ea\u00a1\u00bdg\u00f1\u0014\u00b6\u00b1\u00e1&T%2\b\u00f9j'\u0082H\u001e\u008e\u0013\u00dc\u00f7\u00da\u000f";
                        var4_3 = "\u00ff\u00f0\u00c8\bj\"\u0088m,\u00c0X\u0003e\u00d7\u00ea\u00a1\u00bdg\u00f1\u0014\u00b6\u00b1\u00e1&T%2\b\u00f9j'\u0082H\u001e\u008e\u0013\u00dc\u00f7\u00da\u000f".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 39;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 3;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 81;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 64;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 127;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 79;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 31;
                                        break;
                                    }
                                    default: {
                                        v11 = 57;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x7DF2) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 28;
                            case 1 -> 24;
                            case 2 -> 244;
                            case 3 -> 233;
                            case 4 -> 251;
                            case 5 -> 146;
                            case 6 -> 241;
                            case 7 -> 175;
                            case 8 -> 196;
                            case 9 -> 195;
                            case 10 -> 0;
                            case 11 -> 253;
                            case 12 -> 192;
                            case 13 -> 9;
                            case 14 -> 238;
                            case 15 -> 149;
                            case 16 -> 223;
                            case 17 -> 147;
                            case 18 -> 117;
                            case 19 -> 210;
                            case 20 -> 81;
                            case 21 -> 209;
                            case 22 -> 124;
                            case 23 -> 82;
                            case 24 -> 57;
                            case 25 -> 231;
                            case 26 -> 240;
                            case 27 -> 95;
                            case 28 -> 23;
                            case 29 -> 17;
                            case 30 -> 36;
                            case 31 -> 128;
                            case 32 -> 14;
                            case 33 -> 35;
                            case 34 -> 243;
                            case 35 -> 115;
                            case 36 -> 174;
                            case 37 -> 56;
                            case 38 -> 190;
                            case 39 -> 129;
                            case 40 -> 121;
                            case 41 -> 40;
                            case 42 -> 213;
                            case 43 -> 246;
                            case 44 -> 229;
                            case 45 -> 77;
                            case 46 -> 204;
                            case 47 -> 245;
                            case 48 -> 102;
                            case 49 -> 215;
                            case 50 -> 71;
                            case 51 -> 200;
                            case 52 -> 218;
                            case 53 -> 37;
                            case 54 -> 45;
                            case 55 -> 31;
                            case 56 -> 33;
                            case 57 -> 188;
                            case 58 -> 101;
                            case 59 -> 224;
                            case 60 -> 125;
                            case 61 -> 185;
                            case 62 -> 120;
                            case 63 -> 142;
                            case 64 -> 227;
                            case 65 -> 92;
                            case 66 -> 226;
                            case 67 -> 187;
                            case 68 -> 2;
                            case 69 -> 198;
                            case 70 -> 13;
                            case 71 -> 116;
                            case 72 -> 5;
                            case 73 -> 79;
                            case 74 -> 170;
                            case 75 -> 32;
                            case 76 -> 178;
                            case 77 -> 68;
                            case 78 -> 214;
                            case 79 -> 51;
                            case 80 -> 50;
                            case 81 -> 98;
                            case 82 -> 168;
                            case 83 -> 113;
                            case 84 -> 151;
                            case 85 -> 165;
                            case 86 -> 166;
                            case 87 -> 16;
                            case 88 -> 39;
                            case 89 -> 234;
                            case 90 -> 10;
                            case 91 -> 159;
                            case 92 -> 22;
                            case 93 -> 99;
                            case 94 -> 219;
                            case 95 -> 131;
                            case 96 -> 53;
                            case 97 -> 137;
                            case 98 -> 70;
                            case 99 -> 158;
                            case 100 -> 169;
                            case 101 -> 235;
                            case 102 -> 167;
                            case 103 -> 249;
                            case 104 -> 156;
                            case 105 -> 144;
                            case 106 -> 48;
                            case 107 -> 191;
                            case 108 -> 3;
                            case 109 -> 44;
                            case 110 -> 206;
                            case 111 -> 27;
                            case 112 -> 38;
                            case 113 -> 236;
                            case 114 -> 254;
                            case 115 -> 107;
                            case 116 -> 49;
                            case 117 -> 176;
                            case 118 -> 162;
                            case 119 -> 230;
                            case 120 -> 252;
                            case 121 -> 59;
                            case 122 -> 83;
                            case 123 -> 163;
                            case 124 -> 111;
                            case 125 -> 132;
                            case 126 -> 29;
                            case 127 -> 154;
                            case 128 -> 103;
                            case 129 -> 177;
                            case 130 -> 143;
                            case 131 -> 194;
                            case 132 -> 119;
                            case 133 -> 186;
                            case 134 -> 105;
                            case 135 -> 130;
                            case 136 -> 199;
                            case 137 -> 91;
                            case 138 -> 66;
                            case 139 -> 20;
                            case 140 -> 26;
                            case 141 -> 184;
                            case 142 -> 12;
                            case 143 -> 160;
                            case 144 -> 197;
                            case 145 -> 179;
                            case 146 -> 18;
                            case 147 -> 221;
                            case 148 -> 19;
                            case 149 -> 152;
                            case 150 -> 15;
                            case 151 -> 217;
                            case 152 -> 127;
                            case 153 -> 193;
                            case 154 -> 46;
                            case 155 -> 94;
                            case 156 -> 118;
                            case 157 -> 150;
                            case 158 -> 1;
                            case 159 -> 65;
                            case 160 -> 42;
                            case 161 -> 109;
                            case 162 -> 89;
                            case 163 -> 138;
                            case 164 -> 220;
                            case 165 -> 242;
                            case 166 -> 90;
                            case 167 -> 4;
                            case 168 -> 62;
                            case 169 -> 60;
                            case 170 -> 41;
                            case 171 -> 97;
                            case 172 -> 84;
                            case 173 -> 25;
                            case 174 -> 11;
                            case 175 -> 93;
                            case 176 -> 140;
                            case 177 -> 34;
                            case 178 -> 216;
                            case 179 -> 255;
                            case 180 -> 173;
                            case 181 -> 201;
                            case 182 -> 208;
                            case 183 -> 47;
                            case 184 -> 75;
                            case 185 -> 106;
                            case 186 -> 222;
                            case 187 -> 86;
                            case 188 -> 30;
                            case 189 -> 72;
                            case 190 -> 52;
                            case 191 -> 73;
                            case 192 -> 180;
                            case 193 -> 54;
                            case 194 -> 110;
                            case 195 -> 61;
                            case 196 -> 172;
                            case 197 -> 64;
                            case 198 -> 133;
                            case 199 -> 139;
                            case 200 -> 211;
                            case 201 -> 21;
                            case 202 -> 181;
                            case 203 -> 123;
                            case 204 -> 250;
                            case 205 -> 171;
                            case 206 -> 228;
                            case 207 -> 207;
                            case 208 -> 135;
                            case 209 -> 108;
                            case 210 -> 58;
                            case 211 -> 247;
                            case 212 -> 112;
                            case 213 -> 225;
                            case 214 -> 155;
                            case 215 -> 145;
                            case 216 -> 205;
                            case 217 -> 189;
                            case 218 -> 85;
                            case 219 -> 6;
                            case 220 -> 69;
                            case 221 -> 212;
                            case 222 -> 104;
                            case 223 -> 183;
                            case 224 -> 161;
                            case 225 -> 88;
                            case 226 -> 114;
                            case 227 -> 78;
                            case 228 -> 157;
                            case 229 -> 8;
                            case 230 -> 55;
                            case 231 -> 122;
                            case 232 -> 153;
                            case 233 -> 248;
                            case 234 -> 126;
                            case 235 -> 43;
                            case 236 -> 203;
                            case 237 -> 202;
                            case 238 -> 232;
                            case 239 -> 76;
                            case 240 -> 7;
                            case 241 -> 182;
                            case 242 -> 136;
                            case 243 -> 96;
                            case 244 -> 164;
                            case 245 -> 239;
                            case 246 -> 237;
                            case 247 -> 80;
                            case 248 -> 74;
                            case 249 -> 63;
                            case 250 -> 67;
                            case 251 -> 141;
                            case 252 -> 87;
                            case 253 -> 100;
                            case 254 -> 148;
                            default -> 134;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 == 0) {
                ActionTimestamp.Y(new String[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 111223717596522L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.Y();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1244509650 - 10957, 1244509650 + 12221, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1244509650 - 10961, -1244509650 - -5574, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1244509650 - 10936, 1244509650 - 1218, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1244509650 - 10957, 1244509650 + 12221, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1244509650 - 10961, -1244509650 - -5574, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1244509650 - 10933, -1244509650 - -4450, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 90957575225671L;
                        int n3 = SshAgentIpcService.x();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1242150390 + -17113, 1242150390 + 5067, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1242150390 + -17112, 1242150390 + 18364, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 23485917015124L;
                int n3 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                Object object2 = this.lock;
                n2 = n3;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1035846210 - 6151, 1035846210 + 623, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1035846210 - 6147, -1035846210 - -16652, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1035846210 - 6178, -1035846210 + -14183, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1035846210 - 6147, -1035846210 - -16652, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1035846210 - 6153, -1035846210 - -11908, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1035846210 - 6151, 1035846210 + 623, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1035846210 - 6147, -1035846210 - -16652, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1035846210 - 6163, -1035846210 - -4199, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1035846210 - 6151, 1035846210 + 623, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1035846210 - 6147, -1035846210 - -16652, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1035846210 - 6164, -1035846210 + -7256, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1035846210 - 6151, 1035846210 + 623, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1035846210 - 6147, -1035846210 - -16652, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1035846210 - 6165, 1035846210 + 13596, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 66918965691757L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.Y();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 != 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-919718190 + -29648, -919718190 + -((char)-30390), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-919718190 + -29644, 919718190 + 20165, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-919718190 + -29629, -919718190 + -25866, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-919718190 + -29632, 919718190 + (char)-23530, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-919718190 + -29648, -919718190 + -((char)-30390), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-919718190 + -29644, 919718190 + 20165, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-919718190 + -29631, -919718190 + -21563, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 != 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 != 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-919718190 + -29648, -919718190 + -((char)-30390), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-919718190 + -29644, 919718190 + 20165, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-919718190 + -29634, -919718190 + -((char)-21877), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-919718190 + -29648, -919718190 + -((char)-30390), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-919718190 + -29644, 919718190 + 20165, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-919718190 + -29633, 919718190 + (char)-22285, (int)l2));
                    if (n3 != 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-919718190 + -29648, -919718190 + -((char)-30390), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-919718190 + -29644, 919718190 + 20165, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-919718190 + -29604, 919718190 + 29977, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-919718190 + -29603, 919718190 + 29026, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00ed\u00ce\u00a1\u00d4p\u00da\u00ca;\u0014\u00f7l\u00dag\u00e1$W\u00feD8\u00ab@Vk\u0015\u00fcEc\u00fe\u0004\u0006\u008a\u00e1M1\u0087'\u0018\u00ea\u0002\u0019\u009a\u001b^\nq'\u00b4\u00c8\u00a1\\\u00a8\u0006\u0006\u008eU\u00a9_b\u00c4\u00f8~\tmDw\u00e3\u00bd\u00ee\u00c6/\u0082\u0005C#ti\u00ba\b\u00fb\u008dc\u00cdz\u00df\u008dy\u0014qTr\u00fb\u0099\u00bfm\u001amy%\u00dc\u00cd[\u00dd\u0017N\u00cdf\u0093\u0005\u00c0\u0007\u0004\u00ed\u00b4\u001e\u00caXPb\u00a3\u0085\u00bfp4\u0080\u00e1\u00a05\u00a8\u0089b\u009eHy\b\u00d4\u0001\"\u000b0\u0083q\u00c9%\u00ac\u0010\u00d9\u00d3\u00d6\u00d6$!\u00b9\u001d\u0089\u009f\u00db\u00bet>\u000e/\t\u00b1\u00a7:\u008eGd\u00bf\u00e1C\u0010\u0006\u008d-\u001d[XV2tzd\u0002\u0083\u00a9\u00f0\u00dd?2\u00d6G\u00b3L\u00b6\u00c7zJ\u0010kI\u00dbci\"G%?`\u0092^\u0091\u0086V\u00da\u00b0V*\t\u00d0[\u00d2\u00dc\u00f8\u00be\u00a7.\u00ab\u008c\u0012\u00d0\u00cdu\u00ca\u00a1\u00ff\u000b\u00b7\u00bf\u009b\u00cb5l\u00f37\u00e1T~\u00da+\u009bH\b\u00a0\u001e\b\u00bf\u0017\u0091 \u00b0\f\u00a1/8\u0082\fT\u00ad\u000f\"\u0095\u00fc\u00fbF\u00df\u0002\u00f7'\u00f5\u00e0\u0092\u0099\u00c5K\n\u00e4a\u00de!\u00b3\u00b2p\u0081eW\u00ac*\u00ea\u0017|k\u0089\u00ee\u00dbr=\u00ba\u00a67\u00d0\u0084\u00aedXx_\u000b\u007f\u00ccek\u00ee\u00c2\u00fbS\u00e9\u00c3\u00be;vg\b8\u00ed\u00d0\u0014k-o\u0013X\u0089\u00c9\u00fa\u001f\u00cf\u00eb\u00f0\u0014\u00b7K=\u00a9d\u00bb\u00eb\u00c7tY\u00aa\u00ed\u0081Q\u00e7\u00e1\u00cc\u00bc\u00f6\u0017\u00cb\u00d0\u0019o5\u0089\u000b\u000b_l\u00e7\u00ea\u00f7Y\u00d2\u00ae\u00cd\u00ad\u000b\u0015\u00e5;\u00b0\u0003\u001a\f\u0083y\u00d9\u00b7A\u008d\u009f\u00bc\u00ca\u0007v\u0098\u00c4\u00a1\u009e)\u00e1\r5\u00c8\u000f\u00d0*\u00da\u0086\u00d5\u00b7\n\u00fb\u00ea\u00c5\u009e3\u00b7j\u009a\u008d\u00ab\u0018\u00edy\u00c6\u0098\u00d5**j=G\u0003\u00ee\u00e9\u00a1\u0094K\u00b6>\u0007\u00bd\u00f7\u00b4\u008d\u001b%3\u0007\u00b2\u00bf1\u00e8Lf\u00cf(\u0007?\u00a5\u00af\u00adV\u0088-\u00a2\u00fc\u0019\u0019\r\tYa\u00a7\u00e5V\u0093k\u00b4\u00ab\u00c5\u009f\u007f\u00f2\u0099P\u00c3\u00fe\u0019.\u00ec]\u00b9m\u00e3A\u00ab\u000fb\u00e1G]\u0019d\u00bb\u00a8\u00b1\u00c1\u00da\u00ef\u00d5\u0083\u00dc\"\u0006\u00b3\u00c9\u001f\u0090*\u00d9\u0085\u00f8>xw\u0001I\u00fe$\u00bf\u00c9q\u0017\u0004\u001a\u0089\u008b\u00d8^a\u00181\u00a1\u00abKQ>\u000e]\u001c\u00a0\u00e2\u00e5\u0093$VB\u001e\u00a4\u0014\u0016\u00f6\u001bh\u00e9\u0001Y*QHR\u0098\u0019r\u00f5\u009c\u00fck\u0084\u00a5w\u008f\\\u00e0Gf\u0086n\u0092\u00e2\n\u00eei\u0015N\u00bcWI\u00b8\u0013&\u0018\u00e1\u00dc0\u00f2\r\u0098\u008d5><d\u00ce\u00e7\u00c8\u00f8#\u00a0\u0082\u00f8\u009bv\u00f4\u00ef\u00a3)\u00c8\u00b9\u0010^\u00ab\u0002\u00be\u0080\u0014\u009e\u00e5c\u00b5\u00ce\u0093a\u0087=#\u000e\u009e)3\u00b1i\u00df\u0007\u001a\u008a\u008f\u00c5\u0018\u0097y!2\u0086\u00cb\u00af]\u00a2\t\u0085\u0002\u00bc$\u009d\u00fe\u00b2\u00e9_";
                var4_3 = "\u00ed\u00ce\u00a1\u00d4p\u00da\u00ca;\u0014\u00f7l\u00dag\u00e1$W\u00feD8\u00ab@Vk\u0015\u00fcEc\u00fe\u0004\u0006\u008a\u00e1M1\u0087'\u0018\u00ea\u0002\u0019\u009a\u001b^\nq'\u00b4\u00c8\u00a1\\\u00a8\u0006\u0006\u008eU\u00a9_b\u00c4\u00f8~\tmDw\u00e3\u00bd\u00ee\u00c6/\u0082\u0005C#ti\u00ba\b\u00fb\u008dc\u00cdz\u00df\u008dy\u0014qTr\u00fb\u0099\u00bfm\u001amy%\u00dc\u00cd[\u00dd\u0017N\u00cdf\u0093\u0005\u00c0\u0007\u0004\u00ed\u00b4\u001e\u00caXPb\u00a3\u0085\u00bfp4\u0080\u00e1\u00a05\u00a8\u0089b\u009eHy\b\u00d4\u0001\"\u000b0\u0083q\u00c9%\u00ac\u0010\u00d9\u00d3\u00d6\u00d6$!\u00b9\u001d\u0089\u009f\u00db\u00bet>\u000e/\t\u00b1\u00a7:\u008eGd\u00bf\u00e1C\u0010\u0006\u008d-\u001d[XV2tzd\u0002\u0083\u00a9\u00f0\u00dd?2\u00d6G\u00b3L\u00b6\u00c7zJ\u0010kI\u00dbci\"G%?`\u0092^\u0091\u0086V\u00da\u00b0V*\t\u00d0[\u00d2\u00dc\u00f8\u00be\u00a7.\u00ab\u008c\u0012\u00d0\u00cdu\u00ca\u00a1\u00ff\u000b\u00b7\u00bf\u009b\u00cb5l\u00f37\u00e1T~\u00da+\u009bH\b\u00a0\u001e\b\u00bf\u0017\u0091 \u00b0\f\u00a1/8\u0082\fT\u00ad\u000f\"\u0095\u00fc\u00fbF\u00df\u0002\u00f7'\u00f5\u00e0\u0092\u0099\u00c5K\n\u00e4a\u00de!\u00b3\u00b2p\u0081eW\u00ac*\u00ea\u0017|k\u0089\u00ee\u00dbr=\u00ba\u00a67\u00d0\u0084\u00aedXx_\u000b\u007f\u00ccek\u00ee\u00c2\u00fbS\u00e9\u00c3\u00be;vg\b8\u00ed\u00d0\u0014k-o\u0013X\u0089\u00c9\u00fa\u001f\u00cf\u00eb\u00f0\u0014\u00b7K=\u00a9d\u00bb\u00eb\u00c7tY\u00aa\u00ed\u0081Q\u00e7\u00e1\u00cc\u00bc\u00f6\u0017\u00cb\u00d0\u0019o5\u0089\u000b\u000b_l\u00e7\u00ea\u00f7Y\u00d2\u00ae\u00cd\u00ad\u000b\u0015\u00e5;\u00b0\u0003\u001a\f\u0083y\u00d9\u00b7A\u008d\u009f\u00bc\u00ca\u0007v\u0098\u00c4\u00a1\u009e)\u00e1\r5\u00c8\u000f\u00d0*\u00da\u0086\u00d5\u00b7\n\u00fb\u00ea\u00c5\u009e3\u00b7j\u009a\u008d\u00ab\u0018\u00edy\u00c6\u0098\u00d5**j=G\u0003\u00ee\u00e9\u00a1\u0094K\u00b6>\u0007\u00bd\u00f7\u00b4\u008d\u001b%3\u0007\u00b2\u00bf1\u00e8Lf\u00cf(\u0007?\u00a5\u00af\u00adV\u0088-\u00a2\u00fc\u0019\u0019\r\tYa\u00a7\u00e5V\u0093k\u00b4\u00ab\u00c5\u009f\u007f\u00f2\u0099P\u00c3\u00fe\u0019.\u00ec]\u00b9m\u00e3A\u00ab\u000fb\u00e1G]\u0019d\u00bb\u00a8\u00b1\u00c1\u00da\u00ef\u00d5\u0083\u00dc\"\u0006\u00b3\u00c9\u001f\u0090*\u00d9\u0085\u00f8>xw\u0001I\u00fe$\u00bf\u00c9q\u0017\u0004\u001a\u0089\u008b\u00d8^a\u00181\u00a1\u00abKQ>\u000e]\u001c\u00a0\u00e2\u00e5\u0093$VB\u001e\u00a4\u0014\u0016\u00f6\u001bh\u00e9\u0001Y*QHR\u0098\u0019r\u00f5\u009c\u00fck\u0084\u00a5w\u008f\\\u00e0Gf\u0086n\u0092\u00e2\n\u00eei\u0015N\u00bcWI\u00b8\u0013&\u0018\u00e1\u00dc0\u00f2\r\u0098\u008d5><d\u00ce\u00e7\u00c8\u00f8#\u00a0\u0082\u00f8\u009bv\u00f4\u00ef\u00a3)\u00c8\u00b9\u0010^\u00ab\u0002\u00be\u0080\u0014\u009e\u00e5c\u00b5\u00ce\u0093a\u0087=#\u000e\u009e)3\u00b1i\u00df\u0007\u001a\u008a\u008f\u00c5\u0018\u0097y!2\u0086\u00cb\u00af]\u00a2\t\u0085\u0002\u00bc$\u009d\u00fe\u00b2\u00e9_".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 53;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u008d\u00aaU\u00d1\u00ee\u001e\u00fb\u00eeQ\u00be\u00a0\u008a\u00f0\u001e\u00d6\u0096\u00c2\"6\u0084\u0084\u00aan\u00f2\u0084F\u00c6\u0081\u00cf\u0014q~\u00e7\u00c8\u00ab<\u00f3\u0010=\bi\u00ab\u00e3\u00fbN\u0003\u00c3q\u00c3\u00ab";
                    var4_3 = "\u008d\u00aaU\u00d1\u00ee\u001e\u00fb\u00eeQ\u00be\u00a0\u008a\u00f0\u001e\u00d6\u0096\u00c2\"6\u0084\u0084\u00aan\u00f2\u0084F\u00c6\u0081\u00cf\u0014q~\u00e7\u00c8\u00ab<\u00f3\u0010=\bi\u00ab\u00e3\u00fbN\u0003\u00c3q\u00c3\u00ab".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 112;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 124;
                            break;
                        }
                        case 1: {
                            v15 = 118;
                            break;
                        }
                        case 2: {
                            v15 = 14;
                            break;
                        }
                        case 3: {
                            v15 = 113;
                            break;
                        }
                        case 4: {
                            v15 = 56;
                            break;
                        }
                        case 5: {
                            v15 = 85;
                            break;
                        }
                        default: {
                            v15 = 126;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x663) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 240;
                case 1 -> 254;
                case 2 -> 170;
                case 3 -> 244;
                case 4 -> 28;
                case 5 -> 97;
                case 6 -> 52;
                case 7 -> 21;
                case 8 -> 249;
                case 9 -> 199;
                case 10 -> 106;
                case 11 -> 250;
                case 12 -> 122;
                case 13 -> 146;
                case 14 -> 31;
                case 15 -> 188;
                case 16 -> 179;
                case 17 -> 55;
                case 18 -> 166;
                case 19 -> 142;
                case 20 -> 220;
                case 21 -> 176;
                case 22 -> 85;
                case 23 -> 211;
                case 24 -> 200;
                case 25 -> 137;
                case 26 -> 7;
                case 27 -> 101;
                case 28 -> 136;
                case 29 -> 156;
                case 30 -> 123;
                case 31 -> 222;
                case 32 -> 65;
                case 33 -> 138;
                case 34 -> 144;
                case 35 -> 157;
                case 36 -> 100;
                case 37 -> 163;
                case 38 -> 162;
                case 39 -> 46;
                case 40 -> 61;
                case 41 -> 159;
                case 42 -> 115;
                case 43 -> 96;
                case 44 -> 167;
                case 45 -> 108;
                case 46 -> 248;
                case 47 -> 202;
                case 48 -> 4;
                case 49 -> 178;
                case 50 -> 103;
                case 51 -> 212;
                case 52 -> 153;
                case 53 -> 181;
                case 54 -> 191;
                case 55 -> 225;
                case 56 -> 12;
                case 57 -> 36;
                case 58 -> 94;
                case 59 -> 74;
                case 60 -> 6;
                case 61 -> 171;
                case 62 -> 218;
                case 63 -> 72;
                case 64 -> 238;
                case 65 -> 1;
                case 66 -> 116;
                case 67 -> 174;
                case 68 -> 112;
                case 69 -> 127;
                case 70 -> 35;
                case 71 -> 151;
                case 72 -> 76;
                case 73 -> 26;
                case 74 -> 241;
                case 75 -> 177;
                case 76 -> 0;
                case 77 -> 83;
                case 78 -> 149;
                case 79 -> 189;
                case 80 -> 37;
                case 81 -> 246;
                case 82 -> 19;
                case 83 -> 252;
                case 84 -> 247;
                case 85 -> 32;
                case 86 -> 120;
                case 87 -> 253;
                case 88 -> 45;
                case 89 -> 73;
                case 90 -> 255;
                case 91 -> 132;
                case 92 -> 92;
                case 93 -> 161;
                case 94 -> 221;
                case 95 -> 145;
                case 96 -> 8;
                case 97 -> 237;
                case 98 -> 235;
                case 99 -> 223;
                case 100 -> 30;
                case 101 -> 56;
                case 102 -> 9;
                case 103 -> 50;
                case 104 -> 175;
                case 105 -> 25;
                case 106 -> 87;
                case 107 -> 182;
                case 108 -> 229;
                case 109 -> 209;
                case 110 -> 80;
                case 111 -> 230;
                case 112 -> 24;
                case 113 -> 69;
                case 114 -> 214;
                case 115 -> 5;
                case 116 -> 131;
                case 117 -> 84;
                case 118 -> 140;
                case 119 -> 118;
                case 120 -> 64;
                case 121 -> 57;
                case 122 -> 117;
                case 123 -> 88;
                case 124 -> 113;
                case 125 -> 201;
                case 126 -> 81;
                case 127 -> 231;
                case 128 -> 213;
                case 129 -> 111;
                case 130 -> 38;
                case 131 -> 42;
                case 132 -> 79;
                case 133 -> 160;
                case 134 -> 129;
                case 135 -> 184;
                case 136 -> 227;
                case 137 -> 165;
                case 138 -> 102;
                case 139 -> 18;
                case 140 -> 197;
                case 141 -> 54;
                case 142 -> 148;
                case 143 -> 239;
                case 144 -> 22;
                case 145 -> 95;
                case 146 -> 234;
                case 147 -> 243;
                case 148 -> 128;
                case 149 -> 66;
                case 150 -> 194;
                case 151 -> 20;
                case 152 -> 134;
                case 153 -> 233;
                case 154 -> 210;
                case 155 -> 48;
                case 156 -> 215;
                case 157 -> 192;
                case 158 -> 125;
                case 159 -> 187;
                case 160 -> 126;
                case 161 -> 41;
                case 162 -> 91;
                case 163 -> 207;
                case 164 -> 11;
                case 165 -> 110;
                case 166 -> 203;
                case 167 -> 158;
                case 168 -> 104;
                case 169 -> 99;
                case 170 -> 71;
                case 171 -> 219;
                case 172 -> 228;
                case 173 -> 141;
                case 174 -> 226;
                case 175 -> 39;
                case 176 -> 180;
                case 177 -> 10;
                case 178 -> 143;
                case 179 -> 164;
                case 180 -> 251;
                case 181 -> 216;
                case 182 -> 185;
                case 183 -> 198;
                case 184 -> 208;
                case 185 -> 49;
                case 186 -> 34;
                case 187 -> 206;
                case 188 -> 154;
                case 189 -> 60;
                case 190 -> 186;
                case 191 -> 93;
                case 192 -> 224;
                case 193 -> 27;
                case 194 -> 62;
                case 195 -> 17;
                case 196 -> 172;
                case 197 -> 68;
                case 198 -> 193;
                case 199 -> 195;
                case 200 -> 107;
                case 201 -> 98;
                case 202 -> 183;
                case 203 -> 14;
                case 204 -> 86;
                case 205 -> 204;
                case 206 -> 13;
                case 207 -> 242;
                case 208 -> 47;
                case 209 -> 51;
                case 210 -> 147;
                case 211 -> 135;
                case 212 -> 53;
                case 213 -> 77;
                case 214 -> 124;
                case 215 -> 150;
                case 216 -> 217;
                case 217 -> 105;
                case 218 -> 15;
                case 219 -> 29;
                case 220 -> 82;
                case 221 -> 75;
                case 222 -> 173;
                case 223 -> 121;
                case 224 -> 152;
                case 225 -> 190;
                case 226 -> 90;
                case 227 -> 130;
                case 228 -> 119;
                case 229 -> 139;
                case 230 -> 23;
                case 231 -> 3;
                case 232 -> 43;
                case 233 -> 67;
                case 234 -> 40;
                case 235 -> 169;
                case 236 -> 196;
                case 237 -> 59;
                case 238 -> 63;
                case 239 -> 205;
                case 240 -> 16;
                case 241 -> 89;
                case 242 -> 70;
                case 243 -> 58;
                case 244 -> 2;
                case 245 -> 114;
                case 246 -> 155;
                case 247 -> 33;
                case 248 -> 168;
                case 249 -> 232;
                case 250 -> 133;
                case 251 -> 109;
                case 252 -> 245;
                case 253 -> 44;
                case 254 -> 236;
                default -> 78;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 102041772444761L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1939442790 - 30292, 1939442790 - 21239, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 136200023615355L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.x();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1979288070 - -((char)-30921), 1979288070 - 13300, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1979288070 - -((char)-30920), -1979288070 - -21704, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1979288070 - -((char)-30919), 1979288070 - (char)-31745, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b8\u00ef\u00d0\u00a9&IF,\u0010\u0003\u0096V'L#\u00f28G\u00e0[)X\u008a\u00ee\u001e";
                    var4_3 = "\u00b8\u00ef\u00d0\u00a9&IF,\u0010\u0003\u0096V'L#\u00f28G\u00e0[)X\u008a\u00ee\u001e".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 24;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008e$\u0085Co5\u008d\u00a7\u00f2_S\u0086\u009a\u00b4\u00aeYgM\u00bb\u007f\u0004\u00b9\u00bcU<P;+<4H\u00c8\u00c3\u00eb\"\u00baH\u00a0\u00d6\u00b0\u00a9\u0084|\u000b^\u00a8\u00b3\u00ae\u0098f}\u00e2\u0010^+\u0015/\u00f3,";
                        var4_3 = "\u008e$\u0085Co5\u008d\u00a7\u00f2_S\u0086\u009a\u00b4\u00aeYgM\u00bb\u007f\u0004\u00b9\u00bcU<P;+<4H\u00c8\u00c3\u00eb\"\u00baH\u00a0\u00d6\u00b0\u00a9\u0084|\u000b^\u00a8\u00b3\u00ae\u0098f}\u00e2\u0010^+\u0015/\u00f3,".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 45;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 87;
                                break;
                            }
                            case 1: {
                                v15 = 88;
                                break;
                            }
                            case 2: {
                                v15 = 56;
                                break;
                            }
                            case 3: {
                                v15 = 101;
                                break;
                            }
                            case 4: {
                                v15 = 14;
                                break;
                            }
                            case 5: {
                                v15 = 99;
                                break;
                            }
                            default: {
                                v15 = 118;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5A4B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 188;
                    case 1 -> 236;
                    case 2 -> 27;
                    case 3 -> 239;
                    case 4 -> 95;
                    case 5 -> 245;
                    case 6 -> 174;
                    case 7 -> 128;
                    case 8 -> 154;
                    case 9 -> 176;
                    case 10 -> 22;
                    case 11 -> 206;
                    case 12 -> 113;
                    case 13 -> 75;
                    case 14 -> 100;
                    case 15 -> 114;
                    case 16 -> 232;
                    case 17 -> 102;
                    case 18 -> 110;
                    case 19 -> 235;
                    case 20 -> 168;
                    case 21 -> 34;
                    case 22 -> 5;
                    case 23 -> 16;
                    case 24 -> 209;
                    case 25 -> 246;
                    case 26 -> 183;
                    case 27 -> 153;
                    case 28 -> 140;
                    case 29 -> 151;
                    case 30 -> 80;
                    case 31 -> 145;
                    case 32 -> 148;
                    case 33 -> 107;
                    case 34 -> 228;
                    case 35 -> 96;
                    case 36 -> 248;
                    case 37 -> 146;
                    case 38 -> 13;
                    case 39 -> 78;
                    case 40 -> 224;
                    case 41 -> 149;
                    case 42 -> 2;
                    case 43 -> 210;
                    case 44 -> 164;
                    case 45 -> 196;
                    case 46 -> 223;
                    case 47 -> 190;
                    case 48 -> 216;
                    case 49 -> 9;
                    case 50 -> 221;
                    case 51 -> 73;
                    case 52 -> 24;
                    case 53 -> 8;
                    case 54 -> 63;
                    case 55 -> 233;
                    case 56 -> 45;
                    case 57 -> 229;
                    case 58 -> 106;
                    case 59 -> 104;
                    case 60 -> 181;
                    case 61 -> 204;
                    case 62 -> 6;
                    case 63 -> 124;
                    case 64 -> 97;
                    case 65 -> 91;
                    case 66 -> 127;
                    case 67 -> 23;
                    case 68 -> 7;
                    case 69 -> 200;
                    case 70 -> 160;
                    case 71 -> 142;
                    case 72 -> 184;
                    case 73 -> 242;
                    case 74 -> 122;
                    case 75 -> 70;
                    case 76 -> 62;
                    case 77 -> 219;
                    case 78 -> 218;
                    case 79 -> 141;
                    case 80 -> 167;
                    case 81 -> 192;
                    case 82 -> 177;
                    case 83 -> 225;
                    case 84 -> 3;
                    case 85 -> 0;
                    case 86 -> 66;
                    case 87 -> 41;
                    case 88 -> 32;
                    case 89 -> 42;
                    case 90 -> 139;
                    case 91 -> 234;
                    case 92 -> 94;
                    case 93 -> 48;
                    case 94 -> 251;
                    case 95 -> 30;
                    case 96 -> 132;
                    case 97 -> 10;
                    case 98 -> 166;
                    case 99 -> 197;
                    case 100 -> 123;
                    case 101 -> 189;
                    case 102 -> 238;
                    case 103 -> 29;
                    case 104 -> 178;
                    case 105 -> 55;
                    case 106 -> 60;
                    case 107 -> 222;
                    case 108 -> 111;
                    case 109 -> 4;
                    case 110 -> 231;
                    case 111 -> 217;
                    case 112 -> 115;
                    case 113 -> 36;
                    case 114 -> 195;
                    case 115 -> 118;
                    case 116 -> 86;
                    case 117 -> 171;
                    case 118 -> 89;
                    case 119 -> 77;
                    case 120 -> 158;
                    case 121 -> 90;
                    case 122 -> 170;
                    case 123 -> 198;
                    case 124 -> 120;
                    case 125 -> 150;
                    case 126 -> 187;
                    case 127 -> 254;
                    case 128 -> 101;
                    case 129 -> 247;
                    case 130 -> 207;
                    case 131 -> 226;
                    case 132 -> 58;
                    case 133 -> 243;
                    case 134 -> 33;
                    case 135 -> 215;
                    case 136 -> 255;
                    case 137 -> 131;
                    case 138 -> 172;
                    case 139 -> 40;
                    case 140 -> 57;
                    case 141 -> 137;
                    case 142 -> 12;
                    case 143 -> 194;
                    case 144 -> 72;
                    case 145 -> 230;
                    case 146 -> 134;
                    case 147 -> 159;
                    case 148 -> 25;
                    case 149 -> 69;
                    case 150 -> 112;
                    case 151 -> 92;
                    case 152 -> 237;
                    case 153 -> 20;
                    case 154 -> 64;
                    case 155 -> 61;
                    case 156 -> 49;
                    case 157 -> 143;
                    case 158 -> 211;
                    case 159 -> 202;
                    case 160 -> 28;
                    case 161 -> 31;
                    case 162 -> 205;
                    case 163 -> 43;
                    case 164 -> 227;
                    case 165 -> 19;
                    case 166 -> 179;
                    case 167 -> 130;
                    case 168 -> 240;
                    case 169 -> 250;
                    case 170 -> 93;
                    case 171 -> 147;
                    case 172 -> 180;
                    case 173 -> 82;
                    case 174 -> 186;
                    case 175 -> 26;
                    case 176 -> 18;
                    case 177 -> 173;
                    case 178 -> 117;
                    case 179 -> 108;
                    case 180 -> 121;
                    case 181 -> 56;
                    case 182 -> 157;
                    case 183 -> 201;
                    case 184 -> 54;
                    case 185 -> 191;
                    case 186 -> 98;
                    case 187 -> 119;
                    case 188 -> 249;
                    case 189 -> 79;
                    case 190 -> 35;
                    case 191 -> 59;
                    case 192 -> 37;
                    case 193 -> 15;
                    case 194 -> 252;
                    case 195 -> 126;
                    case 196 -> 109;
                    case 197 -> 165;
                    case 198 -> 50;
                    case 199 -> 133;
                    case 200 -> 208;
                    case 201 -> 169;
                    case 202 -> 87;
                    case 203 -> 162;
                    case 204 -> 74;
                    case 205 -> 67;
                    case 206 -> 85;
                    case 207 -> 213;
                    case 208 -> 129;
                    case 209 -> 116;
                    case 210 -> 193;
                    case 211 -> 17;
                    case 212 -> 253;
                    case 213 -> 14;
                    case 214 -> 83;
                    case 215 -> 185;
                    case 216 -> 11;
                    case 217 -> 39;
                    case 218 -> 44;
                    case 219 -> 182;
                    case 220 -> 38;
                    case 221 -> 47;
                    case 222 -> 155;
                    case 223 -> 71;
                    case 224 -> 65;
                    case 225 -> 152;
                    case 226 -> 1;
                    case 227 -> 199;
                    case 228 -> 220;
                    case 229 -> 135;
                    case 230 -> 46;
                    case 231 -> 144;
                    case 232 -> 212;
                    case 233 -> 51;
                    case 234 -> 68;
                    case 235 -> 161;
                    case 236 -> 88;
                    case 237 -> 244;
                    case 238 -> 52;
                    case 239 -> 241;
                    case 240 -> 214;
                    case 241 -> 138;
                    case 242 -> 156;
                    case 243 -> 84;
                    case 244 -> 53;
                    case 245 -> 103;
                    case 246 -> 99;
                    case 247 -> 175;
                    case 248 -> 203;
                    case 249 -> 76;
                    case 250 -> 163;
                    case 251 -> 136;
                    case 252 -> 81;
                    case 253 -> 105;
                    case 254 -> 21;
                    default -> 125;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 98528799197168L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "_NG\r\rOh\u0006\tXDT\u0007@\ru\u001a\u0002";
                    var5_4 = "_NG\r\rOh\u0006\tXDT\u0007@\ru\u001a\u0002".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 42;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 30;
                                    break;
                                }
                                case 1: {
                                    v11 = 1;
                                    break;
                                }
                                case 2: {
                                    v11 = 31;
                                    break;
                                }
                                case 3: {
                                    v11 = 73;
                                    break;
                                }
                                case 4: {
                                    v11 = 66;
                                    break;
                                }
                                case 5: {
                                    v11 = 9;
                                    break;
                                }
                                default: {
                                    v11 = 113;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 70813270855260L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "ym\r\u000b3\u001d\f\u0004\u007fs\u0001\u0011\nsl\n\u0011?\u001f\u0014Ym\u0003\tsl\n\u0011?\u001f\u0014Ug\rtj\u0017\u001c5\u0012\u000eU`\u0010\u00164\u001b";
                    var5_4 = "ym\r\u000b3\u001d\f\u0004\u007fs\u0001\u0011\nsl\n\u0011?\u001f\u0014Ym\u0003\tsl\n\u0011?\u001f\u0014Ug\rtj\u0017\u001c5\u0012\u000eU`\u0010\u00164\u001b".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 56;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "MQ52\r,9\u0006MQ52\u0001&";
                        var5_4 = "MQ52\r,9\u0006MQ52\u0001&".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 6;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 8;
                                break;
                            }
                            case 1: {
                                v15 = 59;
                                break;
                            }
                            case 2: {
                                v15 = 92;
                                break;
                            }
                            case 3: {
                                v15 = 71;
                                break;
                            }
                            case 4: {
                                v15 = 98;
                                break;
                            }
                            case 5: {
                                v15 = 68;
                                break;
                            }
                            default: {
                                v15 = 88;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 61168835136799L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-89127600 - -((char)-8773), 89127600 - (char)-29504, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 54199102960587L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0091\u00ea||\u00e4\u0003\u00b0d\u00ec\u0005\u00ac\u001e\u00fd&7\r$\u009c\u00da<&\u008b\u008b\u00cc|Un\u0016F\u0010\u001a\u000e\u00da\u0085\u0019)G\u00a5,\u00fc\u0087n\u009d}\u008a=\u0005\u00a7\u00b4\u009cs\u001b3\u008d\u00df\u00c8i\u008e\u00f0\u0085\u008a\t\u00e4\u00a8D\u00bei\u00c2\u00a0hO\u0086\u00deG\u00b3\u009b\u0093U\u00f4D\u00b6#\u00ebk\u00f5$q\u009b\u0098\u008e\u00f6\u0092Jz$\u00ffK\u00dc\u0017\u001d\u0007\u008fA\u0005";
                    var4_3 = "\u0091\u00ea||\u00e4\u0003\u00b0d\u00ec\u0005\u00ac\u001e\u00fd&7\r$\u009c\u00da<&\u008b\u008b\u00cc|Un\u0016F\u0010\u001a\u000e\u00da\u0085\u0019)G\u00a5,\u00fc\u0087n\u009d}\u008a=\u0005\u00a7\u00b4\u009cs\u001b3\u008d\u00df\u00c8i\u008e\u00f0\u0085\u008a\t\u00e4\u00a8D\u00bei\u00c2\u00a0hO\u0086\u00deG\u00b3\u009b\u0093U\u00f4D\u00b6#\u00ebk\u00f5$q\u009b\u0098\u008e\u00f6\u0092Jz$\u00ffK\u00dc\u0017\u001d\u0007\u008fA\u0005".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 106;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "1\u00a6^qhV\u0088\u00ab4\u00dce\u008b  \u00dcwL/\u00baj8\u00c4\u00b7s\u00f9\u00c2\u0005\u0017\t`\u00feG\u00d5<\u00d1\u0012\u001a\\\u00ae3s\u0082\u00e2zS\u00ff\u00ff\u00fe\u00f9g\u00ffc\u00b4BL\u00d0\u009a\u00e5\"\"\u0017\u0093\u00a3\u00deH\u00e4}a\u00b7Lg\u00a0\u001c\u00d7~\u00e2\u00af\u00d1\u00ce\u0007[\fH\u00c7\u00de\u0010\u00ff\u001f%\u00d8\u00f0\u0083\u00a9";
                        var4_3 = "1\u00a6^qhV\u0088\u00ab4\u00dce\u008b  \u00dcwL/\u00baj8\u00c4\u00b7s\u00f9\u00c2\u0005\u0017\t`\u00feG\u00d5<\u00d1\u0012\u001a\\\u00ae3s\u0082\u00e2zS\u00ff\u00ff\u00fe\u00f9g\u00ffc\u00b4BL\u00d0\u009a\u00e5\"\"\u0017\u0093\u00a3\u00deH\u00e4}a\u00b7Lg\u00a0\u001c\u00d7~\u00e2\u00af\u00d1\u00ce\u0007[\fH\u00c7\u00de\u0010\u00ff\u001f%\u00d8\u00f0\u0083\u00a9".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 6;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 123;
                                break;
                            }
                            case 1: {
                                v15 = 53;
                                break;
                            }
                            case 2: {
                                v15 = 46;
                                break;
                            }
                            case 3: {
                                v15 = 69;
                                break;
                            }
                            case 4: {
                                v15 = 52;
                                break;
                            }
                            case 5: {
                                v15 = 5;
                                break;
                            }
                            default: {
                                v15 = 18;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6E14) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 105;
                    case 1 -> 6;
                    case 2 -> 129;
                    case 3 -> 159;
                    case 4 -> 140;
                    case 5 -> 77;
                    case 6 -> 52;
                    case 7 -> 46;
                    case 8 -> 151;
                    case 9 -> 48;
                    case 10 -> 156;
                    case 11 -> 238;
                    case 12 -> 111;
                    case 13 -> 227;
                    case 14 -> 229;
                    case 15 -> 166;
                    case 16 -> 235;
                    case 17 -> 87;
                    case 18 -> 122;
                    case 19 -> 201;
                    case 20 -> 100;
                    case 21 -> 137;
                    case 22 -> 148;
                    case 23 -> 26;
                    case 24 -> 68;
                    case 25 -> 139;
                    case 26 -> 64;
                    case 27 -> 205;
                    case 28 -> 39;
                    case 29 -> 36;
                    case 30 -> 20;
                    case 31 -> 54;
                    case 32 -> 214;
                    case 33 -> 81;
                    case 34 -> 10;
                    case 35 -> 233;
                    case 36 -> 83;
                    case 37 -> 212;
                    case 38 -> 23;
                    case 39 -> 188;
                    case 40 -> 47;
                    case 41 -> 213;
                    case 42 -> 253;
                    case 43 -> 65;
                    case 44 -> 116;
                    case 45 -> 19;
                    case 46 -> 181;
                    case 47 -> 30;
                    case 48 -> 113;
                    case 49 -> 16;
                    case 50 -> 102;
                    case 51 -> 203;
                    case 52 -> 71;
                    case 53 -> 243;
                    case 54 -> 126;
                    case 55 -> 170;
                    case 56 -> 17;
                    case 57 -> 132;
                    case 58 -> 178;
                    case 59 -> 18;
                    case 60 -> 207;
                    case 61 -> 200;
                    case 62 -> 8;
                    case 63 -> 103;
                    case 64 -> 45;
                    case 65 -> 221;
                    case 66 -> 190;
                    case 67 -> 92;
                    case 68 -> 22;
                    case 69 -> 114;
                    case 70 -> 72;
                    case 71 -> 197;
                    case 72 -> 136;
                    case 73 -> 84;
                    case 74 -> 154;
                    case 75 -> 82;
                    case 76 -> 60;
                    case 77 -> 234;
                    case 78 -> 13;
                    case 79 -> 119;
                    case 80 -> 218;
                    case 81 -> 29;
                    case 82 -> 25;
                    case 83 -> 173;
                    case 84 -> 168;
                    case 85 -> 124;
                    case 86 -> 21;
                    case 87 -> 175;
                    case 88 -> 109;
                    case 89 -> 208;
                    case 90 -> 215;
                    case 91 -> 55;
                    case 92 -> 183;
                    case 93 -> 204;
                    case 94 -> 28;
                    case 95 -> 206;
                    case 96 -> 184;
                    case 97 -> 2;
                    case 98 -> 128;
                    case 99 -> 209;
                    case 100 -> 5;
                    case 101 -> 216;
                    case 102 -> 104;
                    case 103 -> 57;
                    case 104 -> 231;
                    case 105 -> 115;
                    case 106 -> 164;
                    case 107 -> 44;
                    case 108 -> 56;
                    case 109 -> 117;
                    case 110 -> 73;
                    case 111 -> 236;
                    case 112 -> 196;
                    case 113 -> 146;
                    case 114 -> 152;
                    case 115 -> 135;
                    case 116 -> 34;
                    case 117 -> 239;
                    case 118 -> 228;
                    case 119 -> 134;
                    case 120 -> 147;
                    case 121 -> 37;
                    case 122 -> 199;
                    case 123 -> 157;
                    case 124 -> 161;
                    case 125 -> 74;
                    case 126 -> 85;
                    case 127 -> 61;
                    case 128 -> 14;
                    case 129 -> 194;
                    case 130 -> 254;
                    case 131 -> 255;
                    case 132 -> 149;
                    case 133 -> 98;
                    case 134 -> 4;
                    case 135 -> 49;
                    case 136 -> 40;
                    case 137 -> 33;
                    case 138 -> 118;
                    case 139 -> 158;
                    case 140 -> 182;
                    case 141 -> 246;
                    case 142 -> 244;
                    case 143 -> 220;
                    case 144 -> 192;
                    case 145 -> 106;
                    case 146 -> 248;
                    case 147 -> 91;
                    case 148 -> 191;
                    case 149 -> 165;
                    case 150 -> 176;
                    case 151 -> 142;
                    case 152 -> 240;
                    case 153 -> 123;
                    case 154 -> 232;
                    case 155 -> 58;
                    case 156 -> 86;
                    case 157 -> 143;
                    case 158 -> 43;
                    case 159 -> 222;
                    case 160 -> 31;
                    case 161 -> 75;
                    case 162 -> 90;
                    case 163 -> 63;
                    case 164 -> 247;
                    case 165 -> 125;
                    case 166 -> 177;
                    case 167 -> 12;
                    case 168 -> 59;
                    case 169 -> 108;
                    case 170 -> 174;
                    case 171 -> 51;
                    case 172 -> 66;
                    case 173 -> 41;
                    case 174 -> 11;
                    case 175 -> 179;
                    case 176 -> 101;
                    case 177 -> 155;
                    case 178 -> 230;
                    case 179 -> 195;
                    case 180 -> 187;
                    case 181 -> 50;
                    case 182 -> 249;
                    case 183 -> 121;
                    case 184 -> 67;
                    case 185 -> 131;
                    case 186 -> 224;
                    case 187 -> 120;
                    case 188 -> 145;
                    case 189 -> 27;
                    case 190 -> 150;
                    case 191 -> 76;
                    case 192 -> 69;
                    case 193 -> 245;
                    case 194 -> 202;
                    case 195 -> 79;
                    case 196 -> 15;
                    case 197 -> 162;
                    case 198 -> 217;
                    case 199 -> 189;
                    case 200 -> 186;
                    case 201 -> 3;
                    case 202 -> 7;
                    case 203 -> 198;
                    case 204 -> 237;
                    case 205 -> 160;
                    case 206 -> 53;
                    case 207 -> 180;
                    case 208 -> 35;
                    case 209 -> 32;
                    case 210 -> 138;
                    case 211 -> 250;
                    case 212 -> 141;
                    case 213 -> 88;
                    case 214 -> 251;
                    case 215 -> 252;
                    case 216 -> 193;
                    case 217 -> 96;
                    case 218 -> 133;
                    case 219 -> 127;
                    case 220 -> 24;
                    case 221 -> 112;
                    case 222 -> 94;
                    case 223 -> 242;
                    case 224 -> 78;
                    case 225 -> 80;
                    case 226 -> 93;
                    case 227 -> 219;
                    case 228 -> 97;
                    case 229 -> 210;
                    case 230 -> 89;
                    case 231 -> 226;
                    case 232 -> 185;
                    case 233 -> 225;
                    case 234 -> 0;
                    case 235 -> 211;
                    case 236 -> 99;
                    case 237 -> 42;
                    case 238 -> 62;
                    case 239 -> 130;
                    case 240 -> 9;
                    case 241 -> 107;
                    case 242 -> 70;
                    case 243 -> 153;
                    case 244 -> 95;
                    case 245 -> 171;
                    case 246 -> 163;
                    case 247 -> 1;
                    case 248 -> 144;
                    case 249 -> 110;
                    case 250 -> 167;
                    case 251 -> 241;
                    case 252 -> 169;
                    case 253 -> 172;
                    case 254 -> 38;
                    default -> 223;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 7950127180482L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-142735230 - -18099, 142735230 - 21076, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 82946121686438L;
                    int n3 = SshAgentIpcService.x();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1713215970 + -((char)-21042), -1713215970 + -30282, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 107717105186459L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "=\u0085S\u00ff\u0084\u0003\u00db\u00c3\u00d9";
                var4_3 = "=\u0085S\u00ff\u0084\u0003\u00db\u00c3\u00d9".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 48;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 4;
                                break;
                            }
                            case 1: {
                                v11 = 93;
                                break;
                            }
                            case 2: {
                                v11 = 106;
                                break;
                            }
                            case 3: {
                                v11 = 55;
                                break;
                            }
                            case 4: {
                                v11 = 40;
                                break;
                            }
                            case 5: {
                                v11 = 72;
                                break;
                            }
                            default: {
                                v11 = 111;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE5F7) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 203;
                    case 1 -> 45;
                    case 2 -> 119;
                    case 3 -> 101;
                    case 4 -> 193;
                    case 5 -> 199;
                    case 6 -> 112;
                    case 7 -> 245;
                    case 8 -> 14;
                    case 9 -> 128;
                    case 10 -> 242;
                    case 11 -> 196;
                    case 12 -> 236;
                    case 13 -> 113;
                    case 14 -> 251;
                    case 15 -> 71;
                    case 16 -> 225;
                    case 17 -> 221;
                    case 18 -> 246;
                    case 19 -> 180;
                    case 20 -> 22;
                    case 21 -> 215;
                    case 22 -> 237;
                    case 23 -> 166;
                    case 24 -> 39;
                    case 25 -> 226;
                    case 26 -> 121;
                    case 27 -> 120;
                    case 28 -> 209;
                    case 29 -> 48;
                    case 30 -> 33;
                    case 31 -> 28;
                    case 32 -> 66;
                    case 33 -> 139;
                    case 34 -> 170;
                    case 35 -> 55;
                    case 36 -> 204;
                    case 37 -> 12;
                    case 38 -> 148;
                    case 39 -> 95;
                    case 40 -> 103;
                    case 41 -> 192;
                    case 42 -> 190;
                    case 43 -> 44;
                    case 44 -> 172;
                    case 45 -> 79;
                    case 46 -> 123;
                    case 47 -> 181;
                    case 48 -> 183;
                    case 49 -> 64;
                    case 50 -> 86;
                    case 51 -> 143;
                    case 52 -> 156;
                    case 53 -> 126;
                    case 54 -> 206;
                    case 55 -> 230;
                    case 56 -> 198;
                    case 57 -> 6;
                    case 58 -> 229;
                    case 59 -> 142;
                    case 60 -> 26;
                    case 61 -> 16;
                    case 62 -> 9;
                    case 63 -> 98;
                    case 64 -> 87;
                    case 65 -> 99;
                    case 66 -> 212;
                    case 67 -> 144;
                    case 68 -> 255;
                    case 69 -> 82;
                    case 70 -> 146;
                    case 71 -> 29;
                    case 72 -> 222;
                    case 73 -> 179;
                    case 74 -> 84;
                    case 75 -> 160;
                    case 76 -> 75;
                    case 77 -> 173;
                    case 78 -> 1;
                    case 79 -> 134;
                    case 80 -> 235;
                    case 81 -> 20;
                    case 82 -> 59;
                    case 83 -> 153;
                    case 84 -> 3;
                    case 85 -> 70;
                    case 86 -> 136;
                    case 87 -> 62;
                    case 88 -> 165;
                    case 89 -> 244;
                    case 90 -> 97;
                    case 91 -> 135;
                    case 92 -> 220;
                    case 93 -> 109;
                    case 94 -> 130;
                    case 95 -> 233;
                    case 96 -> 254;
                    case 97 -> 253;
                    case 98 -> 201;
                    case 99 -> 210;
                    case 100 -> 11;
                    case 101 -> 138;
                    case 102 -> 195;
                    case 103 -> 106;
                    case 104 -> 164;
                    case 105 -> 248;
                    case 106 -> 92;
                    case 107 -> 247;
                    case 108 -> 187;
                    case 109 -> 162;
                    case 110 -> 111;
                    case 111 -> 21;
                    case 112 -> 252;
                    case 113 -> 197;
                    case 114 -> 133;
                    case 115 -> 74;
                    case 116 -> 88;
                    case 117 -> 27;
                    case 118 -> 107;
                    case 119 -> 93;
                    case 120 -> 228;
                    case 121 -> 17;
                    case 122 -> 152;
                    case 123 -> 168;
                    case 124 -> 31;
                    case 125 -> 42;
                    case 126 -> 151;
                    case 127 -> 241;
                    case 128 -> 122;
                    case 129 -> 211;
                    case 130 -> 57;
                    case 131 -> 41;
                    case 132 -> 157;
                    case 133 -> 239;
                    case 134 -> 249;
                    case 135 -> 167;
                    case 136 -> 191;
                    case 137 -> 115;
                    case 138 -> 51;
                    case 139 -> 213;
                    case 140 -> 35;
                    case 141 -> 46;
                    case 142 -> 5;
                    case 143 -> 161;
                    case 144 -> 53;
                    case 145 -> 227;
                    case 146 -> 68;
                    case 147 -> 61;
                    case 148 -> 116;
                    case 149 -> 23;
                    case 150 -> 137;
                    case 151 -> 218;
                    case 152 -> 30;
                    case 153 -> 72;
                    case 154 -> 216;
                    case 155 -> 217;
                    case 156 -> 108;
                    case 157 -> 174;
                    case 158 -> 38;
                    case 159 -> 118;
                    case 160 -> 189;
                    case 161 -> 223;
                    case 162 -> 37;
                    case 163 -> 18;
                    case 164 -> 50;
                    case 165 -> 205;
                    case 166 -> 158;
                    case 167 -> 154;
                    case 168 -> 47;
                    case 169 -> 208;
                    case 170 -> 238;
                    case 171 -> 13;
                    case 172 -> 36;
                    case 173 -> 207;
                    case 174 -> 89;
                    case 175 -> 43;
                    case 176 -> 0;
                    case 177 -> 224;
                    case 178 -> 24;
                    case 179 -> 232;
                    case 180 -> 10;
                    case 181 -> 83;
                    case 182 -> 15;
                    case 183 -> 124;
                    case 184 -> 185;
                    case 185 -> 91;
                    case 186 -> 150;
                    case 187 -> 4;
                    case 188 -> 131;
                    case 189 -> 54;
                    case 190 -> 49;
                    case 191 -> 145;
                    case 192 -> 8;
                    case 193 -> 76;
                    case 194 -> 163;
                    case 195 -> 155;
                    case 196 -> 125;
                    case 197 -> 63;
                    case 198 -> 81;
                    case 199 -> 184;
                    case 200 -> 129;
                    case 201 -> 141;
                    case 202 -> 2;
                    case 203 -> 78;
                    case 204 -> 127;
                    case 205 -> 32;
                    case 206 -> 105;
                    case 207 -> 96;
                    case 208 -> 69;
                    case 209 -> 77;
                    case 210 -> 240;
                    case 211 -> 117;
                    case 212 -> 40;
                    case 213 -> 202;
                    case 214 -> 243;
                    case 215 -> 52;
                    case 216 -> 194;
                    case 217 -> 19;
                    case 218 -> 25;
                    case 219 -> 188;
                    case 220 -> 110;
                    case 221 -> 94;
                    case 222 -> 114;
                    case 223 -> 175;
                    case 224 -> 34;
                    case 225 -> 90;
                    case 226 -> 7;
                    case 227 -> 102;
                    case 228 -> 147;
                    case 229 -> 176;
                    case 230 -> 159;
                    case 231 -> 56;
                    case 232 -> 177;
                    case 233 -> 58;
                    case 234 -> 60;
                    case 235 -> 80;
                    case 236 -> 73;
                    case 237 -> 231;
                    case 238 -> 140;
                    case 239 -> 214;
                    case 240 -> 104;
                    case 241 -> 182;
                    case 242 -> 169;
                    case 243 -> 186;
                    case 244 -> 178;
                    case 245 -> 171;
                    case 246 -> 65;
                    case 247 -> 250;
                    case 248 -> 67;
                    case 249 -> 100;
                    case 250 -> 132;
                    case 251 -> 219;
                    case 252 -> 85;
                    case 253 -> 149;
                    case 254 -> 200;
                    default -> 234;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

