/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptBundle;

public class CucumberPackage {
    @Nullable
    public final String libPath;
    @Nullable
    public final SemVer version;

    public CucumberPackage(@Nullable String libPath, @Nullable SemVer version) {
        this.libPath = libPath;
        this.version = version;
    }

    @NotNull
    public static CucumberPackage fromNodePackage(@NotNull NodePackage pkg) throws ExecutionException {
        VirtualFile cli;
        String path;
        if (pkg == null) {
            CucumberPackage.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(path = pkg.getSystemIndependentPath()))) {
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.specify.non.empty.path.to.cucumber.package", new Object[0]));
        }
        VirtualFile packageDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (packageDir == null || !packageDir.isValid() || !packageDir.isDirectory()) {
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.specify.valid.path.to.cucumber.package", new Object[0]));
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)packageDir);
        if (packageJson == null) {
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.specify.cucumber.package.correctly.package.json.file.found", new Object[0]));
        }
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate((VirtualFile)packageJson);
        SemVer version = packageJsonData.getVersion();
        String binPath = packageJsonData.getBinPath("cucumber-js");
        VirtualFile virtualFile = cli = binPath != null ? packageDir.findFileByRelativePath(binPath) : null;
        if (cli == null || !cli.isValid() || cli.isDirectory()) {
            if (!StringUtil.isEmpty((String)binPath)) {
                throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.specify.cucumber.package.correctly.file.found", binPath));
            }
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.specify.cucumber.package.correctly.executable.bin.file.not.found", new Object[0]));
        }
        VirtualFile lib = packageDir.findFileByRelativePath("lib");
        return new CucumberPackage(lib != null ? lib.getPath() : null, version);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "org/jetbrains/plugins/cucumber/javascript/run/CucumberPackage", "fromNodePackage"));
    }
}

