/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ultimate.PluginVerifier;
import com.jetbrains.php.framework.data.FrameworkApplicationDataService;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataServiceBase;
import com.jetbrains.php.framework.data.FrameworkProjectDataService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

@Service(value={Service.Level.PROJECT})
public final class FrameworkDataService {
    @NonNls
    public static final String SCHEMA_DIRECTORY = "schemas";
    @NonNls
    public static final String SCHEMA_FILENAME = "frameworkDescriptionVersion1.1.4.xsd";
    private final FrameworkProjectDataService myProjectService;
    private final NotNullLazyValue<FrameworkApplicationDataService> myApplicationService;

    public static FrameworkDataService getInstance(Project project) {
        return (FrameworkDataService)project.getService(FrameworkDataService.class);
    }

    public FrameworkDataService(Project project) {
        PluginVerifier.verifyUltimatePlugin();
        this.myProjectService = new FrameworkProjectDataService(project);
        this.myApplicationService = NotNullLazyValue.lazy(() -> FrameworkApplicationDataService.getInstance());
    }

    public List<FrameworkFileData> cloneData() {
        ArrayList<FrameworkFileData> result = new ArrayList<FrameworkFileData>();
        result.addAll(this.myProjectService.cloneData());
        result.addAll(((FrameworkApplicationDataService)this.myApplicationService.get()).cloneData());
        return result;
    }

    public void loadChanged(List<FrameworkFileData> items) {
        ArrayList<FrameworkFileData> projectLevelData = new ArrayList<FrameworkFileData>();
        ArrayList<FrameworkFileData> appLevelData = new ArrayList<FrameworkFileData>();
        for (FrameworkFileData item : items) {
            if (item.isProjectVisibility()) {
                projectLevelData.add(item);
                continue;
            }
            appLevelData.add(item);
        }
        this.myProjectService.loadChanged(projectLevelData);
        ((FrameworkApplicationDataService)this.myApplicationService.get()).loadChanged(appLevelData);
    }

    @NonNls
    public static String getFileName(String name) {
        return FileUtil.sanitizeFileName((String)name) + ".xml";
    }

    @NonNls
    public static String getFrameworkNameFromFileName(String name) {
        if (name.endsWith(".xml")) {
            return name.substring(0, name.length() - ".xml".length());
        }
        return name;
    }

    public List<FrameworkCommand> getCommands() {
        ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>();
        commands.addAll(this.myProjectService.getCommands());
        commands.addAll(((FrameworkApplicationDataService)this.myApplicationService.get()).getCommands());
        return commands;
    }

    public Map<String, String> getAliasesAndInvokeTexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(((FrameworkApplicationDataService)this.myApplicationService.get()).getAliasesAndInvokeTexts());
        result.putAll(this.myProjectService.getAliasesAndInvokeTexts());
        return result;
    }

    public Map<String, String> getAliasesAndNames() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(((FrameworkApplicationDataService)this.myApplicationService.get()).getAliasesAndNames());
        result.putAll(this.myProjectService.getAliasesAndNames());
        return result;
    }

    @NotNull
    public static FrameworkConfigurationDescription readFromElement(@NotNull Element element, String filename) throws SAXException {
        if (element == null) {
            FrameworkDataService.$$$reportNull$$$0(0);
        }
        FrameworkConfigurationDescription frameworkConfigurationDescription = FrameworkDataServiceBase.readFromDocument(element, filename);
        if (frameworkConfigurationDescription == null) {
            FrameworkDataService.$$$reportNull$$$0(1);
        }
        return frameworkConfigurationDescription;
    }

    @Nullable
    public VirtualFile getFile(FrameworkFileData data) {
        VirtualFile dir = data.isProjectVisibility() ? this.myProjectService.getDescriptionsDir(false) : ((FrameworkApplicationDataService)this.myApplicationService.get()).getDescriptionsDir(false);
        if (dir == null) {
            return null;
        }
        return dir.findChild(data.getFileName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/data/FrameworkDataService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/data/FrameworkDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class FrameworkFileData {
        private final FrameworkConfigurationDescription myFramework;
        private final String myErrorMessage;
        private final String myFileName;
        private boolean myProjectVisibility;

        public FrameworkFileData(FrameworkConfigurationDescription framework, String errorMessage, String fileName, boolean projectVisibility) {
            this.myFramework = framework;
            this.myErrorMessage = errorMessage;
            this.myFileName = fileName;
            this.myProjectVisibility = projectVisibility;
        }

        public FrameworkConfigurationDescription getFramework() {
            return this.myFramework;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public String getFileName() {
            return this.myFileName;
        }

        public boolean isProjectVisibility() {
            return this.myProjectVisibility;
        }

        public void setProjectVisibility(boolean projectVisibility) {
            this.myProjectVisibility = projectVisibility;
        }
    }
}

