/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.symfony;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyVersion;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import com.jetbrains.php.framework.ui.FrameworkPathDialog;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SymfonyUtils {
    private static final Logger LOG = Logger.getInstance(SymfonyUtils.class);

    private SymfonyUtils() {
    }

    static List<FrameworkCommand> getFrameworkCommands(SymfonyDescriptionProvider.VersionedData symfonyData, @Nullable Project project, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        File tmpProjectFile;
        if (pi == null) {
            SymfonyUtils.$$$reportNull$$$0(0);
        }
        FrameworkDescription symfonyFramework = SymfonyUtils.getSymfonyFrameworkDescription(symfonyData);
        SymfonyVersion version = symfonyData.getVersion();
        if (version == null) {
            version = SymfonyUtils.getVersion(symfonyData.getData(), null, project);
        }
        if (version.isSuitableForComponent()) {
            return version.getCommands(symfonyData.getData().createCommand(new String[0]), project, symfonyFramework, pi);
        }
        FrameworkUtils.checkProgress(pi);
        try {
            tmpProjectFile = FileUtilRt.createTempDirectory((String)"symfony", (String)"tmp");
            tmpProjectFile.deleteOnExit();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.failed.to.create.temp.dir.0", e.getMessage()));
        }
        FrameworkUtils.checkProgress(pi);
        String tmpPath = tmpProjectFile.getPath();
        FrameworkUtils.executeCommandWithFullOutput(version.getCommandToCreateProject(symfonyData.getData()), tmpPath, project, false, false);
        FrameworkUtils.checkProgress(pi);
        return version.getCommands(symfonyData.getData(), tmpPath, project, symfonyFramework);
    }

    @NonNls
    @NotNull
    static FrameworkDescription getSymfonyFrameworkDescription(SymfonyDescriptionProvider.VersionedData symfonyData) {
        FrameworkDescription frameworkDescription = SymfonyComponentUtils.getFrameworkDescription(symfonyData.getData(), "s", SymfonyDescriptionProvider.getFrameworkNameText(), "com.symfony", symfonyData.getVersion());
        if (frameworkDescription == null) {
            SymfonyUtils.$$$reportNull$$$0(1);
        }
        return frameworkDescription;
    }

    private static SymfonyVersion getVersion(FrameworkPathDialog.Data symfonyData, String workingFolder, @Nullable Project project) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        ScriptRunnerUtil.ScriptOutput versionOutput;
        String[] command = symfonyData.createCommand("-V");
        try {
            versionOutput = FrameworkUtils.executeCommandWithFullOutput(command, workingFolder, project, true, true);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.failed.to.execute.0.1.v", symfonyData.getPhpPath(false), symfonyData.getPath(false)));
        }
        return SymfonyVersion.getVersion(command, versionOutput);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/generators/symfony/SymfonyUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymfonyFrameworkDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkCommands";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

