/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.symfony;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.symfonycomponent.ComponentData;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import com.jetbrains.php.framework.ui.FrameworkPathDialog;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SymfonyVersion {
    VERSION_1_1_OR_1_2(FrameworkBundle.message("symfony.component.version.1.1-2", new Object[0]), "1.1-2"){
        @NonNls
        private static final String ALIASES = "Aliases: ";

        /*
         * WARNING - void declaration
         */
        @Override
        public List<FrameworkCommand> getCommands(FrameworkPathDialog.Data symfonyData, String projectFolder, @Nullable Project project, @NotNull FrameworkDescription symfonyFramework) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            void var11_13;
            if (symfonyFramework == null) {
                1.$$$reportNull$$$0(0);
            }
            @NonNls String[] listCommand = symfonyData.createCommand("list");
            ScriptRunnerUtil.ScriptOutput listCommandOutput = FrameworkUtils.executeCommandWithFullOutput(listCommand, projectFolder, project, true, false);
            ArrayList<CallSite> commandNames = new ArrayList<CallSite>();
            String currentPrefix = "";
            String[] stringArray = listCommandOutput.getOutputToParseArray();
            int n = stringArray.length;
            boolean bl = false;
            while (var11_13 < n) {
                String s = stringArray[var11_13];
                if (!s.startsWith(" ")) {
                    currentPrefix = s;
                } else if (s.startsWith("  :")) {
                    if (!StringUtil.isEmpty((String)currentPrefix) && Character.isUpperCase(currentPrefix.charAt(0))) {
                        currentPrefix = "";
                    }
                    int colonIndex = s.indexOf(":");
                    String text = s.substring(colonIndex, s.indexOf(" ", colonIndex));
                    commandNames.add((CallSite)((Object)(currentPrefix + text)));
                }
                ++var11_13;
            }
            if (commandNames.isEmpty()) {
                throw new FrameworkDescriptionProvider.FrameworkParseException(listCommand, listCommandOutput.getDescriptiveOutput(), FrameworkBundle.message("framework.symfony.found.no.task.name", new Object[0]));
            }
            ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>();
            for (String string : commandNames) {
                String[] partialOutputArray;
                String string2 = string.startsWith(":") ? string.substring(1) : string;
                String[] command = symfonyData.createCommand("help", string2);
                ScriptRunnerUtil.ScriptOutput helpOutput = FrameworkUtils.executeCommandWithFullOutput(command, projectFolder, project, true, false);
                StringBuilder sb = new StringBuilder();
                for (String s : partialOutputArray = helpOutput.getOutputToParseArray()) {
                    sb.append(s).append("<br/>");
                }
                String help = FrameworkDescription.normalizeHelp(sb.toString());
                ArrayList<FrameworkCommand.Parameter> parameters = new ArrayList<FrameworkCommand.Parameter>();
                ArrayList<String> aliases = new ArrayList<String>();
                aliases.add(string2);
                boolean parse = false;
                boolean isUsage = false;
                String usageString = null;
                for (String s : partialOutputArray) {
                    if (s.startsWith("Arguments:")) {
                        parse = true;
                        continue;
                    }
                    if (s.startsWith("Usage:")) {
                        isUsage = true;
                        continue;
                    }
                    if (isUsage) {
                        usageString = s;
                        isUsage = false;
                        continue;
                    }
                    if (parse && s.isEmpty()) break;
                    if (parse) {
                        String name = s.substring(1, s.indexOf(32, 1));
                        String defaultValue = null;
                        if (usageString == null) {
                            throw new FrameworkDescriptionProvider.FrameworkParseException(command, helpOutput.getDescriptiveOutput(), FrameworkBundle.message("framework.symfony.found.no.usage.text", new Object[0]));
                        }
                        if (usageString.contains(" [" + name + "]")) {
                            defaultValue = "null";
                        }
                        parameters.add(new FrameworkCommand.Parameter(name, defaultValue));
                    }
                    if (!s.startsWith(ALIASES)) continue;
                    aliases.addAll(Arrays.asList(s.substring(ALIASES.length()).split(", ")));
                }
                for (String alias : aliases) {
                    commands.add(new FrameworkCommand(alias, parameters, help, symfonyFramework));
                }
            }
            return commands;
        }

        @Override
        public boolean isSuitableForComponent() {
            return false;
        }

        @Override
        public List<FrameworkCommand> getCommands(String[] path, @Nullable Project project, @NotNull FrameworkDescription frameworkDescription, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            if (frameworkDescription == null) {
                1.$$$reportNull$$$0(1);
            }
            if (pi == null) {
                1.$$$reportNull$$$0(2);
            }
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symfonyFramework";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frameworkDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pi";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyVersion$1";
            objectArray[2] = "getCommands";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    VERSION_1_3_OR_1_4(FrameworkBundle.message("symfony.component.version.1.3-4", new Object[0]), "1.3-4"){

        @Override
        public List<FrameworkCommand> getCommands(FrameworkPathDialog.Data symfonyData, String projectFolder, @Nullable Project project, @NotNull FrameworkDescription symfonyFramework) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            if (symfonyFramework == null) {
                2.$$$reportNull$$$0(0);
            }
            return SymfonyVersion.getCommandsFromXml(symfonyData, projectFolder, project, symfonyFramework, "tasks", "task");
        }

        @Override
        public boolean isSuitableForComponent() {
            return false;
        }

        @Override
        public List<FrameworkCommand> getCommands(String[] path, @Nullable Project project, @NotNull FrameworkDescription frameworkDescription, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            if (frameworkDescription == null) {
                2.$$$reportNull$$$0(1);
            }
            if (pi == null) {
                2.$$$reportNull$$$0(2);
            }
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symfonyFramework";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frameworkDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pi";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyVersion$2";
            objectArray[2] = "getCommands";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    VERSION_2_0(FrameworkBundle.message("symfony.component.version.2", new Object[0]), "2"){

        @Override
        public String[] getCommandToCreateProject(FrameworkPathDialog.Data symfonyData) {
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        @Override
        public String getHelp(FrameworkPathDialog.Data symfonyData, @Nullable Project project, @Nullable String workingDirectory) throws ExecutionException {
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        @Override
        public List<FrameworkCommand> getCommands(FrameworkPathDialog.Data symfonyData, String projectFolder, @Nullable Project project, FrameworkDescription symfonyFramework) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        @Override
        public boolean isSuitableForComponent() {
            return true;
        }

        @Override
        public List<FrameworkCommand> getCommands(String[] path, @Nullable Project project, @NotNull FrameworkDescription frameworkDescription, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            if (frameworkDescription == null) {
                3.$$$reportNull$$$0(0);
            }
            if (pi == null) {
                3.$$$reportNull$$$0(1);
            }
            String[] command = ComponentData.createCommand(path, "list", "--xml");
            return SymfonyComponentUtils.getFrameworkCommandsVersion2(command, project, pi, frameworkDescription);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frameworkDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pi";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyVersion$3";
            objectArray[2] = "getCommands";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    VERSION_3(FrameworkBundle.message("symfony.component.version.3", new Object[0]), "3"){

        @Override
        public String[] getCommandToCreateProject(FrameworkPathDialog.Data symfonyData) {
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        @Override
        public String getHelp(FrameworkPathDialog.Data symfonyData, @Nullable Project project, @Nullable String workingDirectory) throws ExecutionException {
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        @Override
        public List<FrameworkCommand> getCommands(FrameworkPathDialog.Data symfonyData, String projectFolder, @Nullable Project project, FrameworkDescription symfonyFramework) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            throw new IllegalStateException("This method is not intended to be invoked");
        }

        @Override
        public boolean isSuitableForComponent() {
            return true;
        }

        @Override
        public List<FrameworkCommand> getCommands(String[] path, @Nullable Project project, @NotNull FrameworkDescription frameworkDescription, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
            if (frameworkDescription == null) {
                4.$$$reportNull$$$0(0);
            }
            if (pi == null) {
                4.$$$reportNull$$$0(1);
            }
            String[] command = ComponentData.createCommand(path, "list", "--format=xml");
            return SymfonyComponentUtils.getFrameworkCommandsVersion2(command, project, pi, frameworkDescription);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frameworkDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pi";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyVersion$4";
            objectArray[2] = "getCommands";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private static final Logger LOG;
    @Nls
    private final String myPresentableText;
    private final String myId;

    private SymfonyVersion(String presentableText, String id) {
        this.myPresentableText = presentableText;
        this.myId = id;
    }

    private static List<FrameworkCommand> getCommandsFromXml(FrameworkPathDialog.Data symfonyData, String projectFolder, @Nullable Project project, @NotNull FrameworkDescription symfonyFramework, @NonNls String tasksElementName, @NonNls String taskElementName) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        Element document;
        if (symfonyFramework == null) {
            SymfonyVersion.$$$reportNull$$$0(0);
        }
        String[] command = symfonyData.createCommand("--xml", "list");
        ScriptRunnerUtil.ScriptOutput listCommandsOutput = FrameworkUtils.executeCommandWithFullOutput(command, projectFolder, project, true, false);
        try {
            document = JDOMUtil.load((CharSequence)listCommandsOutput.getFilteredOutput());
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.failed.to.parse.output", symfonyData.getPhpPath(false), symfonyData.getPath(false), e.getMessage()));
        }
        catch (JDOMException e) {
            LOG.warn((Throwable)e);
            throw new FrameworkDescriptionProvider.FrameworkParseException(command, listCommandsOutput.getDescriptiveOutput(), FrameworkBundle.message("framework.symfony.failed.to.parse.output.as.xml", e.getMessage()));
        }
        List tasks = document.getChild(tasksElementName).getChildren(taskElementName);
        ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>(tasks.size());
        for (Element task : tasks) {
            List parameterElements = task.getChild("arguments").getChildren("argument");
            ArrayList<FrameworkCommand.Parameter> parameters = new ArrayList<FrameworkCommand.Parameter>(parameterElements.size());
            for (Element parameterElement : parameterElements) {
                String name = parameterElement.getAttributeValue("name");
                boolean hasDefaultValue = "0".equals(parameterElement.getAttributeValue("is_required"));
                parameters.add(new FrameworkCommand.Parameter(name, hasDefaultValue ? "null" : null));
            }
            String help = task.getChild("help").getText();
            help = StringUtil.convertLineSeparators((String)help, (String)"<br/>");
            commands.add(new FrameworkCommand(task.getAttributeValue("id"), parameters, help, symfonyFramework));
            List aliasElements = task.getChild("aliases").getChildren("alias");
            if (aliasElements.isEmpty()) continue;
            for (Element aliasElement : aliasElements) {
                commands.add(new FrameworkCommand(aliasElement.getText(), parameters, help, symfonyFramework));
            }
        }
        return commands;
    }

    @NotNull
    public static SymfonyVersion getVersion(String[] command, ScriptRunnerUtil.ScriptOutput versionOutput) throws FrameworkDescriptionProvider.FrameworkParseException, ExecutionException {
        String versionDescription = versionOutput.getFilteredOutput();
        if (StringUtil.isEmpty((String)versionDescription)) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(command, versionOutput.getDescriptiveOutput(), FrameworkBundle.message("framework.symfony.failed.to.determine.version", new Object[0]));
        }
        if (versionDescription.contains("symfony version 1.0.")) {
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.symfony.v.1.0.is.not.supported.you.may.enable.it.via.custom.framework.description", new Object[0]));
        }
        if (versionDescription.contains("symfony version 1.1.") || versionDescription.contains("symfony version 1.2.")) {
            SymfonyVersion symfonyVersion = VERSION_1_1_OR_1_2;
            if (symfonyVersion == null) {
                SymfonyVersion.$$$reportNull$$$0(1);
            }
            return symfonyVersion;
        }
        if (versionDescription.contains("symfony version 1.3.") || versionDescription.contains("symfony version 1.4.")) {
            SymfonyVersion symfonyVersion = VERSION_1_3_OR_1_4;
            if (symfonyVersion == null) {
                SymfonyVersion.$$$reportNull$$$0(2);
            }
            return symfonyVersion;
        }
        if (versionDescription.contains("Symfony version 2.")) {
            SymfonyVersion symfonyVersion = VERSION_2_0;
            if (symfonyVersion == null) {
                SymfonyVersion.$$$reportNull$$$0(3);
            }
            return symfonyVersion;
        }
        if (versionDescription.contains("Symfony version 3.")) {
            SymfonyVersion symfonyVersion = VERSION_3;
            if (symfonyVersion == null) {
                SymfonyVersion.$$$reportNull$$$0(4);
            }
            return symfonyVersion;
        }
        throw new FrameworkDescriptionProvider.FrameworkParseException(command, versionDescription, FrameworkBundle.message("framework.symfony.failed.to.determine.version", new Object[0]));
    }

    public String[] getCommandToCreateProject(FrameworkPathDialog.Data symfonyData) {
        return symfonyData.createCommand("generate:project", "tmp");
    }

    @Nullable
    public String getHelp(FrameworkPathDialog.Data symfonyData, @Nullable Project project, String workingDirectory) throws ExecutionException {
        String[] helpStrings = FrameworkUtils.executeCommandWithFullOutput(symfonyData.createCommand(new String[0]), workingDirectory, project, true, false).getOutputToParseArray();
        StringBuilder sb = new StringBuilder();
        for (String helpString : helpStrings) {
            sb.append(helpString).append("<br/>");
        }
        return FrameworkDescription.normalizeHelp(sb.toString());
    }

    public abstract List<FrameworkCommand> getCommands(FrameworkPathDialog.Data var1, String var2, @Nullable Project var3, FrameworkDescription var4) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException;

    public abstract boolean isSuitableForComponent();

    public abstract List<FrameworkCommand> getCommands(String[] var1, @Nullable Project var2, @NotNull FrameworkDescription var3, @NotNull ProgressIndicator var4) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException;

    @Nls
    public String getPresentableText() {
        return this.myPresentableText;
    }

    public String getId() {
        return this.myId;
    }

    static {
        LOG = Logger.getInstance(SymfonyVersion.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symfonyFramework";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/generators/symfony/SymfonyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/generators/symfony/SymfonyVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommandsFromXml";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

