/*
 * Decompiled with CFR 0.152.
 */
package com.laravel_idea.plugin.extension.terminal;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.run.script.PhpScriptRunConfiguration;
import com.jetbrains.php.run.script.PhpScriptRuntimeConfigurationProducer;
import com.laravel_idea.plugin.common.threading.ThreadingKt;
import com.laravel_idea.plugin.extension.notifications.HelpersKt;
import com.laravel_idea.plugin.extension.notifications.NotificationAction;
import com.laravel_idea.plugin.extension.settings.LaravelIdeaSettings;
import com.laravel_idea.plugin.extension.terminal.SeedProcessListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/laravel_idea/plugin/extension/terminal/RunSeedWithInterpreterAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "phpClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "<init>", "(Lcom/jetbrains/php/lang/psi/elements/PhpClass;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "laravel-idea"})
public final class RunSeedWithInterpreterAction
extends AnAction {
    @NotNull
    private final PhpClass phpClass;

    public RunSeedWithInterpreterAction(@NotNull PhpClass phpClass) {
        Intrinsics.checkNotNullParameter((Object)phpClass, (String)"phpClass");
        this.phpClass = phpClass;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        e2.getPresentation().setIcon(AllIcons.RunConfigurations.TestState.Run);
        e2.getPresentation().setEnabledAndVisible(true);
        e2.getPresentation().setText("Run " + this.phpClass.getName() + " with PHP Interpreter");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = this.phpClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PhpScriptRunConfiguration phpScriptRunConfiguration = new PhpScriptRunConfiguration(project2, new PhpScriptRuntimeConfigurationProducer().getConfigurationFactory(), "Laravel Idea");
        PhpInterpreter phpInterpreter = PhpProjectConfigurationFacade.getInstance((Project)project2).getInterpreter();
        if (phpInterpreter == null) {
            HelpersKt.showNotificationWarning(project2, "Laravel Idea", "No PHP Interpreter", CollectionsKt.listOf((Object)((Object)new NotificationAction("Setup PHP Interpreter", (Function0<Unit>)((Function0)() -> RunSeedWithInterpreterAction.actionPerformed$lambda$0(project2))))));
            return;
        }
        VirtualFile virtualFile = LaravelIdeaSettings.Companion.getInstance(project2).getProjectFile("");
        String string2 = string = virtualFile != null ? virtualFile.getPath() : null;
        if (string == null) {
            HelpersKt.showNotificationWarning$default(project2, "Seeding failed", "No root directory", null, 8, null);
            return;
        }
        ProcessHandler processHandler = null;
        try {
            PhpCommandSettings phpCommandSettings = new PhpCommandSettingsBuilder(project2, phpInterpreter).loadAndStartDebug().build();
            Intrinsics.checkNotNullExpressionValue((Object)phpCommandSettings, (String)"build(...)");
            object = phpCommandSettings;
            object.setWorkingDir(string);
            object.importCommandLineSettings(((PhpScriptRunConfiguration.Settings)phpScriptRunConfiguration.getSettings()).getCommandLineSettings(), string);
            Object[] objectArray = new String[]{"artisan", "db:seed", "--class=" + this.phpClass.getPresentableFQN()};
            object.addArguments(CollectionsKt.listOf((Object[])objectArray));
            ProcessHandler processHandler2 = phpScriptRunConfiguration.createProcessHandler(project2, object);
            Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"createProcessHandler(...)");
            processHandler = processHandler2;
            ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project2, (String)"");
        }
        catch (ExecutionException executionException) {
            String string3 = executionException.getMessage();
            if (string3 == null) {
                string3 = "PHP CLI Interpreter error";
            }
            HelpersKt.showNotificationWarning$default(project2, "Running failed", string3, null, 8, null);
            return;
        }
        object = new SeedProcessListener(project2);
        processHandler.addProcessListener((ProcessListener)object);
        ThreadingKt.runInBackground(project2, "Running seeder", (Function0<Unit>)((Function0)() -> RunSeedWithInterpreterAction.actionPerformed$lambda$1(processHandler)));
    }

    private static final Unit actionPerformed$lambda$0(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, PhpProjectConfigurable.class);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1(ProcessHandler $processHandler) {
        $processHandler.startNotify();
        while (!$processHandler.isProcessTerminated()) {
            Thread.sleep(250L);
            try {
                ThreadingKt.checkProcessCancelled();
            }
            catch (ProcessCanceledException processCanceledException) {
                $processHandler.destroyProcess();
                throw processCanceledException;
            }
        }
        return Unit.INSTANCE;
    }
}

