/*
 * Decompiled with CFR 0.152.
 */
package com.laravel_idea.plugin.generation.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.laravel_idea.plugin.common.helpers.DataContextKt;
import com.laravel_idea.plugin.extension.settings.LaravelIdeaSettings;
import com.laravel_idea.plugin.generation.actions.CodeGenerationFetch;
import icons.LaravelIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u001d\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0007H\u0014J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/laravel_idea/plugin/generation/actions/BaseInClassGenerationAction;", "Lcom/intellij/refactoring/actions/BaseRefactoringAction;", "<init>", "()V", "getSettingsFetch", "Lcom/laravel_idea/plugin/generation/actions/CodeGenerationFetch;", "getPhpClassAvailability", "", "phpClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "settings", "Lcom/laravel_idea/plugin/extension/settings/LaravelIdeaSettings;", "isEnabledOnElements", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "isAvailableOnElementInEditorAndFile", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "isAvailableInEditorOnly", "isAvailableForLanguage", "language", "Lcom/intellij/lang/Language;", "getElementAvailability", "laravel-idea"})
public abstract class BaseInClassGenerationAction
extends BaseRefactoringAction {
    public BaseInClassGenerationAction() {
        this.getTemplatePresentation().setIcon(LaravelIcons.laravel);
    }

    @NotNull
    public abstract CodeGenerationFetch getSettingsFetch();

    public abstract boolean getPhpClassAvailability(@NotNull PhpClass var1, @NotNull LaravelIdeaSettings var2);

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return false;
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LaravelIdeaSettings laravelIdeaSettings = LaravelIdeaSettings.Companion.getInstance(project);
        if (laravelIdeaSettings.disabled()) {
            return false;
        }
        if (this.getSettingsFetch().getCodeGenerationSettings(laravelIdeaSettings) == null) {
            return false;
        }
        PsiElement psiElement = DataContextKt.getPsiElement(context);
        if (psiElement == null) {
            return false;
        }
        return this.getElementAvailability(psiElement, laravelIdeaSettings);
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isAvailableForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)PhpLanguage.INSTANCE.getID(), (Object)language.getID());
    }

    private final boolean getElementAvailability(PsiElement element, LaravelIdeaSettings settings) {
        if (element instanceof PhpClass) {
            return this.getPhpClassAvailability((PhpClass)element, settings);
        }
        if (element.getParent() instanceof PhpClass) {
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.PhpClass");
            return this.getPhpClassAvailability((PhpClass)psiElement, settings);
        }
        return false;
    }
}

