/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.wsl.mapping;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.PathMappingType;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.wsl.remoteSdk.WSLPathMappingsProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.remote.wsl.mapping.PhpWslPathHelpers;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpWsl2PathMappingsProvider
extends WSLPathMappingsProvider {
    private static final PathMappingType MAPPING_TYPE = new PathMappingType(AllIcons.Ide.Readonly, PhpBundle.messagePointer((String)"tooltip.wsl2.mappings", (Object[])new Object[0]));

    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            PhpWsl2PathMappingsProvider.$$$reportNull$$$0(0);
        }
        return "WSL2 Path Mappings provider";
    }

    @NotNull
    public PathMappingType getMappingType() {
        PathMappingType pathMappingType = MAPPING_TYPE;
        if (pathMappingType == null) {
            PhpWsl2PathMappingsProvider.$$$reportNull$$$0(1);
        }
        return pathMappingType;
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) {
        PathMappingSettings settings;
        if (project == null) {
            PhpWsl2PathMappingsProvider.$$$reportNull$$$0(2);
        }
        if (data == null) {
            PhpWsl2PathMappingsProvider.$$$reportNull$$$0(3);
        }
        if (!(settings = super.getPathMappingSettings(project, data)).isEmpty()) {
            PathMappingSettings pathMappingSettings = settings;
            if (pathMappingSettings == null) {
                PhpWsl2PathMappingsProvider.$$$reportNull$$$0(4);
            }
            return pathMappingSettings;
        }
        PathMappingSettings wsl2Settings = new PathMappingSettings();
        List localRoots = ContainerUtil.filter(this.getLocalRoots(project), path -> PhpWslPathHelpers.isWsl2Path(path));
        for (String local : localRoots) {
            wsl2Settings.addMapping(local, PhpWslPathHelpers.toRemoteWsl2PathWithoutPrefix(local));
        }
        PathMappingSettings pathMappingSettings = wsl2Settings;
        if (pathMappingSettings == null) {
            PhpWsl2PathMappingsProvider.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    public Set<String> getLocalRoots(@NotNull Project project) {
        if (project == null) {
            PhpWsl2PathMappingsProvider.$$$reportNull$$$0(6);
        }
        HashSet<String> localPathsToMap = new HashSet<String>();
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir != null) {
            localPathsToMap.add(projectBaseDir.getCanonicalPath());
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                localPathsToMap.add(contentRoot.getCanonicalPath());
            }
        }
        return localPathsToMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/wsl/mapping/PhpWsl2PathMappingsProvider";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/wsl/mapping/PhpWsl2PathMappingsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviderPresentableName";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

