/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateStepFixBase;
import org.jetbrains.plugins.cucumber.inspections.CucumberStepDefinitionCreationContext;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberCreateAllStepsFix
extends CucumberCreateStepFixBase {
    @NotNull
    public String getName() {
        String string = CucumberBundle.message("cucumber.create.all.steps.title", new Object[0]);
        if (string == null) {
            CucumberCreateAllStepsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void createStepOrSteps(GherkinStep sourceStep, @NotNull CucumberStepDefinitionCreationContext fileAndFrameworkType) {
        PsiFile probableGherkinFile;
        if (fileAndFrameworkType == null) {
            CucumberCreateAllStepsFix.$$$reportNull$$$0(1);
        }
        if (!((probableGherkinFile = sourceStep.getContainingFile()) instanceof GherkinFile)) {
            return;
        }
        GherkinFile gherkinFile = (GherkinFile)probableGherkinFile;
        HashSet<String> createdStepDefPatterns = new HashSet<String>();
        for (GherkinFeature feature : gherkinFile.getFeatures()) {
            for (GherkinStepsHolder stepsHolder : feature.getScenarios()) {
                for (GherkinStep step : stepsHolder.getSteps()) {
                    PsiReference[] references;
                    for (PsiReference reference : references = step.getReferences()) {
                        CucumberStepReference stepReference;
                        AbstractStepDefinition definition;
                        if (!(reference instanceof CucumberStepReference) || (definition = (stepReference = (CucumberStepReference)reference).resolveToDefinition()) != null) continue;
                        String pattern = Pattern.quote(step.getName());
                        pattern = StringUtil.trimEnd((String)StringUtil.trimStart((String)pattern, (String)"\\Q"), (String)"\\E");
                        if (createdStepDefPatterns.contains(pattern = CucumberUtil.prepareStepRegexp(pattern))) continue;
                        if (!this.createFileOrStepDefinition(step, fileAndFrameworkType)) {
                            return;
                        }
                        createdStepDefPatterns.add(pattern);
                    }
                }
            }
        }
    }

    @Override
    protected boolean shouldRunTemplateOnStepDefinition() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            CucumberCreateAllStepsFix.$$$reportNull$$$0(2);
        }
        if (previewDescriptor == null) {
            CucumberCreateAllStepsFix.$$$reportNull$$$0(3);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            CucumberCreateAllStepsFix.$$$reportNull$$$0(4);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/CucumberCreateAllStepsFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAndFrameworkType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/CucumberCreateAllStepsFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStepOrSteps";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

