/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.version;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.behat.BehatBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BehatVersionDetector
extends PhpTestFrameworkVersionDetector<String> {
    private static final Logger LOG = Logger.getInstance(BehatVersionDetector.class);
    private static final String[] VERSION_OPTIONS = new String[]{"--no-colors", "--version"};
    private static final String VERSION_PREFIX = "behat";
    @NlsSafe
    private static final String BEHAT = "Behat";
    private static BehatVersionDetector myInstance;

    public static BehatVersionDetector getInstance() {
        if (myInstance == null) {
            myInstance = new BehatVersionDetector();
        }
        return myInstance;
    }

    @NotNull
    protected String getPresentableName() {
        return BEHAT;
    }

    protected String @NotNull [] getVersionOptions() {
        if (VERSION_OPTIONS == null) {
            BehatVersionDetector.$$$reportNull$$$0(0);
        }
        return VERSION_OPTIONS;
    }

    @NotNull
    protected String getTitle() {
        String string = BehatBundle.message("php.behat.getting.behat.version", new Object[0]);
        if (string == null) {
            BehatVersionDetector.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String parse(@Nullable String output) throws ExecutionException {
        List split = StringUtil.split((String)StringUtil.notNullize((String)output).trim(), (String)" ");
        if (split.size() < 2) {
            String message = BehatBundle.message("php.behat.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        if (!StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)split.get(0)), (CharSequence)VERSION_PREFIX)) {
            String message = BehatBundle.message("php.behat.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        String fullVersion = ((String)split.get(split.size() - 1)).trim();
        String shortVersion = ((String)StringUtil.split((String)fullVersion, (String)"-").get(0)).trim();
        if (shortVersion.isEmpty() || !StringUtil.isDecimalDigit((char)shortVersion.charAt(0))) {
            String message = BehatBundle.message("php.behat.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        String string = shortVersion;
        if (string == null) {
            BehatVersionDetector.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/behat/version/BehatVersionDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

