// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.config.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

import java.util.stream.Stream;

/**
 * Provides with custom library roots or overridden PHP Runtime.
 *
 * @see PhpLibraryRoot
 */
public interface PhpLibraryRootProvider {

  /**
   * Provides library roots containing modules. It is important for these virtual files to have at least one subdirectory
   * otherwise it will be skipped. Stream returning could be empty if library roots are not needed in the current context.
   *
   * @return stream of directories containing subdirectories (modules) with PHP files
   */
  @NotNull
  Stream<VirtualFile> getLibraryRoots(@NotNull Project project);

  /**
   * States that library roots are intended to override bundled PHP Runtime.
   *
   * @return {@code true} if library roots are intended to override bundled PHP runtime, {@code false} otherwise
   */
  boolean isRuntime();
}
