// Copyright 2000-2025 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefNamespace;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public abstract class PhpRefManager implements RefManagerExtension<PhpRefManager> {
  public static final @NonNls String CLASS = "phpClass";
  public static final @NonNls String METHOD = "phpMethod";
  public static final @NonNls String FUNCTION = "phpFunction";
  public static final @NonNls String FIELD = "phpField";
  public static final @NonNls String PARAMETER = "phpParameter";
  public static final @NonNls String CONST = "phpConst";
  public static final @NonNls String NAMESPACE = "phpNamespace";
  public static final @NonNls String VARIABLE = "phpVariable";
  private static final @NotNull Key<PhpRefManager> MANAGER = Key.create("PhpRefManager");

  public static @NotNull PhpRefManager getInstance(@NotNull RefManager refManager) {
    return refManager.getExtension(MANAGER);
  }

  public static @NotNull PhpEntryPointsManager getEntryPointsManager(@NotNull RefManager refManager) {
    return getInstance(refManager).getEntryPointsManager();
  }

  public abstract @NotNull PhpEntryPointsManager getEntryPointsManager();

  public abstract @Nullable PhpRefParameter createRefParameter(final @NotNull Parameter psi, final int order, final PhpRefFunction refFunction);

  public abstract boolean isSuitedForEntryPoint(@NotNull RefElement refElement);

  @Override
  public @NotNull Key<PhpRefManager> getID() {
    return MANAGER;
  }

  @Override
  public @NotNull Collection<Language> getLanguages() {
    return new SmartList<>(Language.findInstance(PhpLanguage.class));
  }

  @Override
  public @NotNull RefEntity getRefinedElement(@NotNull RefEntity ref) {
    return ref;
  }

  @Override
  public @Nullable String getGroupName(@NotNull RefEntity entity) {
    return null;
  }


  @Override
  public void iterate(@NotNull RefVisitor visitor) {
  }

  @Override
  public void removeReference(@NotNull RefElement refElement) {
  }

  @Override
  public boolean belongsToScope(@NotNull PsiElement psiElement) {
    return true;
  }

  public abstract @Nullable PhpRefNamespace getNamespace(@NotNull PhpNamespace refElement);
}
