// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;

@ApiStatus.Internal
public interface PhpDeprecationAttributeOwner {
  String DEPRECATION_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\Deprecated";
  @Nullable PhpDeprecationInfo getDeprecationInfo();

  class PhpDeprecationInfo {
    private final @Nullable String myVersion;
    private final @Nullable String myReason;
    private final @Nullable String myReplaceWith;

    public PhpDeprecationInfo(@Nullable String version, @Nullable String reason, @Nullable String replaceWith) {
      myVersion = version;
      myReason = reason;
      myReplaceWith = replaceWith;
    }

    public @Nullable String getVersion() {
      return myVersion;
    }

    public @Nullable String getReason() {
      return myReason;
    }

    public @Nullable String getReplaceWith() {
      return myReplaceWith;
    }

    public static void write(@Nullable PhpDeprecationInfo info, @NotNull StubOutputStream stream) throws IOException {
      if (info == null) {
        stream.writeBoolean(false);
      } else {
        stream.writeBoolean(true);
        stream.writeUTF(StringUtil.notNullize(info.getVersion()));
        stream.writeUTF(StringUtil.notNullize(info.getReason()));
        stream.writeUTF(StringUtil.notNullize(info.getReplaceWith()));
      }
    }

    public static @Nullable PhpDeprecationInfo read(@NotNull StubInputStream stream) throws IOException {
      if (!stream.readBoolean()) {
        return null;
      }
      return new PhpDeprecationInfo(
        StringUtil.nullize(stream.readUTF()),
        StringUtil.nullize(stream.readUTF()),
        StringUtil.nullize(stream.readUTF())
      );
    }
  }
}
