// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.stubs;

import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.Map;
import java.util.Objects;

@ApiStatus.Internal
public class PhpLanguageTypeMap {
  private final @NotNull Map<String, PhpType> myLanguageTypeMap;
  private final @NotNull PhpType myDefaultType;

  public PhpLanguageTypeMap(@NotNull Map<String, PhpType> map, @NotNull PhpType type) {
    myLanguageTypeMap = map;
    myDefaultType = type;
  }

  public @NotNull Map<String, PhpType> getLanguageTypeMap() {
    return myLanguageTypeMap;
  }

  public @NotNull PhpType getDefaultType() {
    return myDefaultType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PhpLanguageTypeMap that = (PhpLanguageTypeMap)o;
    return myLanguageTypeMap.equals(that.myLanguageTypeMap) && myDefaultType.equals(that.myDefaultType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(myLanguageTypeMap, myDefaultType);
  }
}
