// noinspection all
// formatter:off

// Fake Livewire library code - just for IDE completion

$wire = {
    __instance: new Component(),
    $get: function(property, reactive = true) {},
    $el: new Component().el,
    $id: new Component().id,
    $set: function(property, value, live = true){return Promise.resolve()},
    $call: function(method, ...params){return await component.$wire[method](...params)},
    $entangle: function(name, live = true){return Promise.resolve()},
    $toggle: function(name, live = true){return Promise.resolve()},
    $watch: function(path, callback){},

    $on: function(...params){},
    $dispatch: function(...params){},
    $dispatchSelf: function(...params){},
    $dispatchTo: function(...params){},
    $upload: function(name,
                      file,
                      finishCallback = () => { },
                      errorCallback = () => { },
                      progressCallback = () => { },
                      cancelledCallback = () => { }){},
    $uploadMultiple: function(name,
                              files,
                              finishCallback = () => { },
                              errorCallback = () => { },
                              progressCallback = () => { },
                              cancelledCallback = () => { }){},
    $removeUpload: function(name,
                            tmpFilename,
                            finishCallback = () => { },
                            errorCallback = () => { }){},
    $cancelUpload: function(name,
                            cancelledCallback = () => { }){},

    $refresh: function() {},
    $commit: function() {},
    $parent: $wire,

    // Aliases
    get: function(property, reactive = true) {},
    el: new Component().el,
    id: new Component().id,
    set: function(property, value, live = true){return Promise.resolve()},
    call: function(method, ...params){return await component.$wire[method](...params)},
    commit: function() {},
    watch: function(path, callback){},
    entangle: function(name, live = true){return Promise.resolve()},
    on: function(...params){},
    dispatch: function(...params){},
    dispatchSelf: function(...params){},
    dispatchTo: function(...params){},
    upload: function(name,
                      file,
                      finishCallback = () => { },
                      errorCallback = () => { },
                      progressCallback = () => { },
                      cancelledCallback = () => { }){},
    uploadMultiple: function(name,
                              files,
                              finishCallback = () => { },
                              errorCallback = () => { },
                              progressCallback = () => { },
                              cancelledCallback = () => { }){},
    removeUpload: function(name,
                            tmpFilename,
                            finishCallback = () => { },
                            errorCallback = () => { }){},
    cancelUpload: function(name,
                            cancelledCallback = () => { }){},
}

class Component {
    /** HTMLElement */
    el;
    /** String */
    id;
    /** String */
    snapshotEncoded;
    snapshot = {};
    /** String */
    name;

    effects;
    originalEffects;
    // "canonical" data represents the last known server state.
    canonical = {};
    // "ephemeral" represents the most current state. (This can be freely manipulated by end users)
    ephemeral = {};
    // "reactive" is just ephemeral, except when you mutate it, front-ends like Vue react.
    reactive = {};
    queuedUpdates = {};

    // this.$wire = this.reactive
    $wire = $wire;

    /** Array.<{}> */
    cleanups = [];
    constructor(el) {}

    mergeNewSnapshot(snapshotEncoded, effects, updates = {}) {
        return {}
    }

    queueUpdate(propertyName, value) {
        // These updates will be applied first on the server
        // on the next request, then trickle back to the
        // client on the next request that gets sent.
    }

    mergeQueuedUpdates(diff) {
        return diff
    }

    applyUpdates(object, updates) {
        for (let key in updates) {
            dataSet(object, key, updates[key])
        }

        return object
    }

    replayUpdate(snapshot, html) {
        let effects = { ...this.effects, html}

        this.mergeNewSnapshot(JSON.stringify(snapshot), effects)

        this.processEffects({ html })
    }

    /**
     * Here we'll take the new state and side effects from the
     * server and use them to update the existing data that
     * users interact with, triggering reactive effects.
     */
    processEffects(effects) {
        // This is for BC.
        trigger('effects', this, effects)

        trigger('effect', {
            component: this,
            effects,
            cleanup: i => this.addCleanup(i)
        })
    }

    get children() {
        let meta = this.snapshot.memo
        let childIds = Object.values(meta.children).map(i => i[1])

        return childIds.map(id => findComponent(id))
    }

    get parent() {
        return closestComponent(this.el.parentElement)
    }

    inscribeSnapshotAndEffectsOnElement() {}

    addCleanup(cleanup) {
        this.cleanups.push(cleanup)
    }

    cleanup() {
        delete this.el.__livewire

        while (this.cleanups.length > 0) {
            this.cleanups.pop()()
        }
    }
}
