/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.coverage;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathConverter {
    private static final char UNIX_SEPARATOR = '/';
    private static final String UNIX_SEPARATOR_STR = String.valueOf('/');

    private PathConverter() {
    }

    @Nullable
    public static String getNormalizedPath(@Nullable Path basePath, @NotNull String filePath) {
        Path file;
        if (filePath == null) {
            PathConverter.$$$reportNull$$$0(0);
        }
        if (filePath.startsWith(UNIX_SEPARATOR_STR) && File.separatorChar != '/') {
            filePath = filePath.substring(1);
        }
        try {
            file = Path.of(filePath, new String[0]);
        }
        catch (InvalidPathException e) {
            Logger.getInstance(PathConverter.class).warn("Invalid path, skipping coverage for " + filePath, (Throwable)e);
            return null;
        }
        if (!file.isAbsolute() && basePath != null) {
            file = basePath.resolve(filePath);
        }
        return file.normalize().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/javascript/testFramework/coverage/PathConverter", "getNormalizedPath"));
    }
}

