/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.google.gson.stream.JsonReader;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigLookupResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSHintConfigParser {
    private static final Logger LOG = Logger.getInstance(JSHintConfigParser.class);
    private final Set<VirtualFile> myParsedFiles = new HashSet<VirtualFile>();

    private JSHintConfigParser() {
    }

    @NotNull
    private JSHintConfigLookupResult doParse(@NotNull VirtualFile config) {
        JSHintOptionsState optionsState;
        if (config == null) {
            JSHintConfigParser.$$$reportNull$$$0(0);
        }
        if (this.myParsedFiles.contains(config)) {
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, JavaScriptBundle.message((String)"jshint.config.extends.cyclically", (Object[])new Object[0]));
            if (jSHintConfigLookupResult == null) {
                JSHintConfigParser.$$$reportNull$$$0(1);
            }
            return jSHintConfigLookupResult;
        }
        this.myParsedFiles.add(config);
        try {
            String text = JSLinterConfigFileUtil.loadActualText(config);
            optionsState = JSHintConfigParser.parseOptionsState(text);
        }
        catch (IOException e) {
            LOG.info("Cannot parse jshint config at " + config.getPath(), (Throwable)e);
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, JavaScriptBundle.message((String)"jshint.config.failed.to.read", (Object[])new Object[0]));
            if (jSHintConfigLookupResult == null) {
                JSHintConfigParser.$$$reportNull$$$0(2);
            }
            return jSHintConfigLookupResult;
        }
        Object extendsObj = optionsState.getValue("extends");
        if (extendsObj == null) {
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createSuccessfulResult(config, optionsState);
            if (jSHintConfigLookupResult == null) {
                JSHintConfigParser.$$$reportNull$$$0(3);
            }
            return jSHintConfigLookupResult;
        }
        JSHintConfigLookupResult extendedResult = this.doParseExtended(config, extendsObj);
        if (extendedResult.getErrorMessage() != null) {
            JSHintConfigLookupResult jSHintConfigLookupResult = extendedResult;
            if (jSHintConfigLookupResult == null) {
                JSHintConfigParser.$$$reportNull$$$0(4);
            }
            return jSHintConfigLookupResult;
        }
        JSHintOptionsState extendedOptionsState = extendedResult.getOptionsState();
        if (extendedOptionsState == null) {
            LOG.warn("JSHint extended options state is null unexpectedly");
            JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createSuccessfulResult(config, optionsState);
            if (jSHintConfigLookupResult == null) {
                JSHintConfigParser.$$$reportNull$$$0(5);
            }
            return jSHintConfigLookupResult;
        }
        JSHintOptionsState mergedOptionsState = JSHintConfigParser.merge(optionsState, extendedOptionsState);
        JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createSuccessfulResult(config, mergedOptionsState);
        if (jSHintConfigLookupResult == null) {
            JSHintConfigParser.$$$reportNull$$$0(6);
        }
        return jSHintConfigLookupResult;
    }

    @NotNull
    private static JSHintOptionsState merge(@NotNull JSHintOptionsState optionsState, @NotNull JSHintOptionsState extendedOptionsState) {
        if (optionsState == null) {
            JSHintConfigParser.$$$reportNull$$$0(7);
        }
        if (extendedOptionsState == null) {
            JSHintConfigParser.$$$reportNull$$$0(8);
        }
        JSHintOptionsState.Builder builder2 = new JSHintOptionsState.Builder();
        for (String key : extendedOptionsState.getOptionKeys()) {
            if ("extends".equals(key)) continue;
            builder2.put(key, extendedOptionsState.getValue(key));
        }
        for (String key : optionsState.getOptionKeys()) {
            if ("extends".equals(key)) continue;
            builder2.put(key, optionsState.getValue(key));
        }
        Map<String, Boolean> mergedGlobals = JSHintConfigParser.mergeGlobals(extendedOptionsState.getValue(JSHintOption.PREDEF), optionsState.getValue(JSHintOption.PREDEF));
        if (mergedGlobals != null) {
            builder2.put(JSHintOption.PREDEF, mergedGlobals);
        }
        JSHintOptionsState jSHintOptionsState = builder2.build();
        if (jSHintOptionsState == null) {
            JSHintConfigParser.$$$reportNull$$$0(9);
        }
        return jSHintOptionsState;
    }

    @Nullable
    private static Map<String, Boolean> mergeGlobals(@Nullable Object extendedGlobals, @Nullable Object globals) {
        if (extendedGlobals == null || globals == null) {
            return null;
        }
        HashMap<String, Boolean> result2 = new HashMap<String, Boolean>();
        JSHintConfigParser.overwriteGlobals(result2, extendedGlobals);
        JSHintConfigParser.overwriteGlobals(result2, globals);
        return result2;
    }

    private static void overwriteGlobals(@NotNull Map<String, Boolean> result2, @Nullable Object globals) {
        block4: {
            block3: {
                if (result2 == null) {
                    JSHintConfigParser.$$$reportNull$$$0(10);
                }
                if (!(globals instanceof List)) break block3;
                List list = (List)globals;
                for (Object o : list) {
                    if (!(o instanceof String)) continue;
                    result2.put((String)o, false);
                }
                break block4;
            }
            if (!(globals instanceof Map)) break block4;
            Map map = (Map)globals;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Boolean)) continue;
                result2.put((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
    }

    @NotNull
    private JSHintConfigLookupResult doParseExtended(@NotNull VirtualFile config, @NotNull Object extendsObj) {
        if (config == null) {
            JSHintConfigParser.$$$reportNull$$$0(11);
        }
        if (extendsObj == null) {
            JSHintConfigParser.$$$reportNull$$$0(12);
        }
        if (extendsObj instanceof String) {
            String extendsPath = (String)extendsObj;
            VirtualFile configDir = config.getParent();
            if (configDir == null) {
                JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, JavaScriptBundle.message((String)"jshint.config.error.cannot.locate.ext.config", (Object[])new Object[0]));
                if (jSHintConfigLookupResult == null) {
                    JSHintConfigParser.$$$reportNull$$$0(13);
                }
                return jSHintConfigLookupResult;
            }
            VirtualFile extendedFile = configDir.findFileByRelativePath(extendsPath);
            if (extendedFile != null && extendedFile.isValid() && !extendedFile.isDirectory()) {
                return this.doParse(extendedFile);
            }
        }
        JSHintConfigLookupResult jSHintConfigLookupResult = JSHintConfigLookupResult.createErrorResult(config, JavaScriptBundle.message((String)"jshint.config.error.cannot.parse.ext.config", (Object[])new Object[0]));
        if (jSHintConfigLookupResult == null) {
            JSHintConfigParser.$$$reportNull$$$0(14);
        }
        return jSHintConfigLookupResult;
    }

    @NotNull
    private static JSHintOptionsState parseOptionsState(@NotNull String text) throws IOException {
        if (text == null) {
            JSHintConfigParser.$$$reportNull$$$0(15);
        }
        JsonReader reader = new JsonReader((Reader)new StringReader(text));
        reader.setLenient(true);
        JSHintOptionsState jSHintOptionsState = JSHintConfigFileUtil.parseOptionsState(reader);
        if (jSHintOptionsState == null) {
            JSHintConfigParser.$$$reportNull$$$0(16);
        }
        return jSHintOptionsState;
    }

    @NotNull
    public static JSHintConfigLookupResult parse(@NotNull VirtualFile config) {
        if (config == null) {
            JSHintConfigParser.$$$reportNull$$$0(17);
        }
        return new JSHintConfigParser().doParse(config);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 9, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedOptionsState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendsObj";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doParseExtended";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseOptionsState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "overwriteGlobals";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doParseExtended";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseOptionsState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 9, 13, 14, 16 -> new IllegalStateException(string);
        };
    }
}

