/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.liveTemplates.typescript;

import com.intellij.codeInsight.template.LiveTemplateContext;
import com.intellij.codeInsight.template.LiveTemplateContextService;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSStatementContextType;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.frameworks.jsx.JSXHtmlContextType;
import com.intellij.lang.javascript.liveTemplates.JSDotPropertyAccessContextType;
import com.intellij.lang.javascript.liveTemplates.javascript.JSClassContextType;
import com.intellij.lang.javascript.liveTemplates.javascript.JSClassMemberExpressionContextType;
import com.intellij.lang.javascript.liveTemplates.javascript.JSClassMemberStatementContextType;
import com.intellij.lang.javascript.liveTemplates.javascript.JSExpressionContextType;
import com.intellij.lang.javascript.liveTemplates.javascript.JSTopLevelStatementContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TSClassContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TSClassMemberExpressionContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TSClassMemberStatementContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TSDotPropertyAccessContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TSExpressionContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TSStatementContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TSXHtmlContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TypeScriptTemplateContextType;
import com.intellij.lang.javascript.liveTemplates.typescript.TypeScriptTopLevelStatementContextType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration;", "", "<init>", "()V", "isMigrated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkAndMigrate", "", "doMigrate", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSLiveTemplateContextMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLiveTemplateContextMigration.kt\ncom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n23#2:88\n23#2:99\n23#2:100\n1617#3,9:89\n1869#3:98\n1870#3:102\n1626#3:103\n1#4:101\n37#5,2:104\n*S KotlinDebug\n*F\n+ 1 JSLiveTemplateContextMigration.kt\ncom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration\n*L\n82#1:88\n43#1:99\n48#1:100\n40#1:89,9\n40#1:98\n40#1:102\n40#1:103\n40#1:101\n53#1:104,2\n*E\n"})
public final class JSLiveTemplateContextMigration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isMigrated = new AtomicBoolean(false);
    @NotNull
    private static final String JS_CONTEXTS_MIGRATED_PROPERTY = "js.live.template.contexts.migrated";
    @NotNull
    private static final Lazy<Map<TemplateContextType, TemplateContextType>> contextTypeMap$delegate = LazyKt.lazy(JSLiveTemplateContextMigration::contextTypeMap_delegate$lambda$0);

    @RequiresReadLock(generateAssertion=false)
    public final void checkAndMigrate() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() > 241) {
            return;
        }
        if (PropertiesComponent.getInstance().isTrueValue(JS_CONTEXTS_MIGRATED_PROPERTY)) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> JSLiveTemplateContextMigration.checkAndMigrate$lambda$0(this));
    }

    @VisibleForTesting
    public final void doMigrate() {
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        TemplateImpl[] templateImplArray = templateSettings.getTemplates();
        Intrinsics.checkNotNullExpressionValue((Object)templateImplArray, (String)"getTemplates(...)");
        for (TemplateImpl template : templateImplArray) {
            if (templateSettings.findPluginForPredefinedTemplate(template) != null) continue;
            for (Map.Entry entry : JSLiveTemplateContextMigration.Companion.getContextTypeMap().entrySet()) {
                if (!Intrinsics.areEqual((Object)template.getTemplateContext().getOwnValue((TemplateContextType)entry.getKey()), (Object)true) || template.getTemplateContext().isEnabled((TemplateContextType)entry.getValue())) continue;
                template.getTemplateContext().setEnabled((TemplateContextType)entry.getValue(), true);
                JSLiveTemplateContextMigration $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JSLiveTemplateContextMigration.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info(((TemplateContextType)entry.getValue()).getPresentableName() + " context was added to template " + template.getPresentation());
            }
        }
    }

    private static final void checkAndMigrate$lambda$0(JSLiveTemplateContextMigration this$0) {
        if (this$0.isMigrated.compareAndSet(false, true)) {
            PropertiesComponent.getInstance().setValue(JS_CONTEXTS_MIGRATED_PROPERTY, true);
            this$0.doMigrate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map contextTypeMap_delegate$lambda$0() {
        void $this$mapNotNullTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JavaScriptCodeContextType.class), (Object)Reflection.getOrCreateKotlinClass(TypeScriptTemplateContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSExpressionContextType.class), (Object)Reflection.getOrCreateKotlinClass(TSExpressionContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSXHtmlContextType.class), (Object)Reflection.getOrCreateKotlinClass(TSXHtmlContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSStatementContextType.class), (Object)Reflection.getOrCreateKotlinClass(TSStatementContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSTopLevelStatementContextType.class), (Object)Reflection.getOrCreateKotlinClass(TypeScriptTopLevelStatementContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSClassContextType.class), (Object)Reflection.getOrCreateKotlinClass(TSClassContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSClassMemberExpressionContextType.class), (Object)Reflection.getOrCreateKotlinClass(TSClassMemberExpressionContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSClassMemberStatementContextType.class), (Object)Reflection.getOrCreateKotlinClass(TSClassMemberStatementContextType.class)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(JSDotPropertyAccessContextType.class), (Object)Reflection.getOrCreateKotlinClass(TSDotPropertyAccessContextType.class))};
        Map classMap = MapsKt.mapOf((Pair[])pairArray);
        LiveTemplateContextService service = LiveTemplateContextService.getInstance();
        Iterable $this$mapNotNull$iv = classMap.entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            LiveTemplateContext keyContext = service.getLiveTemplateContext(JvmClassMappingKt.getJavaClass((KClass)((KClass)it.getKey())));
            if (keyContext == null) {
                Companion $this$thisLogger$iv = Companion;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Template context " + it.getKey() + " not found");
                pair = null;
            } else {
                LiveTemplateContext valueContext = service.getLiveTemplateContext(JvmClassMappingKt.getJavaClass((KClass)((KClass)it.getValue())));
                if (valueContext == null) {
                    Companion $this$thisLogger$iv = Companion;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Template context " + it.getValue() + " not found");
                    pair = null;
                } else {
                    pair = TuplesKt.to((Object)keyContext.getTemplateContextType(), (Object)valueContext.getTemplateContextType());
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray2 = thisCollection$iv.toArray(new Pair[0]);
        return MapsKt.mapOf((Pair[])Arrays.copyOf(pairArray2, pairArray2.length));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/liveTemplates/typescript/JSLiveTemplateContextMigration$Companion;", "", "<init>", "()V", "JS_CONTEXTS_MIGRATED_PROPERTY", "", "contextTypeMap", "", "Lcom/intellij/codeInsight/template/TemplateContextType;", "getContextTypeMap", "()Ljava/util/Map;", "contextTypeMap$delegate", "Lkotlin/Lazy;", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<TemplateContextType, TemplateContextType> getContextTypeMap() {
            Lazy lazy = contextTypeMap$delegate;
            return (Map)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

