/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.documentation;

import com.intellij.lang.apacheConfig.ApacheConfigBundle;
import com.intellij.lang.apacheConfig.documentation.DocumentationUtil;
import com.intellij.lang.apacheConfig.psi.ACDirectiveBase;
import com.intellij.lang.apacheConfig.psi.schema.ACDirectiveIndex;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;

public class ACDocumentationProvider
implements DocumentationProvider {
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (element instanceof ACDirectiveBase) {
            String moduleName;
            ACDirectiveBase directive = (ACDirectiveBase)element;
            ACDirectiveIndex.DirectiveEntry resolve = ACDirectiveIndex.shared().resolve(directive.getName());
            String string = moduleName = resolve != null ? resolve.getModule() : null;
            if (moduleName != null) {
                return Collections.singletonList(DocumentationUtil.getURL(moduleName, directive.getName()));
            }
        }
        return null;
    }

    @Nls
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        ACDirectiveBase directive;
        ACDirectiveIndex.DirectiveEntry directiveEntry;
        if (element instanceof ACDirectiveBase && (directiveEntry = (directive = (ACDirectiveBase)element).resolve()) != null) {
            @NlsSafe String result = "<b>" + ApacheConfigBundle.message("description.title", new Object[0]) + ":</b> " + directiveEntry.getDescription() + "<br>";
            result = result + "<b>" + ApacheConfigBundle.message("syntax.title", new Object[0]) + ": </b>" + directiveEntry.getSyntax() + "<br>";
            result = result + "<b>" + ApacheConfigBundle.message("module.title", new Object[0]) + ": </b>" + directiveEntry.getModule() + "<br>";
            result = result + "<b>" + ApacheConfigBundle.message("context.title", new Object[0]) + ": </b>" + String.valueOf(directiveEntry.getContext()) + "<br>";
            return result;
        }
        return null;
    }
}

