/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.dql.queryBuilder;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.dql.psi.DqlElement;
import com.jetbrains.php.dql.psi.DqlIdentificationVariable;
import com.jetbrains.php.dql.psi.DqlJoinAssociationPathExpression;
import com.jetbrains.php.dql.psi.DqlNamedParameter;
import com.jetbrains.php.dql.psi.DqlStateField;
import com.jetbrains.php.dql.psi.DqlStateFieldPathExpression;
import com.jetbrains.php.dql.psi.impl.DqlRecursiveVisitor;
import com.jetbrains.php.dql.queryBuilder.DqlBuilderFieldReference;
import com.jetbrains.php.dql.queryBuilder.DqlBuilderKt;
import com.jetbrains.php.dql.queryBuilder.DqlBuilderParameterReferenceFromQuery;
import com.jetbrains.php.dql.queryBuilder.DqlBuilderParameterReferenceFromSetParameters;
import com.jetbrains.php.dql.queryBuilder.DqlBuilderTableReference;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/php/dql/queryBuilder/DqlBuilderReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "processQuery", "Lcom/jetbrains/php/lang/psi/elements/StringLiteralExpression;", "(Lcom/jetbrains/php/lang/psi/elements/StringLiteralExpression;)[Lcom/intellij/psi/PsiReference;", "intellij.dql"})
@SourceDebugExtension(value={"SMAP\nDqlBuilderReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DqlBuilderReferenceContributor.kt\ncom/jetbrains/php/dql/queryBuilder/DqlBuilderReferenceProvider\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,316:1\n66#2,2:317\n37#3,2:319\n*S KotlinDebug\n*F\n+ 1 DqlBuilderReferenceContributor.kt\ncom/jetbrains/php/dql/queryBuilder/DqlBuilderReferenceProvider\n*L\n34#1:317,2\n93#1:319,2\n*E\n"})
final class DqlBuilderReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        String name;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StringLiteralExpression stringLiteralExpression = element instanceof StringLiteralExpression ? (StringLiteralExpression)element : null;
        if (stringLiteralExpression == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        StringLiteralExpression literal = stringLiteralExpression;
        if (literal.getTextLength() < 3) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)literal;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        MethodReference methodReference = (MethodReference)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MethodReference.class, (boolean)true);
        if (methodReference == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        MethodReference calledMethod = methodReference;
        PsiElement[] psiElementArray = calledMethod.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getParameters(...)");
        int index = ArraysKt.indexOf((Object[])psiElementArray, (Object)element);
        if (index != -1 && Intrinsics.areEqual((Object)calledMethod.getName(), (Object)"from") || Intrinsics.areEqual((Object)calledMethod.getName(), (Object)"delete") || Intrinsics.areEqual((Object)calledMethod.getName(), (Object)"update")) {
            if (index == 0) {
                PhpCallbackReferenceBase phpCallbackReferenceBase = PhpCallbackReferenceBase.createClassReference((PsiElement)((PsiElement)literal), (boolean)false);
                if (phpCallbackReferenceBase == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return PsiReference.EMPTY_ARRAY;
                }
                PhpCallbackReferenceBase ref = phpCallbackReferenceBase;
                PsiReference[] psiReferenceArray = new PsiReference[]{ref};
                return psiReferenceArray;
            }
            String string = literal.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContents(...)");
            name = ((Object)StringsKt.trim((CharSequence)string)).toString();
            PsiReference[] psiReferenceArray = new PsiReference[]{new DqlBuilderTableReference(name, (PsiElement)literal, new TextRange(1, 1 + name.length()))};
            return psiReferenceArray;
        }
        if (Intrinsics.areEqual((Object)calledMethod.getName(), (Object)"setParameter")) {
            String string = literal.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContents(...)");
            name = ((Object)StringsKt.trim((CharSequence)string)).toString();
            PsiReference[] psiReferenceArray = new PsiReference[]{new DqlBuilderParameterReferenceFromSetParameters(name, literal, new TextRange(1, 1 + name.length()))};
            return psiReferenceArray;
        }
        Set<Integer> set = DqlBuilderKt.getDqlBuilderMethodsQueryIndexes().get(calledMethod.getName());
        if (set == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Set<Integer> injectIndexes = set;
        if (!injectIndexes.contains(index)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        return this.processQuery((StringLiteralExpression)element);
    }

    private final PsiReference[] processQuery(StringLiteralExpression element) {
        List references = new ArrayList();
        PsiElement psiElement = DqlBuilderKt.parseDql(element);
        if (psiElement == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement psi = psiElement;
        psi.accept((PsiElementVisitor)new DqlRecursiveVisitor(references, element){
            final /* synthetic */ List<PsiReference> $references;
            final /* synthetic */ StringLiteralExpression $element;
            {
                this.$references = $references;
                this.$element = $element;
            }

            public void visitStateFieldPathExpression(DqlStateFieldPathExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                DqlIdentificationVariable dqlIdentificationVariable = o.getIdentificationVariable();
                Intrinsics.checkNotNullExpressionValue((Object)dqlIdentificationVariable, (String)"getIdentificationVariable(...)");
                DqlIdentificationVariable variable = dqlIdentificationVariable;
                DqlStateField dqlStateField = o.getStateField();
                Intrinsics.checkNotNullExpressionValue((Object)dqlStateField, (String)"getStateField(...)");
                DqlStateField field = dqlStateField;
                this.processVariableAndField(variable, field);
            }

            public void visitJoinAssociationPathExpression(DqlJoinAssociationPathExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                DqlIdentificationVariable dqlIdentificationVariable = o.getIdentificationVariable();
                Intrinsics.checkNotNullExpressionValue((Object)dqlIdentificationVariable, (String)"getIdentificationVariable(...)");
                DqlIdentificationVariable variable = dqlIdentificationVariable;
                DqlElement dqlElement = o.getCollectionValuedAssociationField();
                if (dqlElement == null || (dqlElement = dqlElement.getFieldIdentificationVariable()) == null) {
                    return;
                }
                DqlElement field = dqlElement;
                this.processVariableAndField(variable, field);
            }

            public void visitNamedParameter(DqlNamedParameter param) {
                Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                TextRange parameterRange = DqlBuilderKt.getQueryElementTextRange(param);
                this.$references.add((PsiReference)new DqlBuilderParameterReferenceFromQuery(DqlBuilderKt.name(param), this.$element, new TextRange(parameterRange.getStartOffset() + 1, parameterRange.getEndOffset())));
            }

            public final void processVariableAndField(PsiElement variable, PsiElement field) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                TextRange variableRange = DqlBuilderKt.getQueryElementTextRange(variable);
                TextRange fieldRange = DqlBuilderKt.getQueryElementTextRange(field);
                String string = variable.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                DqlBuilderTableReference variableReference = new DqlBuilderTableReference(string, (PsiElement)this.$element, variableRange);
                this.$references.add((PsiReference)variableReference);
                String string2 = field.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                this.$references.add((PsiReference)new DqlBuilderFieldReference(variableReference, string2, (PsiElement)this.$element, fieldRange));
            }
        });
        Collection $this$toTypedArray$iv = references;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }
}

