/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.index;

import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.phar.PharFileSystem;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/php/index/PhpPredefinedIndexChunk;", "Lcom/intellij/indexing/shared/generator/IndexChunk;", "packageName", "", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "stubsMode", "", "<init>", "(Ljava/lang/String;Ljava/util/Collection;Z)V", "getRoots", "()Ljava/util/Collection;", "getStubsMode", "()Z", "name", "getName", "()Ljava/lang/String;", "rootIterators", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "getRootIterators", "()Ljava/util/List;", "findPharRoots", "kind", "getKind", "toString", "intellij.php.sharedIndexes"})
@SourceDebugExtension(value={"SMAP\nPhpDumpPrebuiltIndexCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpDumpPrebuiltIndexCommand.kt\ncom/jetbrains/php/index/PhpPredefinedIndexChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1869#2,2:133\n*S KotlinDebug\n*F\n+ 1 PhpDumpPrebuiltIndexCommand.kt\ncom/jetbrains/php/index/PhpPredefinedIndexChunk\n*L\n91#1:133,2\n*E\n"})
final class PhpPredefinedIndexChunk
implements IndexChunk {
    @NotNull
    private final Collection<VirtualFile> roots;
    private final boolean stubsMode;
    @NotNull
    private final String name;
    @NotNull
    private final String kind;

    public PhpPredefinedIndexChunk(@NotNull String packageName, @NotNull Collection<? extends VirtualFile> roots, boolean stubsMode) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        this.roots = roots;
        this.stubsMode = stubsMode;
        String string = FileUtil.sanitizeFileName((String)packageName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        this.name = string;
        this.kind = "php-predefined";
    }

    @NotNull
    public final Collection<VirtualFile> getRoots() {
        return this.roots;
    }

    public final boolean getStubsMode() {
        return this.stubsMode;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<IndexableFilesIterator> getRootIterators() {
        return CollectionsKt.listOf((Object)new IndexableFilesIterator(this){
            final /* synthetic */ PhpPredefinedIndexChunk this$0;
            {
                this.this$0 = $receiver;
            }

            public String getDebugName() {
                return "php-predefined iterator";
            }

            public String getIndexingProgressText() {
                Object[] objectArray = new Object[]{this.this$0.getName()};
                String string = IndexingBundle.message((String)"indexable.files.provider.indexing.named.provider", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getRootsScanningProgressText() {
                Object[] objectArray = new Object[]{this.this$0.getName()};
                String string = IndexingBundle.message((String)"indexable.files.provider.scanning.files.contributor", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public IndexableSetOrigin getOrigin() {
                throw new UnsupportedOperationException();
            }

            public boolean iterateFiles(Project project, ContentIterator fileIterator, VirtualFileFilter fileFilter) {
                Collection collection;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
                Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
                if (this.this$0.getStubsMode()) {
                    Set set = PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getLibraryRootsBeforeFiltering(...)");
                    collection = set;
                } else {
                    collection = CollectionsKt.plus(this.this$0.getRoots(), (Iterable)PhpPredefinedIndexChunk.access$findPharRoots(this.this$0));
                }
                Collection rootsToIndex = collection;
                return IndexableFilesIterationMethods.iterateRoots$default((IndexableFilesIterationMethods)IndexableFilesIterationMethods.INSTANCE, (Project)project, (Iterable)rootsToIndex, (ContentIterator)fileIterator, (VirtualFileFilter)fileFilter, (boolean)false, (int)16, null);
            }

            public Set<String> getRootUrls(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                throw new UnsupportedOperationException();
            }
        });
    }

    private final Collection<VirtualFile> findPharRoots() {
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        Intrinsics.checkNotNullExpressionValue((Object)indexableFilesDeduplicateFilter, (String)"create(...)");
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter2 = indexableFilesDeduplicateFilter;
        Set res = new LinkedHashSet();
        PharFileSystem pharFileSystem = PharFileSystem.getInstance();
        Iterable $this$forEach$iv = this.roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile root = (VirtualFile)element$iv;
            boolean bl = false;
            VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, (VirtualFileFilter)((VirtualFileFilter)indexableFilesDeduplicateFilter2), arg_0 -> PhpPredefinedIndexChunk.findPharRoots$lambda$0$0(pharFileSystem, res, arg_0));
        }
        return res;
    }

    @NotNull
    public String getKind() {
        return this.kind;
    }

    @NotNull
    public String toString() {
        return "PhpStorm Predefined Index Chunk for " + this.getName();
    }

    private static final boolean findPharRoots$lambda$0$0(PharFileSystem $pharFileSystem, Set $res, VirtualFile it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            VirtualFile virtualFile = $pharFileSystem.getRootByLocal(it);
            if (virtualFile == null) break block0;
            VirtualFile phar = virtualFile;
            boolean bl = false;
            ((Collection)$res).add(phar);
        }
        return true;
    }

    public static final /* synthetic */ Collection access$findPharRoots(PhpPredefinedIndexChunk $this) {
        return $this.findPharRoots();
    }
}

