/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.google.common.base.Preconditions;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.CssPsiColorUtilsCommon;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssEmmetUtil {
    public static final Set<CssPrefix> ALL_PREFIXES = ContainerUtil.newHashSet((Object[])CssPrefix.values());
    public static final Map<Character, CssPrefix> KNOWN_PREFIXES = Map.of(Character.valueOf('w'), CssPrefix.WEBKIT, Character.valueOf('m'), CssPrefix.MOZ, Character.valueOf('s'), CssPrefix.MS, Character.valueOf('o'), CssPrefix.O, Character.valueOf('k'), CssPrefix.KHTML);
    private static final Map<String, String> KEYWORD_ALIASES = Map.of("a", "auto", "i", "inherit", "s", "solid", "da", "dashed", "do", "dotted", "t", "transparent");
    private static final Map<String, String> UNIT_ALIASES = Map.of("p", "%", "e", "em", "x", "ex", "r", "rem");
    private static final String[] KEYWORDS = new String[]{"auto", "all", "inherit"};
    public static final Function<String, String> PREPARE_VALUE = input -> {
        if ("#".equals(input)) {
            return "#000000";
        }
        if (StringUtil.startsWithChar((CharSequence)input, (char)'#')) {
            Color color;
            if ("#t".equals(input)) {
                return "transparent";
            }
            double opacity = -1.0;
            int charIndex = input.indexOf(46);
            if (charIndex > -1) {
                try {
                    opacity = Double.parseDouble("0" + input.substring(charIndex));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                input = input.substring(0, charIndex);
            }
            String normalizedHexColor = CssPsiColorUtilsCommon.Companion.normalizeHexColor(input);
            if (opacity > -1.0 && (color = ColorUtil.fromHex((String)normalizedHexColor, null)) != null) {
                return CssPsiColorUtil.toRgbColor((Color)ColorUtil.withAlpha((Color)color, (double)opacity));
            }
            return normalizedHexColor;
        }
        if (StringUtil.startsWithChar((CharSequence)input, (char)'-') && (input.length() <= 1 || !CssEmmetUtil.isNumeric(input.charAt(1)))) {
            return input.substring(1);
        }
        return CssEmmetUtil.getKeyword(input);
    };
    private static final Pattern SINGLE_PROPERTY_PATTERN = Pattern.compile("^[A-z0-9-]+\\s*:");
    private static final String FLOAT_UNIT = "em";
    private static final String INT_UNIT = "px";

    public static boolean isNumeric(char ch) {
        return ch == '.' || Character.isDigit(ch);
    }

    public static boolean isValidKeyword(@NotNull String string) {
        if (string == null) {
            CssEmmetUtil.$$$reportNull$$$0(0);
        }
        return ArrayUtil.contains((String)CssEmmetUtil.getKeyword(string), (String[])KEYWORDS);
    }

    @NotNull
    private static String getKeyword(@NotNull String alias) {
        if (alias == null) {
            CssEmmetUtil.$$$reportNull$$$0(1);
        }
        String string = KEYWORD_ALIASES.getOrDefault(alias, alias);
        if (string == null) {
            CssEmmetUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String findPatternInSubstring(Pattern pattern, String string, int offset) {
        Preconditions.checkPositionIndex((int)offset, (int)string.length());
        Matcher matcher = pattern.matcher(string.substring(offset));
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private CssEmmetUtil() {
    }

    public static boolean isSingleProperty(@NotNull TemplateImpl template) {
        if (template == null) {
            CssEmmetUtil.$$$reportNull$$$0(3);
        }
        return CssEmmetUtil.getSinglePropertyName(template) != null;
    }

    @Nullable
    public static String getSinglePropertyName(@NotNull TemplateImpl template) {
        String string;
        if (template == null) {
            CssEmmetUtil.$$$reportNull$$$0(4);
        }
        if ((string = template.getString()).contains("\n") || string.contains("/*") || StringUtil.countChars((CharSequence)string, (char)';') > 1) {
            return null;
        }
        if (!SINGLE_PROPERTY_PATTERN.matcher(string).find()) {
            return null;
        }
        return (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)string, (String)":"));
    }

    public static String getUnit(String unit) {
        return UNIT_ALIASES.getOrDefault(unit, unit);
    }

    @NotNull
    public static String normalizeValue(@Nullable String value, boolean unitlessProperty) {
        value = StringUtil.toLowerCase((String)StringUtil.notNullize((String)value).trim());
        Matcher matcher = Pattern.compile("^(-?[0-9.]+)([a-z]*)$").matcher(value);
        if (matcher.find() && matcher.groupCount() > 1) {
            String result = matcher.group(1);
            String unit = matcher.group(2);
            if (unit.isEmpty() && ("0".equals(result) || unitlessProperty)) {
                String string = result;
                if (string == null) {
                    CssEmmetUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (unit.isEmpty()) {
                if (StringUtil.endsWithChar((CharSequence)result, (char)'.')) {
                    String string = result.substring(0, result.length() - 1) + FLOAT_UNIT;
                    if (string == null) {
                        CssEmmetUtil.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                String string = result + (StringUtil.containsChar((String)result, (char)'.') ? FLOAT_UNIT : INT_UNIT);
                if (string == null) {
                    CssEmmetUtil.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = result + CssEmmetUtil.getUnit(unit);
            if (string == null) {
                CssEmmetUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = value;
        if (string == null) {
            CssEmmetUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static Collection<CssPrefix> filterPrefixes(Collection<CssPrefix> prefixes) {
        ArrayList<CssPrefix> result = new ArrayList<CssPrefix>();
        for (CssPrefix prefix : CssPrefix.values()) {
            if (!prefixes.contains((Object)prefix)) continue;
            result.add(prefix);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/CssEmmetUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/CssEmmetUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSingleProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSinglePropertyName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

