/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class GraphCanvasLocationService {
    @NotNull
    private static final GraphCanvasLocationService INSTANCE = new GraphCanvasLocationService();

    @NotNull
    public static GraphCanvasLocationService getInstance() {
        GraphCanvasLocationService graphCanvasLocationService = INSTANCE;
        if (graphCanvasLocationService == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(0);
        }
        return graphCanvasLocationService;
    }

    private GraphCanvasLocationService() {
    }

    @NotNull
    public Point getNodeCoordinatesOnScreen(@NotNull Node node, @NotNull GraphBuilder<?, ?> builder) {
        if (node == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(2);
        }
        Graph2D graph2D = builder.getGraph();
        Graph2DView view = builder.getView();
        Point viewPoint = view.getViewPoint();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        double x = nodeRealizer.getX();
        double y = nodeRealizer.getY();
        JComponent owner = view.getCanvasComponent();
        double oX = owner.getLocationOnScreen().getX();
        double oY = owner.getLocationOnScreen().getY();
        double pX = Math.max((x - (double)viewPoint.x) * view.getZoom() + oX, oX);
        double pY = (y - (double)viewPoint.y) * view.getZoom() + oY;
        return new Point((int)pX, (int)pY);
    }

    @NotNull
    public Point getNodeCoordinatesOnCanvas(@NotNull Node node, @NotNull GraphBuilder<?, ?> builder) {
        if (node == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(4);
        }
        Graph2DView view = builder.getView();
        NodeRealizer nodeRealizer = builder.getGraph().getRealizer(node);
        return new Point(view.toViewCoordX(nodeRealizer.getX()), view.toViewCoordY(nodeRealizer.getY()));
    }

    @NotNull
    public Rectangle getNodeBoundsOnCanvas(@NotNull Node node, @NotNull GraphBuilder<?, ?> builder) {
        if (node == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(6);
        }
        Graph2DView view = builder.getView();
        double zoom = view.getZoom();
        NodeRealizer nodeRealizer = builder.getGraph().getRealizer(node);
        return new Rectangle(view.toViewCoordX(nodeRealizer.getX()), view.toViewCoordY(nodeRealizer.getY()), (int)(nodeRealizer.getWidth() * zoom), (int)(nodeRealizer.getHeight() * zoom));
    }

    @NotNull
    public Point getGraphCenterOnScreen(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(7);
        }
        Graph2DView view = builder.getView();
        Dimension size = view.getViewSize();
        Point top = view.getCanvasComponent().getLocationOnScreen();
        return new Point(top.x + size.width / 2, top.y + size.height / 2);
    }

    @NotNull
    public Point getGraphCenterOnCanvas(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(8);
        }
        Dimension viewSize = builder.getView().getViewSize();
        return new Point(viewSize.width / 2, viewSize.height / 2);
    }

    @NotNull
    public Point getBestPositionForNode(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(9);
        }
        double yy = -1.7976931348623157E308;
        double xx = -1.7976931348623157E308;
        double rightest = -1.7976931348623157E308;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double leftest = Double.MAX_VALUE;
        for (Node node : builder.getGraph().getNodeArray()) {
            NodeLayout nodeLayout = builder.getGraph().getNodeLayout(node);
            if (nodeLayout == null) continue;
            double w = nodeLayout.getWidth();
            double nx = nodeLayout.getX();
            double x = nx + w;
            double h = nodeLayout.getHeight();
            double ny = nodeLayout.getY();
            double y = ny + h;
            if (x > rightest) {
                rightest = x;
            }
            if (x < leftest) {
                leftest = x - w;
            }
            if (!(y >= maxY)) continue;
            xx = y == maxY ? Math.max(xx, nx) : nx;
            yy = Math.max(yy, ny);
            maxX = y == maxY ? Math.max(x, maxX) : x;
            maxY = y;
        }
        if (maxY == -1.7976931348623157E308 || maxX == -1.7976931348623157E308) {
            return new Point(200, 200);
        }
        Point p = new Point();
        if (rightest - maxX < 100.0) {
            p.setLocation(leftest, maxY + 20.0);
        } else {
            p.setLocation(maxX + 20.0, yy);
        }
        Point point = p;
        if (point == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(10);
        }
        return point;
    }

    public void showPopupBeneathNode(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder, @NotNull Node node) {
        if (popup == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(12);
        }
        if (node == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(13);
        }
        Graph2DView view = builder.getView();
        Point nodePos = this.getNodeCoordinatesOnScreen(node, builder);
        popup.showInScreenCoordinates((Component)view.getCanvasComponent(), new Point(nodePos.x, nodePos.y + (int)(24.0 * view.getZoom())));
    }

    public void showPopupInTopCenterOfViewport(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(15);
        }
        JComponent canvas = builder.getView().getCanvasComponent();
        JComponent viewport = (JComponent)canvas.getParent();
        Rectangle viewportBounds = viewport.getBounds();
        Point viewportScreenPoint = viewportBounds.getLocation();
        SwingUtilities.convertPointToScreen(viewportScreenPoint, viewport);
        Dimension popupSize = popup.getSize();
        int popupWidth = popupSize != null ? popupSize.width : JBUI.scale((int)(Toolkit.getDefaultToolkit().getScreenSize().width / 3));
        popup.showInScreenCoordinates((Component)canvas, new Point(viewportScreenPoint.x + viewportBounds.width / 2 - popupWidth / 2, viewportScreenPoint.y + 10));
    }

    public void showInGraphCenter(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(17);
        }
        Point graphCenter = this.getGraphCenterOnScreen(builder);
        popup.showInScreenCoordinates((Component)builder.getView().getCanvasComponent(), new Point(graphCenter.x - 100, graphCenter.y - 100));
    }

    public boolean setBestPopupSizeForGraph(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(18);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(19);
        }
        if (popup.isDisposed()) {
            return false;
        }
        Dimension size = this.calcGraphSize(builder);
        Dimension best = new Dimension(size.width + 40, size.height + 60);
        Dimension screenSize = popup.getContent().getToolkit().getScreenSize();
        boolean canFit = true;
        if (best.width > screenSize.width - 200) {
            canFit = false;
            best.width = screenSize.width - 200;
        }
        if (best.height > screenSize.height - 200) {
            canFit = false;
            best.height = screenSize.height - 200;
        }
        popup.setSize(best);
        return canFit;
    }

    @NotNull
    public <N, E> Dimension calcGraphSize(@NotNull GraphBuilder<N, E> builder) {
        Object layout;
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(20);
        }
        double x0 = 0.0;
        double y0 = 0.0;
        double xx = 0.0;
        double yy = 0.0;
        for (N nodeObject : builder.getNodeObjects()) {
            Node node = builder.getNode(nodeObject);
            if (node == null || (layout = builder.getGraph().getNodeLayout(node)) == null) continue;
            x0 = Math.min(x0, layout.getX());
            y0 = Math.min(y0, layout.getY());
            xx = Math.max(xx, layout.getX() + layout.getWidth());
            yy = Math.max(yy, layout.getY() + layout.getHeight());
        }
        for (Object edgeObject : builder.getEdgeObjects()) {
            Edge edge = builder.getEdge(edgeObject);
            if (edge == null || (layout = builder.getGraph().getEdgeLayout(edge)) == null) continue;
            for (int i = 0; i < layout.pointCount(); ++i) {
                YPoint p = layout.getPoint(i);
                x0 = Math.min(x0, p.getX());
                y0 = Math.min(y0, p.getY());
                xx = Math.max(xx, p.getX());
                yy = Math.max(yy, p.getY());
            }
        }
        int width = (int)(xx - x0);
        int height = (int)(yy - y0);
        if (width == 0) {
            width = JBUIScale.scale((int)400);
        }
        if (height == 0) {
            height = JBUIScale.scale((int)400);
        }
        return x0 == 0.0 && y0 == 0.0 && xx == 0.0 && yy == 0.0 ? JBUI.size((int)400) : new Dimension(width, height);
    }

    @NotNull
    public Rectangle getBoundingBoxOfNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(21);
        }
        Rectangle result = new Rectangle(0, 0, -1, -1);
        NodeCursor nodes = graph.nodes();
        while (nodes.ok()) {
            graph.getRealizer(nodes.node()).calcUnionRect(result);
            nodes.next();
        }
        Rectangle rectangle = result;
        if (rectangle == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(22);
        }
        return rectangle;
    }

    @NotNull
    public Rectangle getBoundingBoxOfNodes(@NotNull Graph2D graph, @NotNull GraphLayout layout) {
        if (graph == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(23);
        }
        if (layout == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(24);
        }
        Rectangle result = new Rectangle(0, 0, -1, -1);
        NodeCursor nodes = graph.nodes();
        while (nodes.ok()) {
            GraphCanvasLocationService.calcUnionRect(result, layout.getNodeLayout(nodes.node()));
            nodes.next();
        }
        Rectangle rectangle = result;
        if (rectangle == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(25);
        }
        return rectangle;
    }

    private static void calcUnionRect(@NotNull Rectangle2D result, @NotNull NodeLayout layout) {
        if (result == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(26);
        }
        if (layout == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(27);
        }
        if (result.getWidth() <= 0.0) {
            result.setFrame(layout.getX(), layout.getY(), layout.getWidth(), layout.getHeight());
        } else {
            double minX = Math.min(layout.getX(), result.getX());
            double maxX = Math.max(layout.getX() + layout.getWidth(), result.getX() + result.getWidth());
            double minY = Math.min(layout.getY(), result.getY());
            double maxY = Math.max(layout.getY() + layout.getHeight(), result.getY() + result.getHeight());
            result.setFrame(minX, minY, maxX - minX, maxY - minY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphCanvasLocationService";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphCanvasLocationService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionForNode";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundingBoxOfNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCoordinatesOnScreen";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCoordinatesOnCanvas";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNodeBoundsOnCanvas";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGraphCenterOnScreen";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGraphCenterOnCanvas";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForNode";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showPopupBeneathNode";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showPopupInTopCenterOfViewport";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showInGraphCenter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setBestPopupSizeForGraph";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcGraphSize";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBoundingBoxOfNodes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcUnionRect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27 -> new IllegalArgumentException(string);
        };
    }
}

