/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.RemoteHostTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.util.List;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpRemoteFileTransferTask
extends RemoteHostTask {
    private static final Logger LOG = Logger.getInstance(PhpRemoteFileTransferTask.class);
    private final List<@Nls String> myErrors;
    private final Semaphore myDone;
    private final int myTimeoutMs;
    private volatile boolean myResult;

    protected PhpRemoteFileTransferTask(@NotNull Project project, @NotNull Deployable serverConfig, @NotNull PublishConfig publishConfig, @NlsContexts.ProgressTitle @NotNull String title, int timeoutMs, boolean background) {
        if (project == null) {
            PhpRemoteFileTransferTask.$$$reportNull$$$0(0);
        }
        if (serverConfig == null) {
            PhpRemoteFileTransferTask.$$$reportNull$$$0(1);
        }
        if (publishConfig == null) {
            PhpRemoteFileTransferTask.$$$reportNull$$$0(2);
        }
        if (title == null) {
            PhpRemoteFileTransferTask.$$$reportNull$$$0(3);
        }
        super(project, ConnectionOwnerFactory.createConnectionOwner((Project)project), serverConfig, publishConfig, title, background, DeploymentRevisionTracker.DEAF, DeploymentMode.CUSTOM);
        this.myErrors = new SmartList();
        this.myDone = new Semaphore();
        assert (timeoutMs > 0);
        this.myTimeoutMs = timeoutMs;
    }

    protected abstract TransferOperation createTransferOperation(@NotNull ExecutionContext var1, @NotNull RemoteConnection var2) throws FileSystemException;

    protected abstract ExecutionContext createExecutionContext(@NotNull ExecutionContextBase var1, @NotNull RemoteConnection var2);

    protected boolean executeOperations(ExecutionContextBase context, RemoteConnection connection) {
        TransferOperation operation;
        ExecutionContext executionContext = this.createExecutionContext(context, connection);
        try {
            operation = this.createTransferOperation(executionContext, connection);
        }
        catch (FileSystemException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.warn((Throwable)e);
            String message = PhpRemoteSdkBundle.message("remote.interpreter.can.not.create.remote.file.manipulation.operation", PublishUtils.getMessage((Throwable)e, (boolean)true));
            this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            return false;
        }
        try {
            operation.execute(executionContext);
            return true;
        }
        catch (FileSystemException e) {
            LOG.warn(String.valueOf(operation) + " failed", (Throwable)e);
            String text = operation.getErrorMessage(executionContext, PublishUtils.getMessage((Throwable)e, (boolean)true));
            this.print(text, ConsoleViewContentType.ERROR_OUTPUT);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PhpRemoteFileTransferTask.$$$reportNull$$$0(4);
        }
        try {
            this.myResult = this.doRun(indicator);
        }
        catch (ProcessCanceledException e) {
            String message = e.getMessage();
            this.myErrors.add(StringUtil.isEmpty((String)message) ? PhpRemoteSdkBundle.message("remote.file.transfer.task.was.canceled", new Object[0]) : message);
        }
        finally {
            this.myDone.up();
        }
    }

    public boolean isConditionalModal() {
        return false;
    }

    public void execute() throws ExecutionException {
        if (this.myProject == null || this.myProject.isDisposed()) {
            throw new ExecutionException(PhpBundle.message((String)"can.not.execute.transfer.task.project.is.already.disposed", (Object[])new Object[0]));
        }
        Object progressIndicator = ProgressManager.getInstance().hasProgressIndicator() && ProgressManager.getInstance().getProgressIndicator().isRunning() ? ProgressWrapper.wrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()) : new EmptyProgressIndicator();
        this.myDone.down();
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, (ProgressIndicator)progressIndicator);
        this.myDone.waitFor((long)this.myTimeoutMs);
        if (progressIndicator.isRunning()) {
            progressIndicator.cancel();
        }
        if (!this.myResult) {
            throw new ExecutionException(this.constructErrorMessage());
        }
    }

    @Nls
    protected abstract String defaultErrorMessage();

    @NotNull
    @Nls
    private String constructErrorMessage() {
        String errorsString;
        if (this.myErrors.isEmpty()) {
            String string = this.defaultErrorMessage();
            if (string == null) {
                PhpRemoteFileTransferTask.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = errorsString = StringUtil.join(this.myErrors, (String)", ");
        if (string == null) {
            PhpRemoteFileTransferTask.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void print(@NlsSafe String text, ConsoleViewContentType contentType) {
        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.myErrors.add(text);
            LOG.warn(text);
        } else {
            LOG.info(text);
        }
    }

    protected void showBalloon(MessageType type, @NlsContexts.NotificationContent String text, boolean isSummary) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpRemoteFileTransferTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteFileTransferTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "constructErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

