/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.util.Consumer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.PhpRemoteSdkConnector;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSshConnectionProvider
implements SshConnectionProvider {
    private static String getId(RemoteCredentials credentials, RemoteSdkProperties sdkProperties) {
        return RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)sdkProperties);
    }

    @NotNull
    public Collection<? extends RemoteConnector> collectRemoteConnectors() {
        List list = List.of();
        if (list == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(@NotNull RemoteConnectionType type, @Nullable String id, @NotNull Project project, @Nullable Module module) {
        if (type == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(2);
        }
        if (type == RemoteConnectionType.DEFAULT_SDK) {
            PhpSdkAdditionalData data;
            PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance((Project)project).getInterpreter();
            PhpSdkAdditionalData phpSdkAdditionalData = data = interpreter != null ? interpreter.getPhpSdkAdditionalData() : null;
            if (data instanceof PhpRemoteSdkAdditionalData) {
                PhpRemoteSdkAdditionalData sdkData = (PhpRemoteSdkAdditionalData)data;
                return new PhpRemoteSdkConnector(sdkData, project);
            }
            if (data != null) {
                String warning = PhpBundle.message((String)"remote.connection.settings.interpreter.is.not.remote", (Object[])new Object[0]);
                @Nls String title = (String)RemoteDataProducer.NO_HOST_TO_CONNECT_SUPPLIER.get();
                Messages.showWarningDialog((Project)project, (String)warning, (String)title);
            }
        } else if (type == RemoteConnectionType.REMOTE_SDK) {
            // empty if block
        }
        return null;
    }

    @Nls
    @NotNull
    public String getRadioButtonDescription() {
        String string = PhpBundle.message((String)"remote.connection.settings.default.remote.interpreter", (Object[])new Object[0]);
        if (string == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public RemoteConnectionType getTypeForConfigurable() {
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.DEFAULT_SDK;
        if (remoteConnectionType == null) {
            PhpSshConnectionProvider.$$$reportNull$$$0(4);
        }
        return remoteConnectionType;
    }

    @Nullable
    @Nls
    public String getSettingCreationDescription() {
        return PhpRemoteSdkBundle.message("add.php.remote.interpreter", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpSshConnectionProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRemoteConnectors";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpSshConnectionProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRadioButtonDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteConnector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class RemoteInterpreterConnector
    implements RemoteConnector {
        private final RemoteCredentials myCredentials;
        private final RemoteSdkProperties mySdkProperties;

        private RemoteInterpreterConnector(RemoteCredentials credentials, RemoteSdkProperties sdkProperties) {
            this.myCredentials = new RemoteCredentialsHolder(credentials);
            this.mySdkProperties = new RemoteSdkPropertiesHolder(sdkProperties.getDefaultHelpersName());
            this.mySdkProperties.setInterpreterPath(sdkProperties.getInterpreterPath());
            this.mySdkProperties.setHelpersPath(sdkProperties.getHelpersPath());
            this.mySdkProperties.setHelpersVersionChecked(sdkProperties.isHelpersVersionChecked());
            this.mySdkProperties.setRunAsRootViaSudo(sdkProperties.isRunAsRootViaSudo());
        }

        public String getId() {
            return PhpSshConnectionProvider.getId(this.myCredentials, this.mySdkProperties);
        }

        @NlsSafe
        @NotNull
        public String getName() {
            String string = this.myCredentials.getHost() + ":" + this.myCredentials.getPort() + " (Remote interpreter)";
            if (string == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.REMOTE_SDK;
            if (remoteConnectionType == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(1);
            }
            return remoteConnectionType;
        }

        public void produceRemoteCredentials(Consumer<? super RemoteCredentials> consumer) {
            consumer.consume((Object)this.myCredentials);
        }

        @NonNls
        @NotNull
        public Object getConnectorKey() {
            String string = this.myCredentials.getHost() + ":" + this.myCredentials.getPort();
            if (string == null) {
                RemoteInterpreterConnector.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/remote/PhpSshConnectionProvider$RemoteInterpreterConnector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectorKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

