/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.clt;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.clt.DrushDescriptionProvider;
import com.jetbrains.php.drupal.clt.DrushUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.ui.CommandLineOpenSettingsProvider;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DrushCommandLineComposerConfig
extends PackageComposerConfigClient {
    @NonNls
    private static final String PACKAGE = "drush/drush";
    public static final String DRUSH = "drush" + (SystemInfo.isWindows ? ".bat" : "");

    private DrushCommandLineComposerConfig() {
        super(PACKAGE, PACKAGE);
    }

    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile config) {
        FrameworkDataService instance;
        VirtualFile drush;
        if (project == null) {
            DrushCommandLineComposerConfig.$$$reportNull$$$0(0);
        }
        if ((drush = DrushCommandLineComposerConfig.findDrush(project)) != null && !ContainerUtil.exists((Iterable)(instance = FrameworkDataService.getInstance((Project)project)).getCommands(), i -> i.getFrameworkDescription().getFrameworkId().equals("ws.drush"))) {
            FrameworkDescription description = DrushUtils.getDrushFrameworkDescription(drush.getPath());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    List<FrameworkCommand> commands = new DrushDescriptionProvider().getFrameworkCommands(drush.getPath(), project, (ProgressIndicator)new ProgressIndicatorBase());
                    List data = instance.cloneData();
                    data.add(new FrameworkDataService.FrameworkFileData(new FrameworkConfigurationDescription(description, commands), null, drush.getPath(), true));
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> instance.loadChanged(data));
                    this.notify(project, DrupalBundle.message("drush.command.line.tool.updated", new Object[0]), (ComposerLogMessageBuilder.Settings)new CommandLineOpenSettingsProvider());
                }
                catch (FrameworkDescriptionProvider.FrameworkExecutionException | FrameworkDescriptionProvider.FrameworkParseException throwable) {
                    // empty catch block
                }
            });
        }
    }

    private static VirtualFile findDrush(@NotNull Project project) {
        VirtualFile configFile;
        if (project == null) {
            DrushCommandLineComposerConfig.$$$reportNull$$$0(1);
        }
        if ((configFile = ComposerDataService.getInstance((Project)project).getConfigFile()) == null) {
            return null;
        }
        Pair dirs = ComposerConfigUtils.getVendorAndBinDirs((VirtualFile)configFile);
        if (dirs == null) {
            return null;
        }
        VirtualFile vendorDir = ComposerUtils.findVendorDir((VirtualFile)configFile, (String)((String)dirs.getFirst()));
        if (vendorDir == null) {
            return null;
        }
        VirtualFile bin = vendorDir.findChild("bin");
        if (bin == null) {
            return null;
        }
        return bin.findChild(DRUSH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/php/drupal/clt/DrushCommandLineComposerConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findDrush";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

