/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DrupalHookInvocationMethod {
    MODULE_INVOKE_ALL_6_7_8("module_invoke_all", 0, false),
    MODULE_INVOKE_6_7_8("module_invoke", 1, false),
    DRUPAL_ALTER_6_7_8("drupal_alter", 0, false){

        @Override
        public boolean mayBeInvokedBy(String hookName) {
            return hookName.endsWith(DrupalHookInvocationMethod.ALTER_IMPL_SUFFIX);
        }

        @Override
        public String @Nullable [] getHookNamesFromInvocation(FunctionReference functionReference) {
            Object[] shortHookName = super.getHookNamesFromInvocation(functionReference);
            if (shortHookName != null) {
                List filtered = ContainerUtil.filter((Object[])shortHookName, DrupalHookInvocationMethod::isValidHookName);
                return (String[])ContainerUtil.map2Array((Collection)filtered, String.class, s -> s + DrupalHookInvocationMethod.ALTER_IMPL_SUFFIX);
            }
            return null;
        }
    }
    ,
    MODULE_HANDLER_INVOKE_ALL_8("invokeAll", 0, true){

        @Override
        public boolean suitsSlow(FunctionReference reference) {
            return super.suitsSlow(reference) && DrupalHookInvocationMethod.isInModuleHandler(reference);
        }
    }
    ,
    MODULE_HANDLER_INVOKE_8("invoke", 1, true){

        @Override
        public boolean suitsSlow(FunctionReference reference) {
            return super.suitsSlow(reference) && DrupalHookInvocationMethod.isInModuleHandler(reference);
        }
    }
    ,
    MODULE_HANDLER_ALTER_8("alter", 0, true){

        @Override
        public boolean mayBeInvokedBy(String hookName) {
            return hookName.endsWith(DrupalHookInvocationMethod.ALTER_IMPL_SUFFIX);
        }

        @Override
        public String @Nullable [] getHookNamesFromInvocation(FunctionReference functionReference) {
            PsiElement parameter = functionReference.getParameter(this.getHookParameterNumber());
            if (parameter == null) {
                return null;
            }
            if (parameter instanceof StringLiteralExpression) {
                if (parameter.getChildren().length != 0) {
                    return null;
                }
                String name = ((StringLiteralExpression)parameter).getContents() + DrupalHookInvocationMethod.ALTER_IMPL_SUFFIX;
                if (!DrupalHookInvocationMethod.isValidHookName(name)) {
                    return null;
                }
                return new String[]{name};
            }
            if (parameter instanceof ArrayCreationExpression) {
                SmartList result = new SmartList();
                for (PsiElement child : parameter.getChildren()) {
                    PsiElement valueChild;
                    PsiElement[] valueChildren;
                    IElementType childType = child.getNode().getElementType();
                    if (PhpElementTypes.ARRAY_VALUE != childType || (valueChildren = child.getChildren()).length != 1 || !((valueChild = valueChildren[0]) instanceof StringLiteralExpression) || valueChild.getChildren().length != 0) continue;
                    String name = ((StringLiteralExpression)valueChild).getContents() + DrupalHookInvocationMethod.ALTER_IMPL_SUFFIX;
                    if (!DrupalHookInvocationMethod.isValidHookName(name)) {
                        return null;
                    }
                    result.add(name);
                }
                return result.isEmpty() ? null : ArrayUtilRt.toStringArray((Collection)result);
            }
            return null;
        }

        @Override
        public boolean suitsSlow(FunctionReference reference) {
            return super.suitsSlow(reference) && DrupalHookInvocationMethod.isInModuleHandler(reference);
        }
    };

    @NonNls
    private static final String ALTER_IMPL_SUFFIX = "_alter";
    @NonNls
    private static final String MODULE_HANDLER_INTERFACE_FQN = "\\Drupal\\Core\\Extension\\ModuleHandlerInterface";
    private final String name;
    private final int hookParameterNumber;
    private final boolean isMethod;

    private DrupalHookInvocationMethod(String name, int hookParameterNumber, boolean isMethod) {
        this.name = name;
        this.hookParameterNumber = hookParameterNumber;
        this.isMethod = isMethod;
    }

    public boolean sameNameAndType(String name, FunctionReference reference) {
        return this.name.equals(name) && this.isMethod == reference instanceof MethodReference;
    }

    protected int getHookParameterNumber() {
        return this.hookParameterNumber;
    }

    public boolean mayBeInvokedBy(String hookName) {
        return true;
    }

    public String @Nullable [] getHookNamesFromInvocation(FunctionReference functionReference) {
        PsiElement hookParameter = functionReference.getParameter(this.getHookParameterNumber());
        if (!(hookParameter instanceof StringLiteralExpression)) {
            return null;
        }
        if (hookParameter.getChildren().length != 0) {
            return null;
        }
        String contents = ((StringLiteralExpression)hookParameter).getContents();
        if (!DrupalHookInvocationMethod.isValidHookName(contents)) {
            return null;
        }
        return new String[]{contents};
    }

    public boolean suitsSlow(FunctionReference reference) {
        return true;
    }

    private static boolean isInModuleHandler(FunctionReference functionReference) {
        if (!(functionReference instanceof MethodReference)) {
            return false;
        }
        MethodReference reference = (MethodReference)functionReference;
        PhpExpression expression = reference.getClassReference();
        if (expression == null) {
            return false;
        }
        PhpType type = expression.getType();
        if ((type = type.global(reference.getProject())) == null) {
            return false;
        }
        return type.getTypes().contains(MODULE_HANDLER_INTERFACE_FQN);
    }

    private static boolean isValidHookName(@NotNull String name) {
        if (name == null) {
            DrupalHookInvocationMethod.$$$reportNull$$$0(0);
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/drupal/hooks/DrupalHookInvocationMethod", "isValidHookName"));
    }
}

