/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.foldings.FoldingCalculatorTask;
import com.intellij.ideolog.util.IdeologDocumentContext;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ideolog/intentions/ResetHiddenItemsIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "getText", "", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "intellij.ideolog"})
public final class ResetHiddenItemsIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return IdeologBundle.message("intention.name.restore.all.hidden.lines", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return IdeologBundle.message("intention.family.name.logs", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiFile psiFile2 = psiFile;
        if (!Intrinsics.areEqual((Object)(psiFile2 != null ? psiFile2.getFileType() : null), (Object)((Object)LogFileType.INSTANCE))) {
            return false;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        IdeologDocumentContext context = IdeologDocumentContextKt.getIdeologContext(document);
        boolean hasHiddenItems = !((Collection)context.getHiddenItems()).isEmpty();
        boolean hasHiddenSubstrings = !((Collection)context.getHiddenSubstrings()).isEmpty();
        boolean hasWhitelistedSubstrings = !((Collection)context.getWhitelistedSubstrings()).isEmpty();
        boolean hasWhitelistedItems = !((Collection)context.getWhitelistedItems()).isEmpty();
        return hasHiddenItems || hasHiddenSubstrings || hasWhitelistedSubstrings || hasWhitelistedItems || context.getHideLinesAbove() >= 0 || context.getHideLinesBelow() < Integer.MAX_VALUE;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        IdeologDocumentContext context = IdeologDocumentContextKt.getIdeologContext(document);
        context.getHiddenItems().clear();
        context.getHiddenSubstrings().clear();
        context.getWhitelistedItems().clear();
        context.getWhitelistedSubstrings().clear();
        context.setHideLinesAbove(-1);
        context.setHideLinesBelow(Integer.MAX_VALUE);
        FoldingCalculatorTask.Companion.restartFoldingCalculator(project, editor, psiFile);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

