/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.util;

import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.highlighting.LogEvent;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.highlighting.settings.LogParsingPattern;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.util.GoToActionContext;
import com.intellij.ideolog.util.IdeologDocumentContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0002*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"documentContextKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ideolog/util/IdeologDocumentContext;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "ideologContext", "Lcom/intellij/openapi/editor/Document;", "getIdeologContext", "(Lcom/intellij/openapi/editor/Document;)Lcom/intellij/ideolog/util/IdeologDocumentContext;", "isEnabled", "", "Lcom/intellij/ideolog/lex/LogFileFormat;", "getSelectedText", "", "Lcom/intellij/openapi/editor/Editor;", "getGoToActionContext", "Lcom/intellij/ideolog/util/GoToActionContext;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nIdeologDocumentContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeologDocumentContext.kt\ncom/intellij/ideolog/util/IdeologDocumentContextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n295#2,2:235\n*S KotlinDebug\n*F\n+ 1 IdeologDocumentContext.kt\ncom/intellij/ideolog/util/IdeologDocumentContextKt\n*L\n191#1:235,2\n*E\n"})
public final class IdeologDocumentContextKt {
    @NotNull
    private static final Key<IdeologDocumentContext> documentContextKey;

    @NotNull
    public static final IdeologDocumentContext getIdeologContext(@NotNull Document $this$ideologContext) {
        Intrinsics.checkNotNullParameter((Object)$this$ideologContext, (String)"<this>");
        IdeologDocumentContext ideologDocumentContext = (IdeologDocumentContext)$this$ideologContext.getUserData(documentContextKey);
        if (ideologDocumentContext == null) {
            Document $this$_get_ideologContext__u24lambda_u240 = $this$ideologContext;
            boolean bl = false;
            $this$_get_ideologContext__u24lambda_u240.putUserData(documentContextKey, (Object)new IdeologDocumentContext($this$_get_ideologContext__u24lambda_u240, null, 2, null));
            Object object = $this$_get_ideologContext__u24lambda_u240.getUserData(documentContextKey);
            Intrinsics.checkNotNull((Object)object);
            ideologDocumentContext = (IdeologDocumentContext)object;
        }
        return ideologDocumentContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isEnabled(LogFileFormat $this$isEnabled) {
        Object v0;
        block1: {
            if ($this$isEnabled.getMyRegexLogParser() == null) return true;
            Iterable $this$firstOrNull$iv = LogHighlightingSettingsStore.Companion.getInstance().getMyState().getParsingPatterns();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LogParsingPattern pattern = (LogParsingPattern)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)pattern.getUuid(), (Object)$this$isEnabled.getMyRegexLogParser().getUuid())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        LogParsingPattern logParsingPattern = v0;
        if (logParsingPattern == null) return false;
        if (!logParsingPattern.getEnabled()) return false;
        return true;
    }

    @Nullable
    public static final CharSequence getSelectedText(@NotNull Editor $this$getSelectedText) {
        int selectionStart;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedText, (String)"<this>");
        SelectionModel selectionModel = $this$getSelectedText.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        int selectionEnd = selectionModel2.getSelectionEnd();
        if (selectionStart == selectionEnd) {
            CharSequence charSequence = $this$getSelectedText.getDocument().getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence doc = charSequence;
            for (selectionStart = selectionModel2.getSelectionStart(); selectionStart > 0 && Character.isLetterOrDigit(doc.charAt(selectionStart - 1)); --selectionStart) {
            }
            while (selectionEnd < doc.length() && Character.isLetterOrDigit(doc.charAt(selectionEnd))) {
                ++selectionEnd;
            }
        }
        if (selectionEnd - selectionStart > 100 || selectionEnd == selectionStart) {
            return null;
        }
        return $this$getSelectedText.getDocument().getText(new TextRange(selectionStart, selectionEnd));
    }

    @Nullable
    public static final GoToActionContext getGoToActionContext(@NotNull AnActionEvent $this$getGoToActionContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getGoToActionContext, (String)"<this>");
        Editor editor = (Editor)$this$getGoToActionContext.getDataContext().getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)$this$getGoToActionContext.getDataContext().getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Project project = (Project)$this$getGoToActionContext.getDataContext().getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        if (!Intrinsics.areEqual((Object)psiFile2.getFileType(), (Object)((Object)LogFileType.INSTANCE))) {
            return null;
        }
        FoldingModel foldingModel = editor2.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        FoldingModel foldingModel2 = foldingModel;
        LogEvent event = LogEvent.Companion.fromEditor(editor2, editor2.getCaretModel().getOffset());
        return new GoToActionContext(event, editor2, foldingModel2, project2, psiFile2);
    }

    public static final /* synthetic */ boolean access$isEnabled(LogFileFormat $receiver) {
        return IdeologDocumentContextKt.isEnabled($receiver);
    }

    static {
        Key key = Key.create((String)"IdeologDocumentContext");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        documentContextKey = key;
    }
}

