/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.symfony.asset.mapper;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.JSModuleVisitor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.symfony.SymfonyBundle;
import com.intellij.symfony.asset.mapper.SymfonyAssetMapperManager;
import com.intellij.symfony.asset.mapper.SymfonyAssetMapperReferenceContributorKt;
import com.intellij.symfony.asset.mapper.SymfonyDownloadLibraryQuickFix;
import com.intellij.symfony.asset.mapper.SymfonyImportMapModuleIsNotInstalledInspectionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/symfony/asset/mapper/SymfonyLibraryIsNotDownloadedInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.symfony"})
public final class SymfonyLibraryIsNotDownloadedInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new JSModuleVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            protected boolean isAvailable(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return SymfonyAssetMapperReferenceContributorKt.isSymfonyAssetMapperUsed(element);
            }

            protected void processImport(PsiElement literalElement, String quotedLiteralValue, PsiReference[] references, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkNotNullParameter((Object)literalElement, (String)"literalElement");
                Intrinsics.checkNotNullParameter((Object)quotedLiteralValue, (String)"quotedLiteralValue");
                Intrinsics.checkNotNullParameter((Object)references, (String)"references");
                Intrinsics.checkNotNullParameter((Object)importResolver, (String)"importResolver");
                Intrinsics.checkNotNullParameter((Object)pointerBuilder, (String)"pointerBuilder");
                String string = StringUtil.unquoteString((String)quotedLiteralValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
                String moduleName = string;
                Project project = literalElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String string2 = SymfonyImportMapModuleIsNotInstalledInspectionKt.getUrl(project, moduleName);
                if (string2 == null) {
                    return;
                }
                String url = string2;
                if (SymfonyAssetMapperManager.Companion.tryToResolveByExternalUrl(url) != null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SymfonyDownloadLibraryQuickFix(url)};
                this.$holder.registerProblem(literalElement, SymfonyBundle.INSTANCE.message("symfony.asset.mapper.unresolved.library", new Object[0]), localQuickFixArray);
            }

            protected void processRequire(JSCallExpression element, JSLiteralExpression argument, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)importResolver, (String)"importResolver");
                Intrinsics.checkNotNullParameter((Object)pointerBuilder, (String)"pointerBuilder");
                if (!argument.isStringLiteral()) {
                    return;
                }
                Project project = argument.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String string = argument.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = SymfonyImportMapModuleIsNotInstalledInspectionKt.getUrl(project, string);
                if (string2 == null) {
                    return;
                }
                String url = string2;
                if (SymfonyAssetMapperManager.Companion.tryToResolveByExternalUrl(url) != null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SymfonyDownloadLibraryQuickFix(url)};
                this.$holder.registerProblem((PsiElement)argument, SymfonyBundle.INSTANCE.message("symfony.asset.mapper.unresolved.library", new Object[0]), localQuickFixArray);
            }
        };
    }
}

