/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.php.ComposerDependency;
import com.jetbrains.php.composer.ComposerInitSupportAction;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a.\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\t\u001a\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"generateComposerProject", "", "project", "Lcom/intellij/openapi/project/Project;", "requireDevDependencies", "", "Lcom/jetbrains/php/ComposerDependency;", "requireDependencies", "createComposerJsonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "reformatAndOpenFile", "composerJsonFile", "createRequireSection", "", "dependencies", "sectionName", "intellij.php.impl"})
public final class PhpNewProjectWizardKt {
    public static final void generateComposerProject(@NotNull Project project, @NotNull List<ComposerDependency> requireDevDependencies, @NotNull List<ComposerDependency> requireDependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(requireDevDependencies, (String)"requireDevDependencies");
        Intrinsics.checkNotNullParameter(requireDependencies, (String)"requireDependencies");
        VirtualFile composerJsonFile = PhpNewProjectWizardKt.createComposerJsonFile(project, requireDevDependencies, requireDependencies);
        if (composerJsonFile != null) {
            PhpNewProjectWizardKt.reformatAndOpenFile(project, composerJsonFile);
        }
    }

    @Nullable
    public static final VirtualFile createComposerJsonFile(@Nullable Project project, @NotNull List<ComposerDependency> requireDevDependencies, @NotNull List<ComposerDependency> requireDependencies) {
        Intrinsics.checkNotNullParameter(requireDevDependencies, (String)"requireDevDependencies");
        Intrinsics.checkNotNullParameter(requireDependencies, (String)"requireDependencies");
        if (project == null) {
            return null;
        }
        VirtualFile virtualFile = ComposerInitSupportAction.getParentFolder(project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parentFolder = virtualFile;
        Object[] objectArray = parentFolder.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPath(...)");
        Object[] objectArray2 = objectArray;
        String[] stringArray = new String[]{"composer.json"};
        Path path = Paths.get((String)objectArray2, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        VirtualFile virtualFile2 = VfsUtil.findFile((Path)Files.createFile(path, new FileAttribute[0]), (boolean)true);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile composerJsonFile = virtualFile2;
        VirtualFile[] virtualFileArray = new VirtualFile[]{composerJsonFile};
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
        FileDocumentManager.getInstance().saveAllDocuments();
        objectArray2 = new String[]{PhpNewProjectWizardKt.createRequireSection(requireDevDependencies, "require-dev"), PhpNewProjectWizardKt.createRequireSection(requireDependencies, "require")};
        String composerJsonText = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.sequenceOf((Object[])objectArray2), PhpNewProjectWizardKt::createComposerJsonFile$lambda$0), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        VfsUtil.saveText((VirtualFile)composerJsonFile, (String)("{\n" + composerJsonText + "}"));
        return composerJsonFile;
    }

    public static final void reformatAndOpenFile(@NotNull Project project, @NotNull VirtualFile composerJsonFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)composerJsonFile, (String)"composerJsonFile");
        ApplicationManager.getApplication().invokeLater(() -> PhpNewProjectWizardKt.reformatAndOpenFile$lambda$0(project, composerJsonFile));
    }

    private static final String createRequireSection(List<ComposerDependency> dependencies, String sectionName) {
        String section = CollectionsKt.joinToString$default((Iterable)dependencies, (CharSequence)", ", null, null, (int)0, null, PhpNewProjectWizardKt::createRequireSection$lambda$0, (int)30, null);
        return ((CharSequence)section).length() == 0 ? section : "\"" + sectionName + "\" : {" + section + "}";
    }

    private static final boolean createComposerJsonFile$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final void reformatAndOpenFile$lambda$0(Project $project, VirtualFile $composerJsonFile) {
        PsiManager psiManager = PsiManager.getInstance((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        PsiFile psiFile = psiManager2.findFile($composerJsonFile);
        new ReformatCodeProcessor($project, psiFile, null, false).run();
        if (psiFile != null) {
            EditorHelper.openInEditor((PsiElement)psiFile.getLastChild(), (boolean)true, (boolean)true);
        }
    }

    private static final CharSequence createRequireSection$lambda$0(ComposerDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it.getName() + "\" : \"" + it.getVersion() + "\"";
    }
}

