/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.TreeTraversal;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpOpenCloseTagsRemoveProcessor
implements CopyPastePreProcessor {
    private static final String CLOSE_TAG = "?>";
    private static final String[] ourOpenTags = new String[]{"<?php", "<?=", "<?"};
    public static final TokenSet OPEN_TAGS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG});

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (file instanceof PhpFile) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset();
            PsiElement element = file.findElementAt(caretOffset);
            if (!selectionModel.hasSelection() && PhpSmartKeysConfiguration.getInstance().isRemovePhpTagsWhilePastingByDefault() && PhpOpenCloseTagsRemoveProcessor.inSuitablePhpContext((PhpFile)file, element, caretOffset)) {
                return PhpOpenCloseTagsRemoveProcessor.removeOpenAndCloseTags(project, text);
            }
        }
        String string = text;
        if (string == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String removeOpenAndCloseTags(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(1);
        }
        if (text == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(2);
        }
        for (String openTag : ourOpenTags) {
            String textWithRemovedTags = PhpOpenCloseTagsRemoveProcessor.removeOpenAndCloseTags(text, openTag);
            if (textWithRemovedTags == null) continue;
            String string = textWithRemovedTags;
            if (string == null) {
                PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static String removeOpenAndCloseTags(@NotNull String text, @NotNull String openTag) {
        int indexOfOpenTag;
        if (text == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(5);
        }
        if (openTag == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(6);
        }
        if ((indexOfOpenTag = text.indexOf(openTag)) >= 0 && StringUtil.isEmptyOrSpaces((String)text.substring(0, indexOfOpenTag)) && PhpOpenCloseTagsRemoveProcessor.isWhiteSpace(text, indexOfOpenTag + openTag.length())) {
            boolean anotherOpenTagExists;
            boolean bl = anotherOpenTagExists = text.indexOf(openTag, indexOfOpenTag + openTag.length()) > indexOfOpenTag;
            if (!anotherOpenTagExists) {
                String textWithRemovedOpenTag = StringUtil.replaceSubstring((String)text, (TextRange)TextRange.create((int)indexOfOpenTag, (int)(indexOfOpenTag + openTag.length())), (String)"");
                return PhpOpenCloseTagsRemoveProcessor.removeClosingTag(textWithRemovedOpenTag);
            }
        }
        return null;
    }

    @NotNull
    private static String removeClosingTag(@NotNull String text) {
        int indexOfClosingTag;
        if (text == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(7);
        }
        if ((indexOfClosingTag = text.lastIndexOf(CLOSE_TAG)) > 0 && StringUtil.isEmptyOrSpaces((String)text.substring(indexOfClosingTag + CLOSE_TAG.length())) && PhpOpenCloseTagsRemoveProcessor.isWhiteSpace(text, indexOfClosingTag - 1)) {
            String string = StringUtil.replaceSubstring((String)text, (TextRange)TextRange.create((int)indexOfClosingTag, (int)(indexOfClosingTag + CLOSE_TAG.length())), (String)"");
            if (string == null) {
                PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean isWhiteSpace(@NotNull String text, int index) {
        if (text == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(10);
        }
        return index >= 0 && index < text.length() && Character.isWhitespace(text.charAt(index));
    }

    @NotNull
    private static Collection<TextRange> collectRangesBetweenPhpTags(@NotNull PsiElement file) {
        if (file == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(11);
        }
        SmartList result = new SmartList();
        ASTNode currentOpenTag = null;
        for (ASTNode phpTag : PhpOpenCloseTagsRemoveProcessor.getPhpTagsSortedByOffset(file.getNode())) {
            if (OPEN_TAGS_TOKEN_SET.contains(phpTag.getElementType())) {
                if (currentOpenTag != null) {
                    List<TextRange> list = Collections.emptyList();
                    if (list == null) {
                        PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(12);
                    }
                    return list;
                }
                currentOpenTag = phpTag;
                continue;
            }
            if (currentOpenTag == null) {
                List<TextRange> list = Collections.emptyList();
                if (list == null) {
                    PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(13);
                }
                return list;
            }
            result.add(PhpOpenCloseTagsRemoveProcessor.getRangeBetweenTags(currentOpenTag, phpTag));
            currentOpenTag = null;
        }
        if (currentOpenTag != null) {
            result.add(PhpOpenCloseTagsRemoveProcessor.getRangeBetweenTags(currentOpenTag, null));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    @NotNull
    private static TreeSet<ASTNode> getPhpTagsSortedByOffset(ASTNode node) {
        TreeSet<ASTNode> phpTags = new TreeSet<ASTNode>(Comparator.comparingInt(ASTNode::getStartOffset));
        if (node != null) {
            for (ASTNode astNode : SyntaxTraverser.astTraverser((ASTNode)node).traverse(TreeTraversal.PRE_ORDER_DFS)) {
                if (!OPEN_TAGS_TOKEN_SET.contains(astNode.getElementType()) && astNode.getElementType() != PhpTokenTypes.PHP_CLOSING_TAG) continue;
                phpTags.add(astNode);
            }
        }
        TreeSet<ASTNode> treeSet = phpTags;
        if (treeSet == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(15);
        }
        return treeSet;
    }

    @NotNull
    private static TextRange getRangeBetweenTags(@NotNull ASTNode openTag, @Nullable ASTNode closeTag) {
        if (openTag == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(16);
        }
        int openTagEndOffset = openTag.getTextRange().getEndOffset();
        if (closeTag == null) {
            TextRange textRange = TextRange.create((int)openTagEndOffset, (int)Integer.MAX_VALUE);
            if (textRange == null) {
                PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(17);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)openTagEndOffset, (int)closeTag.getTextRange().getStartOffset());
        if (textRange == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(18);
        }
        return textRange;
    }

    private static boolean inSuitablePhpContext(@NotNull PhpFile file, PsiElement elementAt, int offset) {
        if (file == null) {
            PhpOpenCloseTagsRemoveProcessor.$$$reportNull$$$0(19);
        }
        if (file instanceof PhpExpressionCodeFragment) {
            return false;
        }
        StringLiteralExpression parent = PhpPsiUtil.getParentOfClass(elementAt, StringLiteralExpression.class);
        return (parent == null || parent.getTextOffset() >= elementAt.getTextOffset()) && PhpPsiUtil.getParentByCondition(elementAt, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof PsiComment), (Condition<? super PsiElement>)Statement.INSTANCEOF) == null && PhpOpenCloseTagsRemoveProcessor.collectRangesBetweenPhpTags((PsiElement)file).stream().anyMatch(r -> r.containsOffset(offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 7, 10, 11, 16, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/copyPaste/PhpOpenCloseTagsRemoveProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openTag";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/copyPaste/PhpOpenCloseTagsRemoveProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeOpenAndCloseTags";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeClosingTag";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRangesBetweenPhpTags";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpTagsSortedByOffset";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeBetweenTags";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeOpenAndCloseTags";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeClosingTag";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWhiteSpace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectRangesBetweenPhpTags";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRangeBetweenTags";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inSuitablePhpContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 7, 10, 11, 16, 19 -> new IllegalArgumentException(string);
        };
    }
}

