/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste.importReferences;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.actions.copyPaste.importReferences.PhpReferenceInfo;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportReferencesDialog
extends DialogWrapper {
    private final String myCommonElementsName;
    @NotNull
    private Collection<PhpReferenceInfo> myReferences;
    private final Map<PhpReferenceInfo, Collection<String>> myPossibleAliases;
    private final Map<String, String> myAliasFromTargetScopeReplacements;
    private JBTable myTable;
    private ListTableModel<PhpReferenceInfoWithPossibleAliases> myModel;

    public PhpImportReferencesDialog(@Nullable Project project, @NotNull Collection<PhpReferenceInfo> references, Map<PhpReferenceInfo, Collection<String>> possibleAliases, Map<String, String> aliasFromTargetScopeReplacements) {
        if (references == null) {
            PhpImportReferencesDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myReferences = references;
        this.myPossibleAliases = possibleAliases;
        this.myAliasFromTargetScopeReplacements = aliasFromTargetScopeReplacements;
        this.myCommonElementsName = this.getElementsCommonName();
        this.init();
        this.setTitle(PhpBundle.message("import.references.on.paste.dialog.title", StringUtil.capitalize((String)this.myCommonElementsName)));
        this.myTable.getSelectionModel().setSelectionInterval(0, this.myReferences.size() - 1);
    }

    @NotNull
    private String getElementsCommonName() {
        Set keywords = this.myReferences.stream().map(e -> e.getKeyword()).collect(Collectors.toSet());
        PhpGroupUseElement.PhpUseKeyword onlyKeyword = (PhpGroupUseElement.PhpUseKeyword)((Object)ContainerUtil.getOnlyItem(keywords));
        if (onlyKeyword == PhpGroupUseElement.PhpUseKeyword.CLASS) {
            return "classes";
        }
        if (onlyKeyword == PhpGroupUseElement.PhpUseKeyword.FUNCTION) {
            return "functions";
        }
        if (onlyKeyword == PhpGroupUseElement.PhpUseKeyword.CONSTANT) {
            return "constants";
        }
        return "Elements";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 4));
        this.myModel = new ListTableModel(new ColumnInfo[]{new PhpReferenceInfoColumnInfo(), new PhpPossibleAliasesColumnInfo()});
        ArrayList items = new ArrayList(ContainerUtil.map(this.myReferences, r -> new PhpReferenceInfoWithPossibleAliases((PhpReferenceInfo)r, this.myPossibleAliases.getOrDefault(r, Collections.emptySet()))));
        this.myModel.setItems(items);
        this.myTable = new TableView(this.myModel);
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable), "Center");
        panel.add((Component)new JBLabel(PhpBundle.message("import.references.on.paste.dialog.message", this.myCommonElementsName), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), "North");
        JPanel buttonPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JButton okButton = new JButton(CommonBundle.getOkButtonText());
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(CommonBundle.getCancelButtonText());
        buttonPanel.add(cancelButton);
        panel.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        return panel;
    }

    protected void doOKAction() {
        int[] rows = this.myTable.getSelectedRows();
        this.myReferences = new ArrayList<PhpReferenceInfo>(rows.length);
        for (int row : rows) {
            PhpReferenceInfoWithPossibleAliases e = (PhpReferenceInfoWithPossibleAliases)this.myModel.getItems().get(row);
            this.myReferences.add(e.myOriginalReferenceInfo);
            if (e.mySelectedAlias == null) continue;
            this.myAliasFromTargetScopeReplacements.put(e.myOriginalReferenceInfo.getFqn(), e.mySelectedAlias);
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.jetbrains.php.actions.copyPaste.importReferences.PhpImportReferencesDialog";
    }

    public Collection<PhpReferenceInfo> getSelectedElements() {
        return this.myReferences;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/jetbrains/php/actions/copyPaste/importReferences/PhpImportReferencesDialog", "<init>"));
    }

    private static final class PhpReferenceInfoColumnInfo
    extends ColumnInfo<PhpReferenceInfoWithPossibleAliases, String> {
        private PhpReferenceInfoColumnInfo() {
            super(PhpBundle.message("reference", new Object[0]));
        }

        @Nullable
        public String valueOf(PhpReferenceInfoWithPossibleAliases referenceInfo) {
            return referenceInfo.myOriginalReferenceInfo.getFqn();
        }

        @Nullable
        public TableCellRenderer getRenderer(final PhpReferenceInfoWithPossibleAliases referenceInfo) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setText(this.getReferenceText());
                    if (referenceInfo.myOriginalReferenceInfo.getAliasName() != null) {
                        this.setFont(this.getFont().deriveFont(2));
                    }
                    this.setIcon(1.getIcon(referenceInfo));
                    return this;
                }

                @NotNull
                @NlsSafe
                private String getReferenceText() {
                    String text = PhpLangUtil.toPresentableFQN(referenceInfo.myOriginalReferenceInfo.getFqn());
                    if (referenceInfo.myOriginalReferenceInfo.getAliasName() != null) {
                        String string = text + " (" + referenceInfo.myOriginalReferenceInfo.getAliasName() + ")";
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }
                    String string = text;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static Icon getIcon(PhpReferenceInfoWithPossibleAliases referenceInfo2) {
                    return switch (referenceInfo2.myOriginalReferenceInfo.getKeyword()) {
                        case PhpGroupUseElement.PhpUseKeyword.CONSTANT -> PhpIcons.CONSTANT;
                        case PhpGroupUseElement.PhpUseKeyword.FUNCTION -> PhpIcons.FUNCTION;
                        default -> PhpIcons.CLASS;
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/actions/copyPaste/importReferences/PhpImportReferencesDialog$PhpReferenceInfoColumnInfo$1", "getReferenceText"));
                }
            };
        }
    }

    private static final class PhpPossibleAliasesColumnInfo
    extends ColumnInfo<PhpReferenceInfoWithPossibleAliases, String> {
        private static final String NO_ALIAS = "<no alias>";
        private static final String[] EMPTY_STRINGS = new String[0];

        private PhpPossibleAliasesColumnInfo() {
            super(PhpBundle.message("replace.with.alias.from.target.scope", new Object[0]));
        }

        @Nullable
        public TableCellRenderer getRenderer(PhpReferenceInfoWithPossibleAliases info) {
            return new ComboBoxTableRenderer((Object[])((String[])ArrayUtil.prepend((Object)NO_ALIAS, (Object[])info.myPossibleAliasesFromScope.toArray(EMPTY_STRINGS)))).withClickCount(1);
        }

        @Nullable
        public TableCellEditor getEditor(PhpReferenceInfoWithPossibleAliases info) {
            return new ComboBoxTableRenderer((Object[])((String[])ArrayUtil.prepend((Object)NO_ALIAS, (Object[])info.myPossibleAliasesFromScope.toArray(EMPTY_STRINGS)))).withClickCount(1);
        }

        public void setValue(PhpReferenceInfoWithPossibleAliases aliases, String value) {
            aliases.mySelectedAlias = value.equals(NO_ALIAS) ? null : value;
        }

        @Nullable
        public String valueOf(PhpReferenceInfoWithPossibleAliases info) {
            if (info.myPossibleAliasesFromScope.isEmpty()) {
                return null;
            }
            return StringUtil.notNullize((String)info.mySelectedAlias, (String)NO_ALIAS);
        }

        public boolean isCellEditable(PhpReferenceInfoWithPossibleAliases aliases) {
            return !aliases.myPossibleAliasesFromScope.isEmpty();
        }
    }

    private static final class PhpReferenceInfoWithPossibleAliases {
        private final PhpReferenceInfo myOriginalReferenceInfo;
        private final Collection<String> myPossibleAliasesFromScope;
        @Nullable
        private String mySelectedAlias;

        private PhpReferenceInfoWithPossibleAliases(PhpReferenceInfo originalReferenceInfo, Collection<String> possibleAliasesFromScope) {
            this.myOriginalReferenceInfo = originalReferenceInfo;
            this.myPossibleAliasesFromScope = possibleAliasesFromScope;
            this.mySelectedAlias = null;
        }
    }
}

